
package org.jbpm.serverless.workflow.api.choices;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.jbpm.serverless.workflow.api.interfaces.Choice;
import org.jbpm.serverless.workflow.api.transitions.Transition;


/**
 * And Choice
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "and",
    "transition"
})
public class AndChoice implements Serializable, Choice
{

    /**
     * List of choices
     * (Required)
     * 
     */
    @JsonProperty("and")
    @JsonPropertyDescription("List of choices")
    @Valid
    @NotNull
    private List<DefaultChoice> and = new ArrayList<DefaultChoice>();
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("transition")
    @Valid
    @NotNull
    private Transition transition;
    private final static long serialVersionUID = -1445780888149754795L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public AndChoice() {
    }

    /**
     * 
     * @param and
     * @param transition
     */
    public AndChoice(List<DefaultChoice> and, Transition transition) {
        super();
        this.and = and;
        this.transition = transition;
    }

    /**
     * List of choices
     * (Required)
     * 
     */
    @JsonProperty("and")
    public List<DefaultChoice> getAnd() {
        return and;
    }

    /**
     * List of choices
     * (Required)
     * 
     */
    @JsonProperty("and")
    public void setAnd(List<DefaultChoice> and) {
        this.and = and;
    }

    public AndChoice withAnd(List<DefaultChoice> and) {
        this.and = and;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("transition")
    public Transition getTransition() {
        return transition;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("transition")
    public void setTransition(Transition transition) {
        this.transition = transition;
    }

    public AndChoice withTransition(Transition transition) {
        this.transition = transition;
        return this;
    }

}
