
package org.jbpm.serverless.workflow.api.choices;

import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.jbpm.serverless.workflow.api.interfaces.Choice;
import org.jbpm.serverless.workflow.api.transitions.Transition;


/**
 * Not Choice
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "not",
    "transition"
})
public class NotChoice implements Serializable, Choice
{

    /**
     * Default Choice
     * (Required)
     * 
     */
    @JsonProperty("not")
    @JsonPropertyDescription("Default Choice")
    @Valid
    @NotNull
    private DefaultChoice not;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("transition")
    @Valid
    @NotNull
    private Transition transition;
    private final static long serialVersionUID = 1134269412456451710L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public NotChoice() {
    }

    /**
     * 
     * @param not
     * @param transition
     */
    public NotChoice(DefaultChoice not, Transition transition) {
        super();
        this.not = not;
        this.transition = transition;
    }

    /**
     * Default Choice
     * (Required)
     * 
     */
    @JsonProperty("not")
    public DefaultChoice getNot() {
        return not;
    }

    /**
     * Default Choice
     * (Required)
     * 
     */
    @JsonProperty("not")
    public void setNot(DefaultChoice not) {
        this.not = not;
    }

    public NotChoice withNot(DefaultChoice not) {
        this.not = not;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("transition")
    public Transition getTransition() {
        return transition;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("transition")
    public void setTransition(Transition transition) {
        this.transition = transition;
    }

    public NotChoice withTransition(Transition transition) {
        this.transition = transition;
        return this;
    }

}
