
package org.jbpm.serverless.workflow.api.filters;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "dataInputPath",
    "dataOutputPath"
})
public class StateDataFilter implements Serializable
{

    /**
     * JSONPath definition that selects parts of the states data input
     * 
     */
    @JsonProperty("dataInputPath")
    @JsonPropertyDescription("JSONPath definition that selects parts of the states data input")
    private String dataInputPath;
    /**
     * JSONPath definition that selects parts of the states data output
     * 
     */
    @JsonProperty("dataOutputPath")
    @JsonPropertyDescription("JSONPath definition that selects parts of the states data output")
    private String dataOutputPath;
    private final static long serialVersionUID = 733284307749962351L;

    /**
     * JSONPath definition that selects parts of the states data input
     * 
     */
    @JsonProperty("dataInputPath")
    public String getDataInputPath() {
        return dataInputPath;
    }

    /**
     * JSONPath definition that selects parts of the states data input
     * 
     */
    @JsonProperty("dataInputPath")
    public void setDataInputPath(String dataInputPath) {
        this.dataInputPath = dataInputPath;
    }

    public StateDataFilter withDataInputPath(String dataInputPath) {
        this.dataInputPath = dataInputPath;
        return this;
    }

    /**
     * JSONPath definition that selects parts of the states data output
     * 
     */
    @JsonProperty("dataOutputPath")
    public String getDataOutputPath() {
        return dataOutputPath;
    }

    /**
     * JSONPath definition that selects parts of the states data output
     * 
     */
    @JsonProperty("dataOutputPath")
    public void setDataOutputPath(String dataOutputPath) {
        this.dataOutputPath = dataOutputPath;
    }

    public StateDataFilter withDataOutputPath(String dataOutputPath) {
        this.dataOutputPath = dataOutputPath;
        return this;
    }

}
