
package org.jbpm.serverless.workflow.api.states;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonNode;
import org.jbpm.serverless.workflow.api.end.End;
import org.jbpm.serverless.workflow.api.error.Error;
import org.jbpm.serverless.workflow.api.filters.StateDataFilter;
import org.jbpm.serverless.workflow.api.interfaces.State;
import org.jbpm.serverless.workflow.api.retry.Retry;
import org.jbpm.serverless.workflow.api.start.Start;
import org.jbpm.serverless.workflow.api.transitions.Transition;


/**
 * Set up and relay the state's data input to data output. Does not perform any actions
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "inject"
})
public class RelayState
    extends DefaultState
    implements Serializable, State
{

    /**
     * JSON object which can be set as states data input and can be manipulated via filters
     * (Required)
     * 
     */
    @JsonProperty("inject")
    @JsonPropertyDescription("JSON object which can be set as states data input and can be manipulated via filters")
    @Valid
    @NotNull
    private JsonNode inject;
    private final static long serialVersionUID = 542120410969178671L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public RelayState() {
    }

    /**
     * 
     * @param name
     * @param type
     * @param inject
     */
    public RelayState(JsonNode inject, java.lang.String name, DefaultState.Type type) {
        super(name, type);
        this.inject = inject;
    }

    /**
     * JSON object which can be set as states data input and can be manipulated via filters
     * (Required)
     * 
     */
    @JsonProperty("inject")
    public JsonNode getInject() {
        return inject;
    }

    /**
     * JSON object which can be set as states data input and can be manipulated via filters
     * (Required)
     * 
     */
    @JsonProperty("inject")
    public void setInject(JsonNode inject) {
        this.inject = inject;
    }

    public RelayState withInject(JsonNode inject) {
        this.inject = inject;
        return this;
    }

    @Override
    public RelayState withId(java.lang.String id) {
        super.withId(id);
        return this;
    }

    @Override
    public RelayState withName(java.lang.String name) {
        super.withName(name);
        return this;
    }

    @Override
    public RelayState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public RelayState withStart(Start start) {
        super.withStart(start);
        return this;
    }

    @Override
    public RelayState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public RelayState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public RelayState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public RelayState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public RelayState withDataInputSchema(java.lang.String dataInputSchema) {
        super.withDataInputSchema(dataInputSchema);
        return this;
    }

    @Override
    public RelayState withDataOutputSchema(java.lang.String dataOutputSchema) {
        super.withDataOutputSchema(dataOutputSchema);
        return this;
    }

    @Override
    public RelayState withOnError(List<Error> onError) {
        super.withOnError(onError);
        return this;
    }

    @Override
    public RelayState withRetry(List<Retry> retry) {
        super.withRetry(retry);
        return this;
    }

}
