/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow;

import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.serverless.workflow.BaseServerlessTest;
import org.jbpm.workflow.core.Constraint;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.Join;
import org.jbpm.workflow.core.node.Split;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.core.node.TimerNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.kie.api.definition.process.Node;

public class ServlerlessWorkflowParsingTest
extends BaseServerlessTest {
    @ParameterizedTest
    @ValueSource(strings={"/exec/single-operation.sw.json", "/exec/single-operation.sw.yml"})
    public void testSingleOperationWorkflow(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation).parseWorkFlow(this.classpathResourceReader(workflowLocation));
        Assertions.assertEquals((Object)"function", (Object)process.getId());
        Assertions.assertEquals((Object)"test-wf", (Object)process.getName());
        Assertions.assertEquals((Object)"1.0", (Object)process.getVersion());
        Assertions.assertEquals((Object)"org.kie.kogito.serverless", (Object)process.getPackageName());
        Assertions.assertEquals((Object)"Public", (Object)process.getVisibility());
        Assertions.assertEquals((int)3, (int)process.getNodes().length);
        Node node = process.getNodes()[0];
        Assertions.assertTrue((boolean)(node instanceof StartNode));
        node = process.getNodes()[2];
        Assertions.assertTrue((boolean)(node instanceof CompositeContextNode));
        node = process.getNodes()[1];
        Assertions.assertTrue((boolean)(node instanceof EndNode));
        CompositeContextNode compositeNode = (CompositeContextNode)process.getNodes()[2];
        Assertions.assertEquals((int)3, (int)compositeNode.getNodes().length);
        node = compositeNode.getNodes()[0];
        Assertions.assertTrue((boolean)(node instanceof StartNode));
        node = compositeNode.getNodes()[1];
        Assertions.assertTrue((boolean)(node instanceof ActionNode));
        node = compositeNode.getNodes()[2];
        Assertions.assertTrue((boolean)(node instanceof EndNode));
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/single-operation-with-delay.sw.json", "/exec/single-operation-with-delay.sw.yml"})
    public void testSingleOperationWithDelayWorkflow(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation).parseWorkFlow(this.classpathResourceReader(workflowLocation));
        Assertions.assertEquals((Object)"function", (Object)process.getId());
        Assertions.assertEquals((Object)"test-wf", (Object)process.getName());
        Assertions.assertEquals((Object)"1.0", (Object)process.getVersion());
        Assertions.assertEquals((Object)"org.kie.kogito.serverless", (Object)process.getPackageName());
        Assertions.assertEquals((Object)"Public", (Object)process.getVisibility());
        Assertions.assertEquals((int)4, (int)process.getNodes().length);
        Node node = process.getNodes()[0];
        Assertions.assertTrue((boolean)(node instanceof StartNode));
        node = process.getNodes()[2];
        Assertions.assertTrue((boolean)(node instanceof CompositeContextNode));
        node = process.getNodes()[3];
        Assertions.assertTrue((boolean)(node instanceof TimerNode));
        node = process.getNodes()[1];
        Assertions.assertTrue((boolean)(node instanceof EndNode));
        CompositeContextNode compositeNode = (CompositeContextNode)process.getNodes()[2];
        Assertions.assertEquals((int)3, (int)compositeNode.getNodes().length);
        node = compositeNode.getNodes()[0];
        Assertions.assertTrue((boolean)(node instanceof StartNode));
        node = compositeNode.getNodes()[1];
        Assertions.assertTrue((boolean)(node instanceof ActionNode));
        node = compositeNode.getNodes()[2];
        Assertions.assertTrue((boolean)(node instanceof EndNode));
        TimerNode timerNode = (TimerNode)process.getNodes()[3];
        Assertions.assertEquals((Object)"PT1S", (Object)timerNode.getTimer().getDelay());
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/single-service-operation.sw.json", "/exec/single-service-operation.sw.yml"})
    public void testSingleServiceOperationWorkflow(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation).parseWorkFlow(this.classpathResourceReader(workflowLocation));
        Assertions.assertEquals((Object)"function", (Object)process.getId());
        Assertions.assertEquals((Object)"test-wf", (Object)process.getName());
        Assertions.assertEquals((Object)"1.0", (Object)process.getVersion());
        Assertions.assertEquals((Object)"org.kie.kogito.serverless", (Object)process.getPackageName());
        Assertions.assertEquals((Object)"Public", (Object)process.getVisibility());
        Assertions.assertEquals((int)3, (int)process.getNodes().length);
        Node node = process.getNodes()[0];
        Assertions.assertTrue((boolean)(node instanceof StartNode));
        node = process.getNodes()[2];
        Assertions.assertTrue((boolean)(node instanceof CompositeContextNode));
        node = process.getNodes()[1];
        Assertions.assertTrue((boolean)(node instanceof EndNode));
        CompositeContextNode compositeNode = (CompositeContextNode)process.getNodes()[2];
        Assertions.assertEquals((int)3, (int)compositeNode.getNodes().length);
        node = compositeNode.getNodes()[0];
        Assertions.assertTrue((boolean)(node instanceof StartNode));
        node = compositeNode.getNodes()[1];
        Assertions.assertTrue((boolean)(node instanceof WorkItemNode));
        node = compositeNode.getNodes()[2];
        Assertions.assertTrue((boolean)(node instanceof EndNode));
        WorkItemNode workItemNode = (WorkItemNode)compositeNode.getNodes()[1];
        Assertions.assertEquals((Object)"helloWorld", (Object)workItemNode.getName());
        Assertions.assertEquals((Object)"org.something.other.TestService", (Object)workItemNode.getWork().getParameter("Interface"));
        Assertions.assertEquals((Object)"get", (Object)workItemNode.getWork().getParameter("Operation"));
        Assertions.assertEquals((Object)"org.something.other.TestService", (Object)workItemNode.getWork().getParameter("interfaceImplementationRef"));
        Assertions.assertEquals((Object)"get", (Object)workItemNode.getWork().getParameter("operationImplementationRef"));
        Assertions.assertEquals((Object)"Java", (Object)workItemNode.getWork().getParameter("implementation"));
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/single-subflow.sw.json", "/exec/single-subflow.sw.yml"})
    public void testSingleSubFlowWorkflow(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation).parseWorkFlow(this.classpathResourceReader(workflowLocation));
        Assertions.assertEquals((Object)"function", (Object)process.getId());
        Assertions.assertEquals((Object)"test-wf", (Object)process.getName());
        Assertions.assertEquals((Object)"1.0", (Object)process.getVersion());
        Assertions.assertEquals((Object)"org.kie.kogito.serverless", (Object)process.getPackageName());
        Assertions.assertEquals((Object)"Public", (Object)process.getVisibility());
        Assertions.assertEquals((int)3, (int)process.getNodes().length);
        Node node = process.getNodes()[0];
        Assertions.assertTrue((boolean)(node instanceof StartNode));
        node = process.getNodes()[2];
        Assertions.assertTrue((boolean)(node instanceof SubProcessNode));
        node = process.getNodes()[1];
        Assertions.assertTrue((boolean)(node instanceof EndNode));
        SubProcessNode subProcessNode = (SubProcessNode)process.getNodes()[2];
        Assertions.assertEquals((Object)"abc", (Object)subProcessNode.getProcessId());
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/single-eventstate.sw.json", "/exec/single-eventstate.sw.yml"})
    public void testSingleEventStateWorkflow(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation).parseWorkFlow(this.classpathResourceReader(workflowLocation));
        Assertions.assertEquals((Object)"function", (Object)process.getId());
        Assertions.assertEquals((Object)"test-wf", (Object)process.getName());
        Assertions.assertEquals((Object)"1.0", (Object)process.getVersion());
        Assertions.assertEquals((Object)"org.kie.kogito.serverless", (Object)process.getPackageName());
        Assertions.assertEquals((Object)"Public", (Object)process.getVisibility());
        Assertions.assertEquals((int)3, (int)process.getNodes().length);
        Node node = process.getNodes()[2];
        Assertions.assertTrue((boolean)(node instanceof CompositeContextNode));
        node = process.getNodes()[0];
        Assertions.assertTrue((boolean)(node instanceof StartNode));
        node = process.getNodes()[1];
        Assertions.assertTrue((boolean)(node instanceof EndNode));
        CompositeContextNode compositeNode = (CompositeContextNode)process.getNodes()[2];
        Assertions.assertEquals((int)3, (int)compositeNode.getNodes().length);
        node = compositeNode.getNodes()[0];
        Assertions.assertTrue((boolean)(node instanceof StartNode));
        node = compositeNode.getNodes()[1];
        Assertions.assertTrue((boolean)(node instanceof ActionNode));
        node = compositeNode.getNodes()[2];
        Assertions.assertTrue((boolean)(node instanceof EndNode));
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/single-operation-many-functions.sw.json", "/exec/single-operation-many-functions.sw.yml"})
    public void testSingleOperationWithManyFunctionsWorkflow(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation).parseWorkFlow(this.classpathResourceReader(workflowLocation));
        Assertions.assertEquals((Object)"function", (Object)process.getId());
        Assertions.assertEquals((Object)"test-wf", (Object)process.getName());
        Assertions.assertEquals((Object)"1.0", (Object)process.getVersion());
        Assertions.assertEquals((Object)"org.kie.kogito.serverless", (Object)process.getPackageName());
        Assertions.assertEquals((Object)"Public", (Object)process.getVisibility());
        Assertions.assertEquals((int)3, (int)process.getNodes().length);
        Node node = process.getNodes()[0];
        Assertions.assertTrue((boolean)(node instanceof StartNode));
        node = process.getNodes()[2];
        Assertions.assertTrue((boolean)(node instanceof CompositeContextNode));
        node = process.getNodes()[1];
        Assertions.assertTrue((boolean)(node instanceof EndNode));
        CompositeContextNode compositeNode = (CompositeContextNode)process.getNodes()[2];
        Assertions.assertEquals((int)4, (int)compositeNode.getNodes().length);
        node = compositeNode.getNodes()[0];
        Assertions.assertTrue((boolean)(node instanceof StartNode));
        node = compositeNode.getNodes()[1];
        Assertions.assertTrue((boolean)(node instanceof ActionNode));
        node = compositeNode.getNodes()[2];
        Assertions.assertTrue((boolean)(node instanceof ActionNode));
        node = compositeNode.getNodes()[3];
        Assertions.assertTrue((boolean)(node instanceof EndNode));
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/multiple-operations.sw.json", "/exec/multiple-operations.sw.yml"})
    public void testMultipleOperationWorkflow(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation).parseWorkFlow(this.classpathResourceReader(workflowLocation));
        Assertions.assertEquals((Object)"function", (Object)process.getId());
        Assertions.assertEquals((Object)"test-wf", (Object)process.getName());
        Assertions.assertEquals((Object)"1.0", (Object)process.getVersion());
        Assertions.assertEquals((Object)"org.kie.kogito.serverless", (Object)process.getPackageName());
        Assertions.assertEquals((Object)"Public", (Object)process.getVisibility());
        Assertions.assertEquals((int)5, (int)process.getNodes().length);
        Node node = process.getNodes()[0];
        Assertions.assertTrue((boolean)(node instanceof StartNode));
        node = process.getNodes()[2];
        Assertions.assertTrue((boolean)(node instanceof CompositeContextNode));
        node = process.getNodes()[3];
        Assertions.assertTrue((boolean)(node instanceof CompositeContextNode));
        node = process.getNodes()[4];
        Assertions.assertTrue((boolean)(node instanceof CompositeContextNode));
        node = process.getNodes()[1];
        Assertions.assertTrue((boolean)(node instanceof EndNode));
        CompositeContextNode compositeNode = (CompositeContextNode)process.getNodes()[2];
        Assertions.assertEquals((int)3, (int)compositeNode.getNodes().length);
        node = compositeNode.getNodes()[0];
        Assertions.assertTrue((boolean)(node instanceof StartNode));
        node = compositeNode.getNodes()[1];
        Assertions.assertTrue((boolean)(node instanceof ActionNode));
        node = compositeNode.getNodes()[2];
        Assertions.assertTrue((boolean)(node instanceof EndNode));
        compositeNode = (CompositeContextNode)process.getNodes()[3];
        Assertions.assertEquals((int)3, (int)compositeNode.getNodes().length);
        node = compositeNode.getNodes()[0];
        Assertions.assertTrue((boolean)(node instanceof StartNode));
        node = compositeNode.getNodes()[1];
        Assertions.assertTrue((boolean)(node instanceof ActionNode));
        node = compositeNode.getNodes()[2];
        Assertions.assertTrue((boolean)(node instanceof EndNode));
        compositeNode = (CompositeContextNode)process.getNodes()[4];
        Assertions.assertEquals((int)3, (int)compositeNode.getNodes().length);
        node = compositeNode.getNodes()[0];
        Assertions.assertTrue((boolean)(node instanceof StartNode));
        node = compositeNode.getNodes()[1];
        Assertions.assertTrue((boolean)(node instanceof ActionNode));
        node = compositeNode.getNodes()[2];
        Assertions.assertTrue((boolean)(node instanceof EndNode));
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/single-relay-state.sw.json", "/exec/single-relay-state.sw.yml"})
    public void testSingleRelayWorkflow(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation).parseWorkFlow(this.classpathResourceReader(workflowLocation));
        Assertions.assertEquals((Object)"function", (Object)process.getId());
        Assertions.assertEquals((Object)"test-wf", (Object)process.getName());
        Assertions.assertEquals((Object)"1.0", (Object)process.getVersion());
        Assertions.assertEquals((Object)"org.kie.kogito.serverless", (Object)process.getPackageName());
        Assertions.assertEquals((Object)"Public", (Object)process.getVisibility());
        Assertions.assertEquals((int)3, (int)process.getNodes().length);
        Node node = process.getNodes()[0];
        Assertions.assertTrue((boolean)(node instanceof StartNode));
        node = process.getNodes()[2];
        Assertions.assertTrue((boolean)(node instanceof ActionNode));
        node = process.getNodes()[1];
        Assertions.assertTrue((boolean)(node instanceof EndNode));
        ActionNode actionNode = (ActionNode)process.getNodes()[2];
        Assertions.assertEquals((Object)"SimpleRelay", (Object)actionNode.getName());
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/switch-state.sw.json", "/exec/switch-state.sw.yml"})
    public void testSwitchWorkflow(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation).parseWorkFlow(this.classpathResourceReader(workflowLocation));
        Assertions.assertEquals((Object)"switchworkflow", (Object)process.getId());
        Assertions.assertEquals((Object)"switch-wf", (Object)process.getName());
        Assertions.assertEquals((Object)"1.0", (Object)process.getVersion());
        Assertions.assertEquals((Object)"org.kie.kogito.serverless", (Object)process.getPackageName());
        Assertions.assertEquals((Object)"Public", (Object)process.getVisibility());
        Assertions.assertEquals((int)7, (int)process.getNodes().length);
        Node node = process.getNodes()[0];
        Assertions.assertTrue((boolean)(node instanceof StartNode));
        node = process.getNodes()[1];
        Assertions.assertTrue((boolean)(node instanceof EndNode));
        node = process.getNodes()[2];
        Assertions.assertTrue((boolean)(node instanceof EndNode));
        node = process.getNodes()[3];
        Assertions.assertTrue((boolean)(node instanceof ActionNode));
        node = process.getNodes()[4];
        Assertions.assertTrue((boolean)(node instanceof Split));
        node = process.getNodes()[5];
        Assertions.assertTrue((boolean)(node instanceof ActionNode));
        node = process.getNodes()[6];
        Assertions.assertTrue((boolean)(node instanceof ActionNode));
        Split split = (Split)process.getNodes()[4];
        Assertions.assertEquals((Object)"ChooseOnAge", (Object)split.getName());
        Assertions.assertEquals((int)2, (int)split.getType());
        Assertions.assertEquals((int)2, (int)split.getConstraints().size());
        boolean haveDefaultConstraint = false;
        for (Constraint constraint : split.getConstraints().values()) {
            haveDefaultConstraint = haveDefaultConstraint || constraint.isDefault();
        }
        Assertions.assertTrue((boolean)haveDefaultConstraint);
    }

    @ParameterizedTest
    @ValueSource(strings={"/exec/parallel-state.sw.json", "/exec/parallel-state.sw.yml"})
    public void testParallelWorkflow(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation).parseWorkFlow(this.classpathResourceReader(workflowLocation));
        Assertions.assertEquals((Object)"parallelworkflow", (Object)process.getId());
        Assertions.assertEquals((Object)"parallel-wf", (Object)process.getName());
        Assertions.assertEquals((Object)"1.0", (Object)process.getVersion());
        Assertions.assertEquals((Object)"org.kie.kogito.serverless", (Object)process.getPackageName());
        Assertions.assertEquals((Object)"Public", (Object)process.getVisibility());
        Assertions.assertEquals((int)6, (int)process.getNodes().length);
        Node node = process.getNodes()[0];
        Assertions.assertTrue((boolean)(node instanceof StartNode));
        node = process.getNodes()[1];
        Assertions.assertTrue((boolean)(node instanceof EndNode));
        node = process.getNodes()[2];
        Assertions.assertTrue((boolean)(node instanceof Split));
        node = process.getNodes()[3];
        Assertions.assertTrue((boolean)(node instanceof Join));
        node = process.getNodes()[4];
        Assertions.assertTrue((boolean)(node instanceof SubProcessNode));
        node = process.getNodes()[5];
        Assertions.assertTrue((boolean)(node instanceof SubProcessNode));
    }

    @ParameterizedTest
    @ValueSource(strings={"/specexamples/helloworld.sw.json", "/specexamples/helloworld.sw.yml", "/specexamples/greeting.sw.json", "/specexamples/greeting.sw.yml", "/specexamples/eventbasedgreeting.sw.json", "/specexamples/eventbasedgreeting.sw.yml", "/specexamples/solvemathproblems.sw.json", "/specexamples/solvemathproblems.sw.yml", "/specexamples/parallel.sw.json", "/specexamples/parallel.sw.yml", "/specexamples/jobmonitoring.sw.json", "/specexamples/jobmonitoring.sw.yml", "/specexamples/sendcloudevent.sw.json", "/specexamples/sendcloudevent.sw.yml", "/specexamples/monitorpatient.sw.json", "/specexamples/monitorpatient.sw.yml", "/specexamples/finalizecollegeapplication.sw.json", "/specexamples/finalizecollegeapplication.sw.yml", "/specexamples/creditcheck.sw.json", "/specexamples/creditcheck.sw.yml"})
    public void testSpecExamplesParsing(String workflowLocation) throws Exception {
        RuleFlowProcess process = (RuleFlowProcess)this.getWorkflowParser(workflowLocation).parseWorkFlow(this.classpathResourceReader(workflowLocation));
        Assertions.assertNotNull((Object)process);
    }
}

