/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jbpm.serverless.workflow.BaseServerlessTest;
import org.jbpm.serverless.workflow.api.Workflow;
import org.jbpm.serverless.workflow.api.choices.DefaultChoice;
import org.jbpm.serverless.workflow.api.events.EventDefinition;
import org.jbpm.serverless.workflow.api.interfaces.State;
import org.jbpm.serverless.workflow.api.mapper.BaseObjectMapper;
import org.jbpm.serverless.workflow.api.mapper.JsonObjectMapper;
import org.jbpm.serverless.workflow.api.mapper.YamlObjectMapper;
import org.jbpm.serverless.workflow.api.states.DefaultState;
import org.jbpm.serverless.workflow.api.states.RelayState;
import org.jbpm.serverless.workflow.parser.util.ServerlessWorkflowUtils;
import org.junit.jupiter.api.Test;

public class WorkflowUtilsTest
extends BaseServerlessTest {
    @Test
    public void testGetObjectMapper() {
        BaseObjectMapper objectMapper = ServerlessWorkflowUtils.getObjectMapper((String)"json");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)objectMapper);
        Assertions.assertThat((Object)objectMapper).isInstanceOf(JsonObjectMapper.class);
        objectMapper = ServerlessWorkflowUtils.getObjectMapper((String)"yml");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)objectMapper);
        Assertions.assertThat((Object)objectMapper).isInstanceOf(YamlObjectMapper.class);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ServerlessWorkflowUtils.getObjectMapper((String)"unsupported"));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> ServerlessWorkflowUtils.getObjectMapper(null));
    }

    @Test
    public void testGetWorkflowStartState() {
        Assertions.assertThat((Object)ServerlessWorkflowUtils.getWorkflowStartState((Workflow)singleRelayStateWorkflow)).isNotNull();
        Assertions.assertThat((Object)ServerlessWorkflowUtils.getWorkflowStartState((Workflow)singleRelayStateWorkflow)).isInstanceOf(RelayState.class);
    }

    @Test
    public void testGetWorkflowEndStatesSingle() {
        List endStates = ServerlessWorkflowUtils.getWorkflowEndStates((Workflow)singleRelayStateWorkflow);
        Assertions.assertThat((List)endStates).isNotNull();
        Assertions.assertThat((List)endStates).hasSize(1);
        State endState = (State)endStates.get(0);
        Assertions.assertThat((Object)endState).isNotNull();
        Assertions.assertThat((Object)endState).isInstanceOf(RelayState.class);
    }

    @Test
    public void testGetWorkflowEndStatesMulti() {
        List endStates = ServerlessWorkflowUtils.getWorkflowEndStates((Workflow)multiRelayStateWorkflow);
        Assertions.assertThat((List)endStates).isNotNull();
        Assertions.assertThat((List)endStates).hasSize(2);
        State endState1 = (State)endStates.get(0);
        Assertions.assertThat((Object)endState1).isNotNull();
        Assertions.assertThat((Object)endState1).isInstanceOf(RelayState.class);
        State endState2 = (State)endStates.get(1);
        Assertions.assertThat((Object)endState2).isNotNull();
        Assertions.assertThat((Object)endState2).isInstanceOf(RelayState.class);
    }

    @Test
    public void testGetStatesByType() {
        List relayStates = ServerlessWorkflowUtils.getStatesByType((Workflow)multiRelayStateWorkflow, (DefaultState.Type)DefaultState.Type.RELAY);
        Assertions.assertThat((List)relayStates).isNotNull();
        Assertions.assertThat((List)relayStates).hasSize(2);
        Assertions.assertThat((Object)((State)relayStates.get(0))).isInstanceOf(RelayState.class);
        Assertions.assertThat((Object)((State)relayStates.get(1))).isInstanceOf(RelayState.class);
        List noOperationStates = ServerlessWorkflowUtils.getStatesByType((Workflow)multiRelayStateWorkflow, (DefaultState.Type)DefaultState.Type.OPERATION);
        Assertions.assertThat((List)noOperationStates).isNotNull();
        Assertions.assertThat((List)noOperationStates).hasSize(0);
    }

    @Test
    public void testIncludesSupportedStates() {
        Assertions.assertThat((boolean)ServerlessWorkflowUtils.includesSupportedStates((Workflow)singleRelayStateWorkflow)).isTrue();
    }

    @Test
    public void testGetWorkflowEventFor() {
        Assertions.assertThat((Object)ServerlessWorkflowUtils.getWorkflowEventFor((Workflow)eventDefOnlyWorkflow, (String)"sampleEvent")).isNotNull();
        Assertions.assertThat((Object)ServerlessWorkflowUtils.getWorkflowEventFor((Workflow)eventDefOnlyWorkflow, (String)"sampleEvent")).isInstanceOf(EventDefinition.class);
    }

    @Test
    public void testSysOutFunctionScript() {
        String script = "$.a $.b";
        Assertions.assertThat((String)ServerlessWorkflowUtils.sysOutFunctionScript((String)script)).isNotNull();
    }

    @Test
    public void testGetJsonPathScript() {
        String script = "$.a $.b";
        Assertions.assertThat((String)ServerlessWorkflowUtils.getJsonPathScript((String)script)).isNotNull();
    }

    @Test
    public void testGetInjectScript() throws Exception {
        String toInject = "{\n  \"name\": \"john\"\n}";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode toInjectObj = mapper.readTree(toInject);
        Assertions.assertThat((String)ServerlessWorkflowUtils.getInjectScript((JsonNode)toInjectObj)).isNotNull();
    }

    @Test
    public void testConditionScript() throws Exception {
        Assertions.assertThat((String)ServerlessWorkflowUtils.conditionScript((String)"$.name", (DefaultChoice.Operator)DefaultChoice.Operator.EQUALS, (String)"john")).isNotNull();
        Assertions.assertThat((String)ServerlessWorkflowUtils.conditionScript((String)"$.name", (DefaultChoice.Operator)DefaultChoice.Operator.EQUALS, (String)"john")).isEqualTo("return workflowdata.get(\"name\").textValue().equals(\"john\");");
    }
}

