/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.api.branches;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.jbpm.serverless.workflow.api.interfaces.State;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "states", "waitForCompletion"})
public class Branch
implements Serializable {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Branch name")
    @NotNull
    private String name;
    @JsonProperty(value="states")
    @JsonPropertyDescription(value="State Definitions")
    @Valid
    @NotNull
    private List<State> states = new ArrayList<State>();
    @JsonProperty(value="waitForCompletion")
    @JsonPropertyDescription(value="Flow must wait for this branch to finish before continuing")
    @NotNull
    private boolean waitForCompletion = false;
    private static final long serialVersionUID = 8149552033065330352L;

    public Branch() {
    }

    public Branch(String name, List<State> states, boolean waitForCompletion) {
        this.name = name;
        this.states = states;
        this.waitForCompletion = waitForCompletion;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public Branch withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="states")
    public List<State> getStates() {
        return this.states;
    }

    @JsonProperty(value="states")
    public void setStates(List<State> states) {
        this.states = states;
    }

    public Branch withStates(List<State> states) {
        this.states = states;
        return this;
    }

    @JsonProperty(value="waitForCompletion")
    public boolean isWaitForCompletion() {
        return this.waitForCompletion;
    }

    @JsonProperty(value="waitForCompletion")
    public void setWaitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
    }

    public Branch withWaitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
        return this;
    }
}

