/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.api.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.jbpm.serverless.workflow.api.choices.AndChoice;
import org.jbpm.serverless.workflow.api.choices.DefaultChoice;
import org.jbpm.serverless.workflow.api.choices.NotChoice;
import org.jbpm.serverless.workflow.api.choices.OrChoice;
import org.jbpm.serverless.workflow.api.choices.SingleChoice;
import org.jbpm.serverless.workflow.api.interfaces.Choice;

public class ChoiceDeserializer
extends StdDeserializer<Choice> {
    public ChoiceDeserializer() {
        this(null);
    }

    public ChoiceDeserializer(Class<?> vc) {
        super(vc);
    }

    public Choice deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        if (node.get("and") != null) {
            return (Choice)mapper.treeToValue((TreeNode)node, AndChoice.class);
        }
        if (node.get("not") != null) {
            return (Choice)mapper.treeToValue((TreeNode)node, NotChoice.class);
        }
        if (node.get("or") != null) {
            return (Choice)mapper.treeToValue((TreeNode)node, OrChoice.class);
        }
        if (node.get("next-state") != null) {
            return (Choice)mapper.treeToValue((TreeNode)node, SingleChoice.class);
        }
        return (Choice)mapper.treeToValue((TreeNode)node, DefaultChoice.class);
    }
}

