/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.api.end;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.jbpm.serverless.workflow.api.produce.ProduceEvent;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"kind", "produceEvents"})
public class End
implements Serializable {
    @JsonProperty(value="kind")
    @JsonPropertyDescription(value="Kind of End definition")
    @NotNull
    private Kind kind = Kind.fromValue("default");
    @JsonProperty(value="produceEvents")
    @JsonPropertyDescription(value="Used if kind is event. Array of events to be produced")
    @Valid
    private List<ProduceEvent> produceEvents = new ArrayList<ProduceEvent>();
    private static final long serialVersionUID = 4819317724209403390L;

    public End() {
    }

    public End(Kind kind) {
        this.kind = kind;
    }

    @JsonProperty(value="kind")
    public Kind getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(Kind kind) {
        this.kind = kind;
    }

    public End withKind(Kind kind) {
        this.kind = kind;
        return this;
    }

    @JsonProperty(value="produceEvents")
    public List<ProduceEvent> getProduceEvents() {
        return this.produceEvents;
    }

    @JsonProperty(value="produceEvents")
    public void setProduceEvents(List<ProduceEvent> produceEvents) {
        this.produceEvents = produceEvents;
    }

    public End withProduceEvents(List<ProduceEvent> produceEvents) {
        this.produceEvents = produceEvents;
        return this;
    }

    public static enum Kind {
        DEFAULT("default"),
        TERMINATE("terminate"),
        EVENT("event");

        private final String value;
        private static final Map<String, Kind> CONSTANTS;

        private Kind(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Kind fromValue(String value) {
            Kind constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Kind>();
            for (Kind c : Kind.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

