/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.api.events;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"triggerEventRef", "resultEventRef", "data", "contextAttributes"})
public class EventRef
implements Serializable {
    @JsonProperty(value="triggerEventRef")
    @JsonPropertyDescription(value="Reference to the unique name of a 'produced' event definition")
    @NotNull
    private String triggerEventRef;
    @JsonProperty(value="resultEventRef")
    @JsonPropertyDescription(value="Reference to the unique name of a 'consumed' event definition")
    @NotNull
    private String resultEventRef;
    @JsonProperty(value="data")
    @JsonPropertyDescription(value="Expression which selects parts of the states data output to become the data of the produced event.")
    private String data;
    @JsonProperty(value="contextAttributes")
    @JsonPropertyDescription(value="Add additional extension context attributes to the produced event")
    @Valid
    private Map<String, String> contextAttributes;
    private static final long serialVersionUID = -4668447908590067979L;

    public EventRef() {
    }

    public EventRef(String triggerEventRef, String resultEventRef) {
        this.triggerEventRef = triggerEventRef;
        this.resultEventRef = resultEventRef;
    }

    @JsonProperty(value="triggerEventRef")
    public String getTriggerEventRef() {
        return this.triggerEventRef;
    }

    @JsonProperty(value="triggerEventRef")
    public void setTriggerEventRef(String triggerEventRef) {
        this.triggerEventRef = triggerEventRef;
    }

    public EventRef withTriggerEventRef(String triggerEventRef) {
        this.triggerEventRef = triggerEventRef;
        return this;
    }

    @JsonProperty(value="resultEventRef")
    public String getResultEventRef() {
        return this.resultEventRef;
    }

    @JsonProperty(value="resultEventRef")
    public void setResultEventRef(String resultEventRef) {
        this.resultEventRef = resultEventRef;
    }

    public EventRef withResultEventRef(String resultEventRef) {
        this.resultEventRef = resultEventRef;
        return this;
    }

    @JsonProperty(value="data")
    public String getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    public void setData(String data) {
        this.data = data;
    }

    public EventRef withData(String data) {
        this.data = data;
        return this;
    }

    @JsonProperty(value="contextAttributes")
    public Map<String, String> getContextAttributes() {
        return this.contextAttributes;
    }

    @JsonProperty(value="contextAttributes")
    public void setContextAttributes(Map<String, String> contextAttributes) {
        this.contextAttributes = contextAttributes;
    }

    public EventRef withContextAttributes(Map<String, String> contextAttributes) {
        this.contextAttributes = contextAttributes;
        return this;
    }
}

