/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.api.states;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.jbpm.serverless.workflow.api.branches.Branch;
import org.jbpm.serverless.workflow.api.end.End;
import org.jbpm.serverless.workflow.api.error.Error;
import org.jbpm.serverless.workflow.api.filters.StateDataFilter;
import org.jbpm.serverless.workflow.api.interfaces.State;
import org.jbpm.serverless.workflow.api.retry.Retry;
import org.jbpm.serverless.workflow.api.start.Start;
import org.jbpm.serverless.workflow.api.states.DefaultState;
import org.jbpm.serverless.workflow.api.transitions.Transition;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"branches", "completionType", "n"})
public class ParallelState
extends DefaultState
implements Serializable,
State {
    @JsonProperty(value="branches")
    @JsonPropertyDescription(value="Branch Definitions")
    @Valid
    @NotNull
    private List<Branch> branches = new ArrayList<Branch>();
    @JsonProperty(value="completionType")
    @JsonPropertyDescription(value="Option types on how to complete branch execution.")
    private CompletionType completionType = CompletionType.fromValue("and");
    @JsonProperty(value="n")
    @JsonPropertyDescription(value="Used when completionType is set to 'n_of_m' to specify the 'N' value")
    private String n = "0";
    private static final long serialVersionUID = -8296508061422605652L;

    public ParallelState() {
    }

    public ParallelState(List<Branch> branches, String name, DefaultState.Type type) {
        super(name, type);
        this.branches = branches;
    }

    @JsonProperty(value="branches")
    public List<Branch> getBranches() {
        return this.branches;
    }

    @JsonProperty(value="branches")
    public void setBranches(List<Branch> branches) {
        this.branches = branches;
    }

    public ParallelState withBranches(List<Branch> branches) {
        this.branches = branches;
        return this;
    }

    @JsonProperty(value="completionType")
    public CompletionType getCompletionType() {
        return this.completionType;
    }

    @JsonProperty(value="completionType")
    public void setCompletionType(CompletionType completionType) {
        this.completionType = completionType;
    }

    public ParallelState withCompletionType(CompletionType completionType) {
        this.completionType = completionType;
        return this;
    }

    @JsonProperty(value="n")
    public String getN() {
        return this.n;
    }

    @JsonProperty(value="n")
    public void setN(String n) {
        this.n = n;
    }

    public ParallelState withN(String n) {
        this.n = n;
        return this;
    }

    @Override
    public ParallelState withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public ParallelState withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public ParallelState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public ParallelState withStart(Start start) {
        super.withStart(start);
        return this;
    }

    @Override
    public ParallelState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public ParallelState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public ParallelState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public ParallelState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public ParallelState withDataInputSchema(String dataInputSchema) {
        super.withDataInputSchema(dataInputSchema);
        return this;
    }

    @Override
    public ParallelState withDataOutputSchema(String dataOutputSchema) {
        super.withDataOutputSchema(dataOutputSchema);
        return this;
    }

    @Override
    public ParallelState withOnError(List<Error> onError) {
        super.withOnError(onError);
        return this;
    }

    @Override
    public ParallelState withRetry(List<Retry> retry) {
        super.withRetry(retry);
        return this;
    }

    public static enum CompletionType {
        AND("and"),
        XOR("xor"),
        N_OF_M("n_of_m");

        private final String value;
        private static final Map<String, CompletionType> CONSTANTS;

        private CompletionType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static CompletionType fromValue(String value) {
            CompletionType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, CompletionType>();
            for (CompletionType c : CompletionType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

