/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.api.schedule;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"interval", "cron", "directInvoke", "timezone"})
public class Schedule
implements Serializable {
    @JsonProperty(value="interval")
    @JsonPropertyDescription(value="Time interval (ISO 8601 format) describing when the workflow starting state is active")
    private String interval;
    @JsonProperty(value="cron")
    @JsonPropertyDescription(value="Repeating interval (cron expression) describing when the workflow starting state should be triggered")
    private String cron;
    @JsonProperty(value="directInvoke")
    @JsonPropertyDescription(value="Define if workflow instances can be created outside of the defined interval/cron")
    private DirectInvoke directInvoke;
    @JsonProperty(value="timezone")
    @JsonPropertyDescription(value="Timezone name used to evaluate the cron expression. Not used for interval as timezone can be specified there directly. If not specified, should default to local machine timezone.")
    private String timezone;
    private static final long serialVersionUID = -4626994334265135809L;

    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    @JsonProperty(value="interval")
    public void setInterval(String interval) {
        this.interval = interval;
    }

    public Schedule withInterval(String interval) {
        this.interval = interval;
        return this;
    }

    @JsonProperty(value="cron")
    public String getCron() {
        return this.cron;
    }

    @JsonProperty(value="cron")
    public void setCron(String cron) {
        this.cron = cron;
    }

    public Schedule withCron(String cron) {
        this.cron = cron;
        return this;
    }

    @JsonProperty(value="directInvoke")
    public DirectInvoke getDirectInvoke() {
        return this.directInvoke;
    }

    @JsonProperty(value="directInvoke")
    public void setDirectInvoke(DirectInvoke directInvoke) {
        this.directInvoke = directInvoke;
    }

    public Schedule withDirectInvoke(DirectInvoke directInvoke) {
        this.directInvoke = directInvoke;
        return this;
    }

    @JsonProperty(value="timezone")
    public String getTimezone() {
        return this.timezone;
    }

    @JsonProperty(value="timezone")
    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public Schedule withTimezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    public static enum DirectInvoke {
        ALLOW("allow"),
        DENY("deny");

        private final String value;
        private static final Map<String, DirectInvoke> CONSTANTS;

        private DirectInvoke(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DirectInvoke fromValue(String value) {
            DirectInvoke constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DirectInvoke>();
            for (DirectInvoke c : DirectInvoke.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

