/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.spi;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.jbpm.serverless.workflow.api.interfaces.WorkflowPropertySource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowPropertySourceProvider {
    private WorkflowPropertySource workflowPropertySource;
    private static Logger logger = LoggerFactory.getLogger(WorkflowPropertySourceProvider.class);

    public WorkflowPropertySourceProvider() {
        ServiceLoader<WorkflowPropertySource> foundPropertyContext = ServiceLoader.load(WorkflowPropertySource.class);
        Iterator<WorkflowPropertySource> it = foundPropertyContext.iterator();
        if (it.hasNext()) {
            this.workflowPropertySource = it.next();
            logger.info("Found property source: {}", (Object)this.workflowPropertySource);
        }
    }

    public static WorkflowPropertySourceProvider getInstance() {
        return LazyHolder.INSTANCE;
    }

    public WorkflowPropertySource get() {
        return this.workflowPropertySource;
    }

    private static class LazyHolder {
        static final WorkflowPropertySourceProvider INSTANCE = new WorkflowPropertySourceProvider();

        private LazyHolder() {
        }
    }
}

