/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.parser.core;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.Work;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.process.core.event.EventFilter;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.process.core.impl.WorkImpl;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.process.core.validation.ProcessValidationError;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.ruleflow.core.validation.RuleFlowProcessValidator;
import org.jbpm.serverless.workflow.api.Workflow;
import org.jbpm.serverless.workflow.api.end.End;
import org.jbpm.serverless.workflow.api.events.EventDefinition;
import org.jbpm.serverless.workflow.api.functions.FunctionDefinition;
import org.jbpm.serverless.workflow.api.functions.FunctionRef;
import org.jbpm.serverless.workflow.parser.util.ServerlessWorkflowUtils;
import org.jbpm.serverless.workflow.parser.util.WorkflowAppContext;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.impl.ConstraintImpl;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.EventTrigger;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.Join;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.jbpm.workflow.core.node.Split;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.core.node.TimerNode;
import org.jbpm.workflow.core.node.Trigger;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.kie.api.definition.process.Node;
import org.kogito.workitem.rest.jsonpath.suppliers.JsonPathExprSupplier;
import org.kogito.workitem.rest.jsonpath.suppliers.JsonPathResultExprSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerlessWorkflowFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerlessWorkflowFactory.class);
    public static final String EOL = System.getProperty("line.separator");
    public static final String DEFAULT_WORKFLOW_ID = "serverless";
    public static final String DEFAULT_WORKFLOW_NAME = "workflow";
    public static final String DEFAULT_WORKFLOW_VERSION = "1.0";
    public static final String DEFAULT_PACKAGE_NAME = "org.kie.kogito.serverless";
    public static final String DEFAULT_VISIBILITY = "Public";
    public static final String DEFAULT_DECISION = "decision";
    public static final String JSON_NODE = "com.fasterxml.jackson.databind.JsonNode";
    public static final String DEFAULT_WORKFLOW_VAR = "workflowdata";
    public static final String UNIQUE_ID_PARAM = "UniqueId";
    public static final String EVENTBASED_PARAM = "EventBased";
    public static final String DEFAULT_SERVICE_IMPL = "Java";
    public static final String SERVICE_INTERFACE_KEY = "interface";
    public static final String SERVICE_OPERATION_KEY = "operation";
    public static final String SERVICE_IMPL_KEY = "implementation";
    public static final String SERVICE_ENDPOINT = "endpoint";
    public static final String DEFAULT_HT_TASKNAME = "workflowhtask";
    public static final String DEFAULT_HT_SKIPPABLE = "true";
    public static final String HT_TASKNAME = "taskname";
    public static final String HT_SKIPPABLE = "skippable";
    public static final String HTP_GROUPID = "groupid";
    public static final String HT_ACTORID = "actorid";
    public static final String RF_GROUP = "ruleflowgroup";
    public static final String SERVICE_TASK_TYPE = "Service Task";
    private WorkflowAppContext workflowAppContext;

    public ServerlessWorkflowFactory(WorkflowAppContext workflowAppContext) {
        this.workflowAppContext = workflowAppContext;
    }

    public RuleFlowProcess createProcess(Workflow workflow) {
        RuleFlowProcess process = new RuleFlowProcess();
        if (workflow.getId() != null && !workflow.getId().isEmpty()) {
            process.setId(workflow.getId());
        } else {
            LOGGER.info("setting default id {}", (Object)DEFAULT_WORKFLOW_ID);
            process.setId(DEFAULT_WORKFLOW_ID);
        }
        if (workflow.getName() != null && !workflow.getName().isEmpty()) {
            process.setName(workflow.getName());
        } else {
            LOGGER.info("setting default name {}", (Object)DEFAULT_WORKFLOW_NAME);
            process.setName(DEFAULT_WORKFLOW_NAME);
        }
        if (workflow.getVersion() != null && !workflow.getVersion().isEmpty()) {
            process.setVersion(workflow.getVersion());
        } else {
            LOGGER.info("setting default version {}", (Object)DEFAULT_WORKFLOW_VERSION);
            process.setVersion(DEFAULT_WORKFLOW_VERSION);
        }
        if (workflow.getMetadata() != null && workflow.getMetadata().get("package") != null) {
            process.setPackageName(workflow.getMetadata().get("package"));
        } else {
            process.setPackageName(DEFAULT_PACKAGE_NAME);
        }
        process.setAutoComplete(true);
        process.setVisibility(DEFAULT_VISIBILITY);
        this.processVar(DEFAULT_WORKFLOW_VAR, JsonNode.class, process);
        return process;
    }

    public StartNode startNode(long id, String name, NodeContainer nodeContainer) {
        StartNode startNode = new StartNode();
        startNode.setId(id);
        startNode.setName(name);
        nodeContainer.addNode((Node)startNode);
        return startNode;
    }

    public StartNode messageStartNode(long id, EventDefinition eventDefinition, NodeContainer nodeContainer) {
        StartNode startNode = new StartNode();
        startNode.setId(id);
        startNode.setName(eventDefinition.getName());
        startNode.setMetaData("TriggerMapping", (Object)DEFAULT_WORKFLOW_VAR);
        startNode.setMetaData("TriggerType", (Object)"ConsumeMessage");
        startNode.setMetaData("TriggerRef", (Object)eventDefinition.getSource());
        startNode.setMetaData("MessageType", (Object)JSON_NODE);
        this.addTriggerToStartNode(startNode, JSON_NODE);
        nodeContainer.addNode((Node)startNode);
        return startNode;
    }

    public EndNode endNode(long id, String name, boolean terminate, NodeContainer nodeContainer) {
        EndNode endNode = new EndNode();
        endNode.setId(id);
        endNode.setName(name);
        endNode.setTerminate(terminate);
        nodeContainer.addNode((Node)endNode);
        return endNode;
    }

    public EndNode messageEndNode(long id, String name, Workflow workflow, End stateEnd, NodeContainer nodeContainer) {
        EndNode endNode = new EndNode();
        endNode.setTerminate(false);
        endNode.setId(id);
        endNode.setName(name);
        if (!stateEnd.getProduceEvents().isEmpty()) {
            EventDefinition eventDef = ServerlessWorkflowUtils.getWorkflowEventFor(workflow, stateEnd.getProduceEvents().get(0).getEventRef());
            endNode.setMetaData("TriggerRef", (Object)eventDef.getSource());
            endNode.setMetaData("TriggerType", (Object)"ProduceMessage");
            endNode.setMetaData("MessageType", (Object)JSON_NODE);
            endNode.setMetaData("MappingVariable", (Object)DEFAULT_WORKFLOW_VAR);
            this.addMessageEndNodeAction(endNode, DEFAULT_WORKFLOW_VAR, JSON_NODE);
            nodeContainer.addNode((Node)endNode);
            return endNode;
        }
        LOGGER.error("Unable to find produce event definition for state end.");
        return null;
    }

    public TimerNode timerNode(long id, String name, String delay, NodeContainer nodeContainer) {
        TimerNode timerNode = new TimerNode();
        timerNode.setId(id);
        timerNode.setName(name);
        timerNode.setMetaData("EventType", (Object)"timer");
        Timer timer = new Timer();
        timer.setTimeType(1);
        timer.setDelay(delay);
        timerNode.setTimer(timer);
        nodeContainer.addNode((Node)timerNode);
        return timerNode;
    }

    public SubProcessNode callActivity(long id, String name, String calledId, boolean waitForCompletion, NodeContainer nodeContainer) {
        SubProcessNode subProcessNode = new SubProcessNode();
        subProcessNode.setId(id);
        subProcessNode.setName(name);
        subProcessNode.setProcessId(calledId);
        subProcessNode.setWaitForCompletion(waitForCompletion);
        subProcessNode.setIndependent(true);
        VariableScope variableScope = new VariableScope();
        subProcessNode.addContext((Context)variableScope);
        subProcessNode.setDefaultContext((Context)variableScope);
        HashMap<String, String> inputOtuputTypes = new HashMap<String, String>();
        inputOtuputTypes.put(DEFAULT_WORKFLOW_VAR, JSON_NODE);
        subProcessNode.setMetaData("BPMN.InputTypes", inputOtuputTypes);
        subProcessNode.setMetaData("BPMN.OutputTypes", inputOtuputTypes);
        subProcessNode.addInMapping(DEFAULT_WORKFLOW_VAR, DEFAULT_WORKFLOW_VAR);
        subProcessNode.addOutMapping(DEFAULT_WORKFLOW_VAR, DEFAULT_WORKFLOW_VAR);
        nodeContainer.addNode((Node)subProcessNode);
        return subProcessNode;
    }

    public void addMessageEndNodeAction(EndNode endNode, String variable, String messageType) {
        ArrayList<DroolsConsequenceAction> actions = new ArrayList<DroolsConsequenceAction>();
        actions.add(new DroolsConsequenceAction("java", "org.drools.core.process.instance.impl.WorkItemImpl workItem = new org.drools.core.process.instance.impl.WorkItemImpl();" + EOL + "workItem.setName(\"Send Task\");" + EOL + "workItem.setNodeInstanceId(kcontext.getNodeInstance().getId());" + EOL + "workItem.setProcessInstanceId(kcontext.getProcessInstance().getId());" + EOL + "workItem.setNodeId(kcontext.getNodeInstance().getNodeId());" + EOL + "workItem.setParameter(\"MessageType\", \"" + messageType + "\");" + EOL + (variable == null ? "" : "workItem.setParameter(\"Message\", " + variable + ");" + EOL) + "workItem.setDeploymentId((String) kcontext.getKnowledgeRuntime().getEnvironment().get(\"deploymentId\"));" + EOL + "((org.drools.core.process.instance.WorkItemManager) kcontext.getKnowledgeRuntime().getWorkItemManager()).internalExecuteWorkItem(workItem);"));
        endNode.setActions("onEntry", actions);
    }

    public void addTriggerToStartNode(StartNode startNode, String triggerEventType) {
        EventTrigger trigger = new EventTrigger();
        EventTypeFilter eventFilter = new EventTypeFilter();
        eventFilter.setType(triggerEventType);
        trigger.addEventFilter((EventFilter)eventFilter);
        String mapping = (String)startNode.getMetaData("TriggerMapping");
        if (mapping != null) {
            trigger.addInMapping(mapping, startNode.getOutMapping(mapping));
        }
        startNode.addTrigger((Trigger)trigger);
    }

    public ActionNode sendEventNode(long id, EventDefinition eventDefinition, NodeContainer nodeContainer) {
        ActionNode sendEventNode = new ActionNode();
        sendEventNode.setId(id);
        sendEventNode.setName(eventDefinition.getName());
        sendEventNode.setMetaData("TriggerType", (Object)"ProduceMessage");
        sendEventNode.setMetaData("MappingVariable", (Object)DEFAULT_WORKFLOW_VAR);
        sendEventNode.setMetaData("TriggerRef", (Object)eventDefinition.getSource());
        sendEventNode.setMetaData("MessageType", (Object)JSON_NODE);
        nodeContainer.addNode((Node)sendEventNode);
        return sendEventNode;
    }

    public EventNode consumeEventNode(long id, EventDefinition eventDefinition, NodeContainer nodeContainer) {
        EventNode eventNode = new EventNode();
        eventNode.setId(id);
        eventNode.setName(eventDefinition.getName());
        EventTypeFilter eventFilter = new EventTypeFilter();
        eventFilter.setType("Message-" + eventDefinition.getSource());
        eventNode.addEventFilter((EventFilter)eventFilter);
        eventNode.setVariableName(DEFAULT_WORKFLOW_VAR);
        eventNode.setMetaData("TriggerType", (Object)"ConsumeMessage");
        eventNode.setMetaData("EventType", (Object)"message");
        eventNode.setMetaData("TriggerRef", (Object)eventDefinition.getSource());
        eventNode.setMetaData("MessageType", (Object)JSON_NODE);
        nodeContainer.addNode((Node)eventNode);
        return eventNode;
    }

    public ActionNode scriptNode(long id, String name, String script, NodeContainer nodeContainer) {
        ActionNode scriptNode = new ActionNode();
        scriptNode.setId(id);
        scriptNode.setName(name);
        scriptNode.setAction((DroolsAction)new DroolsConsequenceAction());
        ((DroolsConsequenceAction)scriptNode.getAction()).setConsequence(script);
        ((DroolsConsequenceAction)scriptNode.getAction()).setDialect("java");
        nodeContainer.addNode((Node)scriptNode);
        return scriptNode;
    }

    public WorkItemNode camelRouteServiceNode(long id, String name, FunctionDefinition function, NodeContainer nodeContainer) {
        WorkItemNode workItemNode = new WorkItemNode();
        workItemNode.setId(id);
        workItemNode.setName(name);
        workItemNode.setMetaData("Type", (Object)SERVICE_TASK_TYPE);
        WorkImpl work = new WorkImpl();
        workItemNode.setWork((Work)work);
        work.setName("org.apache.camel.ProducerTemplate.requestBody");
        work.setParameter(SERVICE_ENDPOINT, (Object)ServerlessWorkflowUtils.resolveFunctionMetadata(function, SERVICE_ENDPOINT, this.workflowAppContext));
        work.setParameter("Interface", (Object)"org.apache.camel.ProducerTemplate");
        work.setParameter("Operation", (Object)"requestBody");
        work.setParameter("interfaceImplementationRef", (Object)"org.apache.camel.ProducerTemplate");
        String metaImpl = ServerlessWorkflowUtils.resolveFunctionMetadata(function, SERVICE_IMPL_KEY, this.workflowAppContext);
        if (metaImpl == null || metaImpl.isEmpty()) {
            metaImpl = DEFAULT_SERVICE_IMPL;
        }
        work.setParameter(SERVICE_IMPL_KEY, (Object)metaImpl);
        workItemNode.addInMapping("body", DEFAULT_WORKFLOW_VAR);
        workItemNode.addOutMapping("result", DEFAULT_WORKFLOW_VAR);
        nodeContainer.addNode((Node)workItemNode);
        return workItemNode;
    }

    public Node restServiceNode(long id, FunctionRef functionRef, FunctionDefinition functionDefinition, NodeContainer nodeContainer) {
        WorkItemNode workItemNode = new WorkItemNode();
        workItemNode.setId(id);
        workItemNode.setName(functionDefinition.getName());
        workItemNode.setMetaData("Type", (Object)"Rest Task");
        WorkImpl work = new WorkImpl();
        workItemNode.setWork((Work)work);
        work.setName("Rest Task");
        work.setParameter(SERVICE_ENDPOINT, (Object)functionDefinition.getResource());
        work.setParameter("method", (Object)ServerlessWorkflowUtils.resolveFunctionMetadata(functionDefinition, "method", this.workflowAppContext));
        work.setParameter("user", (Object)ServerlessWorkflowUtils.resolveFunctionMetadata(functionDefinition, "user", this.workflowAppContext));
        work.setParameter("password", (Object)ServerlessWorkflowUtils.resolveFunctionMetadata(functionDefinition, "password", this.workflowAppContext));
        work.setParameter("host", (Object)ServerlessWorkflowUtils.resolveFunctionMetadata(functionDefinition, "host", this.workflowAppContext));
        work.setParameter("port", (Object)ServerlessWorkflowUtils.resolveFunctionMetadata(functionDefinition, "port", this.workflowAppContext));
        if (functionRef.getParameters() != null) {
            for (Map.Entry<String, String> param : functionRef.getParameters().entrySet()) {
                work.setParameter(param.getKey(), (Object)new JsonPathExprSupplier(param.getValue()));
            }
        }
        work.setParameter("ResultHandler", (Object)new JsonPathResultExprSupplier());
        workItemNode.addInMapping("Parameter", DEFAULT_WORKFLOW_VAR);
        workItemNode.addOutMapping("Result", DEFAULT_WORKFLOW_VAR);
        nodeContainer.addNode((Node)workItemNode);
        return workItemNode;
    }

    public WorkItemNode serviceNode(long id, String name, FunctionDefinition function, NodeContainer nodeContainer) {
        WorkItemNode workItemNode = new WorkItemNode();
        workItemNode.setId(id);
        workItemNode.setName(name);
        workItemNode.setMetaData("Type", (Object)SERVICE_TASK_TYPE);
        WorkImpl work = new WorkImpl();
        workItemNode.setWork((Work)work);
        work.setName(SERVICE_TASK_TYPE);
        work.setParameter("Interface", (Object)ServerlessWorkflowUtils.resolveFunctionMetadata(function, SERVICE_INTERFACE_KEY, this.workflowAppContext));
        work.setParameter("Operation", (Object)ServerlessWorkflowUtils.resolveFunctionMetadata(function, SERVICE_OPERATION_KEY, this.workflowAppContext));
        work.setParameter("interfaceImplementationRef", (Object)ServerlessWorkflowUtils.resolveFunctionMetadata(function, SERVICE_INTERFACE_KEY, this.workflowAppContext));
        work.setParameter("operationImplementationRef", (Object)ServerlessWorkflowUtils.resolveFunctionMetadata(function, SERVICE_OPERATION_KEY, this.workflowAppContext));
        work.setParameter("ParameterType", (Object)JSON_NODE);
        String metaImpl = ServerlessWorkflowUtils.resolveFunctionMetadata(function, SERVICE_IMPL_KEY, this.workflowAppContext);
        if (metaImpl == null || metaImpl.isEmpty()) {
            metaImpl = DEFAULT_SERVICE_IMPL;
        }
        work.setParameter(SERVICE_IMPL_KEY, (Object)metaImpl);
        workItemNode.addInMapping("Parameter", DEFAULT_WORKFLOW_VAR);
        workItemNode.addOutMapping("Result", DEFAULT_WORKFLOW_VAR);
        nodeContainer.addNode((Node)workItemNode);
        return workItemNode;
    }

    public void processVar(String varName, Class varType, RuleFlowProcess process) {
        Variable variable = new Variable();
        variable.setName(varName);
        variable.setType((DataType)new ObjectDataType(varType.getName()));
        process.getVariableScope().getVariables().add(variable);
    }

    public CompositeContextNode subProcessNode(long id, String name, NodeContainer nodeContainer) {
        CompositeContextNode subProcessNode = new CompositeContextNode();
        subProcessNode.setId(id);
        subProcessNode.setName(name);
        subProcessNode.setAutoComplete(true);
        nodeContainer.addNode((Node)subProcessNode);
        return subProcessNode;
    }

    public Split splitNode(long id, String name, int type, NodeContainer nodeContainer) {
        Split split = new Split();
        split.setId(id);
        split.setName(name);
        split.setType(type);
        split.setMetaData(UNIQUE_ID_PARAM, (Object)Long.toString(id));
        nodeContainer.addNode((Node)split);
        return split;
    }

    public Split eventBasedSplit(long id, String name, NodeContainer nodeContainer) {
        Split split = new Split();
        split.setId(id);
        split.setName(name);
        split.setType(4);
        split.setMetaData(UNIQUE_ID_PARAM, (Object)Long.toString(id));
        split.setMetaData(EVENTBASED_PARAM, (Object)DEFAULT_HT_SKIPPABLE);
        nodeContainer.addNode((Node)split);
        return split;
    }

    public Join joinNode(long id, String name, int type, NodeContainer nodeContainer) {
        Join join = new Join();
        join.setId(id);
        join.setName(name);
        join.setType(type);
        join.setMetaData(UNIQUE_ID_PARAM, (Object)Long.toString(id));
        nodeContainer.addNode((Node)join);
        return join;
    }

    public ConstraintImpl splitConstraint(String name, String type, String dialect, String constraint, int priority, boolean isDefault) {
        ConstraintImpl constraintImpl = new ConstraintImpl();
        constraintImpl.setName(name);
        constraintImpl.setType(type);
        constraintImpl.setDialect(dialect);
        constraintImpl.setConstraint(constraint);
        constraintImpl.setPriority(priority);
        constraintImpl.setDefault(isDefault);
        return constraintImpl;
    }

    public HumanTaskNode humanTaskNode(long id, String name, FunctionDefinition function, RuleFlowProcess process, NodeContainer nodeContainer) {
        this.processVar(ServerlessWorkflowUtils.resolveFunctionMetadata(function, HT_TASKNAME, this.workflowAppContext) + DEFAULT_DECISION, JsonNode.class, process);
        HumanTaskNode humanTaskNode = new HumanTaskNode();
        humanTaskNode.setId(id);
        humanTaskNode.setName(name);
        WorkImpl work = new WorkImpl();
        work.setName("Human Task");
        humanTaskNode.setWork((Work)work);
        work.setParameter("TaskName", (Object)(ServerlessWorkflowUtils.resolveFunctionMetadata(function, HT_TASKNAME, this.workflowAppContext).length() > 0 ? ServerlessWorkflowUtils.resolveFunctionMetadata(function, HT_TASKNAME, this.workflowAppContext) : DEFAULT_HT_TASKNAME));
        work.setParameter("Skippable", (Object)(ServerlessWorkflowUtils.resolveFunctionMetadata(function, HT_SKIPPABLE, this.workflowAppContext).length() > 0 ? ServerlessWorkflowUtils.resolveFunctionMetadata(function, HT_SKIPPABLE, this.workflowAppContext) : DEFAULT_HT_SKIPPABLE));
        if (ServerlessWorkflowUtils.resolveFunctionMetadata(function, HTP_GROUPID, this.workflowAppContext).length() > 0) {
            work.setParameter("GroupId", (Object)ServerlessWorkflowUtils.resolveFunctionMetadata(function, HTP_GROUPID, this.workflowAppContext));
        }
        if (ServerlessWorkflowUtils.resolveFunctionMetadata(function, HT_ACTORID, this.workflowAppContext).length() > 0) {
            work.setParameter("ActorId", (Object)ServerlessWorkflowUtils.resolveFunctionMetadata(function, HT_ACTORID, this.workflowAppContext));
        }
        work.setParameter("NodeName", (Object)name);
        humanTaskNode.addInMapping(DEFAULT_WORKFLOW_VAR, DEFAULT_WORKFLOW_VAR);
        humanTaskNode.addOutMapping(DEFAULT_DECISION, ServerlessWorkflowUtils.resolveFunctionMetadata(function, HT_TASKNAME, this.workflowAppContext) + DEFAULT_DECISION);
        nodeContainer.addNode((Node)humanTaskNode);
        return humanTaskNode;
    }

    public RuleSetNode ruleSetNode(long id, String name, FunctionDefinition function, NodeContainer nodeContainer) {
        RuleSetNode ruleSetNode = new RuleSetNode();
        ruleSetNode.setId(id);
        ruleSetNode.setName(name);
        ruleSetNode.setRuleType((RuleSetNode.RuleType)RuleSetNode.RuleType.ruleFlowGroup((String)ServerlessWorkflowUtils.resolveFunctionMetadata(function, RF_GROUP, this.workflowAppContext)));
        ruleSetNode.setLanguage("http://www.jboss.org/drools/rule");
        ruleSetNode.addInMapping(DEFAULT_WORKFLOW_VAR, DEFAULT_WORKFLOW_VAR);
        ruleSetNode.addOutMapping(DEFAULT_WORKFLOW_VAR, DEFAULT_WORKFLOW_VAR);
        nodeContainer.addNode((Node)ruleSetNode);
        return ruleSetNode;
    }

    public void connect(long fromId, long toId, String uniqueId, NodeContainer nodeContainer) {
        Node from = nodeContainer.getNode(fromId);
        Node to = nodeContainer.getNode(toId);
        ConnectionImpl connection = new ConnectionImpl(from, "DROOLS_DEFAULT", to, "DROOLS_DEFAULT");
        connection.setMetaData(UNIQUE_ID_PARAM, (Object)uniqueId);
    }

    public void validate(RuleFlowProcess process) {
        ProcessValidationError[] errors;
        for (ProcessValidationError error : errors = RuleFlowProcessValidator.getInstance().validateProcess(process)) {
            LOGGER.error(error.toString());
        }
        if (errors.length > 0) {
            throw new RuntimeException("Workflow could not be validated !");
        }
    }
}

