/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.spi;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.jbpm.serverless.workflow.api.interfaces.WorkflowValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowValidatorProvider {
    private WorkflowValidator workflowValidator;
    private static Logger logger = LoggerFactory.getLogger(WorkflowValidatorProvider.class);

    public WorkflowValidatorProvider() {
        ServiceLoader<WorkflowValidator> foundWorkflowValidators = ServiceLoader.load(WorkflowValidator.class);
        Iterator<WorkflowValidator> it = foundWorkflowValidators.iterator();
        if (it.hasNext()) {
            this.workflowValidator = it.next();
            logger.info("Found workflow validator: {}", (Object)this.workflowValidator);
        }
    }

    public static WorkflowValidatorProvider getInstance() {
        return LazyHolder.INSTANCE;
    }

    public WorkflowValidator get() {
        return this.workflowValidator;
    }

    private static class LazyHolder {
        static final WorkflowValidatorProvider INSTANCE = new WorkflowValidatorProvider();

        private LazyHolder() {
        }
    }
}

