/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.BaseConfiguration;
import org.drools.util.StringUtils;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.conf.ConfigurationKey;
import org.kie.api.conf.KieBaseMutabilityOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.conf.MBeansOption;
import org.kie.api.conf.MultiValueKieBaseOption;
import org.kie.api.conf.Option;
import org.kie.api.conf.OptionKey;
import org.kie.api.conf.SingleValueKieBaseOption;
import org.kie.internal.conf.CompositeConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieBaseConfigurationImpl
extends BaseConfiguration<KieBaseOption, SingleValueKieBaseOption, MultiValueKieBaseOption>
implements KieBaseConfiguration,
Externalizable {
    private static final long serialVersionUID = 510L;
    protected static final transient Logger logger = LoggerFactory.getLogger(KieBaseConfigurationImpl.class);
    public static final ConfigurationKey<KieBaseConfigurationImpl> KEY = new ConfigurationKey("Base");
    private boolean mutabilityEnabled;
    private boolean mbeansEnabled;

    public KieBaseConfigurationImpl(CompositeConfiguration<KieBaseOption, SingleValueKieBaseOption, MultiValueKieBaseOption> compConfig) {
        super(compConfig);
        this.init();
    }

    private void init() {
        this.setMBeansEnabled(MBeansOption.isEnabled((String)this.getPropertyValue("kie.mbeans", "disabled")));
        this.setMutabilityEnabled(KieBaseMutabilityOption.determineMutability((String)this.getPropertyValue("drools.kieBaseMutability", "ALLOWED")) == KieBaseMutabilityOption.ALLOWED);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.mutabilityEnabled);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.mutabilityEnabled = in.readBoolean();
    }

    public boolean setInternalProperty(String name, String value) {
        switch (name) {
            case "kie.mbeans": {
                this.setMBeansEnabled(MBeansOption.isEnabled((String)value));
                break;
            }
            case "drools.kieBaseMutability": {
                this.setMutabilityEnabled(StringUtils.isEmpty((CharSequence)value) ? true : KieBaseMutabilityOption.determineMutability((String)value) == KieBaseMutabilityOption.ALLOWED);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public String getInternalProperty(String name) {
        switch (name) {
            case "kie.mbeans": {
                return this.isMBeansEnabled() ? "enabled" : "disabled";
            }
            case "drools.kieBaseMutability": {
                return this.isMutabilityEnabled() ? "ALLOWED" : "DISABLED";
            }
        }
        return null;
    }

    public void setMBeansEnabled(boolean mbeansEnabled) {
        this.checkCanChange();
        this.mbeansEnabled = mbeansEnabled;
    }

    public boolean isMBeansEnabled() {
        return this.mbeansEnabled;
    }

    public void setMutabilityEnabled(boolean mutabilityEnabled) {
        this.mutabilityEnabled = mutabilityEnabled;
    }

    public boolean isMutabilityEnabled() {
        return this.mutabilityEnabled;
    }

    public <T extends SingleValueKieBaseOption> T getOption(OptionKey<T> option) {
        switch (option.name()) {
            case "kie.mbeans": {
                return (T)(this.isMBeansEnabled() ? MBeansOption.ENABLED : MBeansOption.DISABLED);
            }
            case "drools.kieBaseMutability": {
                return (T)(this.isMutabilityEnabled() ? KieBaseMutabilityOption.ALLOWED : KieBaseMutabilityOption.DISABLED);
            }
        }
        return (T)((SingleValueKieBaseOption)this.compConfig.getOption(option));
    }

    public void setOption(KieBaseOption option) {
        switch (option.getPropertyName()) {
            case "kie.mbeans": {
                this.setMBeansEnabled(((MBeansOption)option).isEnabled());
                break;
            }
            case "drools.kieBaseMutability": {
                this.setMutabilityEnabled(option == KieBaseMutabilityOption.ALLOWED);
                break;
            }
            default: {
                this.compConfig.setOption((Option)option);
            }
        }
    }

    public <C extends MultiValueKieBaseOption> C getOption(OptionKey<C> optionKey, String subKey) {
        return (C)((MultiValueKieBaseOption)this.compConfig.getOption(optionKey, subKey));
    }
}

