/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.definitions.rule.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.base.base.EnabledBoolean;
import org.drools.base.base.SalienceInteger;
import org.drools.base.base.ValueResolver;
import org.drools.base.definitions.rule.impl.QueryImpl;
import org.drools.base.reteoo.BaseTuple;
import org.drools.base.rule.ConsequenceMetaData;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.Dialectable;
import org.drools.base.rule.GroupElement;
import org.drools.base.rule.GroupElementFactory;
import org.drools.base.rule.InvalidPatternException;
import org.drools.base.rule.LogicTransformer;
import org.drools.base.rule.RuleConditionElement;
import org.drools.base.rule.accessor.CompiledInvoker;
import org.drools.base.rule.accessor.Enabled;
import org.drools.base.rule.accessor.Salience;
import org.drools.base.rule.accessor.Wireable;
import org.drools.base.rule.consequence.Consequence;
import org.drools.base.time.impl.Timer;
import org.drools.util.StringUtils;
import org.kie.api.definition.KieDefinition;
import org.kie.api.definition.rule.Query;
import org.kie.api.io.Resource;
import org.kie.internal.definition.rule.InternalRule;

public class RuleImpl
implements Externalizable,
Wireable,
Dialectable,
InternalRule,
Query {
    private static final int NO_LOOP_BIT = 1;
    private static final int AUTO_FOCUS_BIT = 2;
    private static final int LOCK_ON_ACTIVE_BIT = 4;
    private static final int LOGICAL_DEPENDENCY_BIT = 8;
    private static final int SEMANTICALLY_VALID_BIT = 16;
    private static final int EAGER_BIT = 32;
    private static final int DATA_DRIVEN_BIT = 64;
    private static final int ALL_MATCHES_BIT = 128;
    public static final String DEFAULT_CONSEQUENCE_NAME = "default";
    private String pkg;
    private String name;
    private RuleImpl parent;
    private List<RuleImpl> children;
    private Salience salience = SalienceInteger.DEFAULT_SALIENCE;
    private boolean dirty;
    private Map<String, Declaration> declarations;
    private Map<String, String[]> requiredDeclarations = new HashMap<String, String[]>();
    private GroupElement lhsRoot;
    private String dialect;
    private String agendaGroup = "MAIN";
    private Map<String, Object> metaAttributes = new HashMap<String, Object>();
    private Consequence consequence;
    private Map<String, Consequence> namedConsequences;
    private Timer timer;
    private int loadOrder;
    private String activationGroup;
    private String ruleFlowGroup;
    private String[] calendars;
    private Calendar dateEffective;
    private Calendar dateExpires;
    private Enabled enabled = EnabledBoolean.ENABLED_TRUE;
    private Resource resource;
    protected String activationListener;
    private ConsequenceMetaData consequenceMetaData = new ConsequenceMetaData();
    private List<QueryImpl> usedQueries;
    private Collection<QueryImpl> dependingQueries;
    private int ruleFlags;
    private String ruleUnitClassName;

    public RuleImpl() {
    }

    public RuleImpl(String name) {
        this.name = name;
        this.lhsRoot = GroupElementFactory.newAndInstance();
        this.setSemanticallyValid(true);
        this.setActivationListener("agenda");
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.pkg);
        out.writeObject(this.name);
        out.writeObject(this.parent);
        out.writeObject(this.salience);
        out.writeBoolean(this.dirty);
        out.writeObject(this.declarations);
        out.writeObject(this.lhsRoot);
        out.writeObject(this.dialect);
        out.writeObject(this.agendaGroup);
        out.writeObject(this.metaAttributes);
        out.writeObject(this.requiredDeclarations);
        if (CompiledInvoker.isCompiledInvoker(this.consequence)) {
            out.writeObject(null);
            out.writeObject(null);
        } else {
            out.writeObject(this.consequence);
            out.writeObject(this.namedConsequences);
        }
        out.writeObject(this.timer);
        out.writeInt(this.loadOrder);
        out.writeObject(this.activationGroup);
        out.writeObject(this.ruleFlowGroup);
        out.writeObject(this.calendars);
        out.writeObject(this.dateEffective);
        out.writeObject(this.dateExpires);
        out.writeObject(this.enabled);
        out.writeObject(this.resource);
        out.writeObject(this.activationListener);
        out.writeObject(this.consequenceMetaData);
        out.writeObject(this.usedQueries);
        out.writeInt(this.ruleFlags);
        out.writeObject(this.ruleUnitClassName);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.pkg = (String)in.readObject();
        this.name = (String)in.readObject();
        this.parent = (RuleImpl)in.readObject();
        this.salience = (Salience)in.readObject();
        this.dirty = in.readBoolean();
        this.declarations = (Map)in.readObject();
        this.lhsRoot = (GroupElement)in.readObject();
        this.dialect = (String)in.readObject();
        this.agendaGroup = (String)in.readObject();
        this.metaAttributes = (Map)in.readObject();
        this.requiredDeclarations = (Map)in.readObject();
        this.consequence = (Consequence)in.readObject();
        this.namedConsequences = (Map)in.readObject();
        this.timer = (Timer)in.readObject();
        this.loadOrder = in.readInt();
        this.activationGroup = (String)in.readObject();
        this.ruleFlowGroup = (String)in.readObject();
        this.calendars = (String[])in.readObject();
        this.dateEffective = (Calendar)in.readObject();
        this.dateExpires = (Calendar)in.readObject();
        this.enabled = (Enabled)in.readObject();
        this.resource = (Resource)in.readObject();
        this.activationListener = (String)in.readObject();
        this.consequenceMetaData = (ConsequenceMetaData)in.readObject();
        this.usedQueries = (List)in.readObject();
        this.ruleFlags = in.readInt();
        this.ruleUnitClassName = (String)in.readObject();
    }

    public void addUsedQuery(QueryImpl query) {
        if (this.usedQueries == null) {
            this.usedQueries = new ArrayList<QueryImpl>();
        }
        this.usedQueries.add(query);
    }

    public Collection<QueryImpl> getDependingQueries() {
        if (this.dependingQueries == null) {
            this.dependingQueries = this.usedQueries == null ? Collections.emptyList() : this.collectDependingQueries(new ArrayDeque<QueryImpl>());
        }
        return this.dependingQueries;
    }

    protected Collection<QueryImpl> collectDependingQueries(Deque<QueryImpl> accumulator) {
        if (this.usedQueries == null) {
            return accumulator;
        }
        for (QueryImpl query : this.usedQueries) {
            if (accumulator.contains(query)) continue;
            accumulator.offerFirst(query);
            query.collectDependingQueries(accumulator);
        }
        return accumulator;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    @Override
    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public boolean isValid() {
        return this.consequence != null && this.isSemanticallyValid();
    }

    public String getPackage() {
        return this.pkg;
    }

    public RuleImpl setPackage(String pkg) {
        this.pkg = pkg;
        return this;
    }

    public String getPackageName() {
        return this.pkg;
    }

    public String getName() {
        return this.name;
    }

    public String getFullyQualifiedName() {
        return this.getPackageName() + "." + this.getName();
    }

    public Salience getSalience() {
        return this.salience;
    }

    public int getSalienceValue() {
        return this.getSalience().getValue();
    }

    public boolean isSalienceDynamic() {
        return this.getSalience().isDynamic();
    }

    public void setSalience(Salience salience) {
        this.salience = salience;
        if (salience.isDynamic()) {
            this.setEager(true);
        }
    }

    public String getAgendaGroup() {
        return this.agendaGroup;
    }

    public RuleImpl setAgendaGroup(String agendaGroup) {
        this.agendaGroup = agendaGroup;
        return this;
    }

    public boolean isMainAgendaGroup() {
        return "MAIN".equals(this.agendaGroup);
    }

    private void set(int flag, boolean b) {
        this.ruleFlags = b ? (this.ruleFlags |= flag) : (this.ruleFlags &= -1 - flag);
    }

    private boolean isSet(int flag) {
        return (this.ruleFlags & flag) == flag;
    }

    public boolean isNoLoop() {
        return this.isSet(1);
    }

    public boolean isEffective(BaseTuple tuple, Declaration[] declarations, ValueResolver valueResolver) {
        if (!this.enabled.getValue(tuple, declarations, this, valueResolver)) {
            return false;
        }
        if (this.dateEffective == null && this.dateExpires == null) {
            return true;
        }
        Calendar now = Calendar.getInstance();
        now.setTimeInMillis(valueResolver.getCurrentTime());
        if (this.dateEffective != null && this.dateExpires != null) {
            return now.after(this.dateEffective) && now.before(this.dateExpires);
        }
        if (this.dateEffective != null) {
            return now.after(this.dateEffective);
        }
        return now.before(this.dateExpires);
    }

    public void setNoLoop(boolean noLoop) {
        this.set(1, noLoop);
    }

    public boolean getAutoFocus() {
        return this.isSet(2);
    }

    public void setAutoFocus(boolean autoFocus) {
        this.set(2, autoFocus);
        this.setEager(autoFocus);
    }

    public String getActivationGroup() {
        return this.activationGroup;
    }

    public void setActivationGroup(String activationGroup) {
        this.activationGroup = activationGroup;
        this.setEager(!StringUtils.isEmpty((CharSequence)activationGroup));
    }

    public String getRuleFlowGroup() {
        return this.ruleFlowGroup;
    }

    public void setRuleFlowGroup(String ruleFlowGroup) {
        this.ruleFlowGroup = ruleFlowGroup;
    }

    public Declaration getDeclaration(String identifier) {
        if (this.dirty || this.declarations == null) {
            this.declarations = this.getExtendedLhs(this, null).getOuterDeclarations();
            this.dirty = false;
        }
        return this.declarations.get(identifier);
    }

    public String[] getRequiredDeclarationsForConsequence(String consequenceName) {
        String[] declarations = this.requiredDeclarations.get(consequenceName);
        return declarations != null ? declarations : new String[]{};
    }

    public void setRequiredDeclarationsForConsequence(String consequenceName, String[] requiredDeclarations) {
        this.requiredDeclarations.put(consequenceName, requiredDeclarations);
    }

    public boolean hasLogicalDependency() {
        return this.isSet(8);
    }

    public void setHasLogicalDependency(boolean hasLogicalDependency) {
        this.set(8, hasLogicalDependency);
    }

    public boolean isLockOnActive() {
        return this.isSet(4);
    }

    public void setLockOnActive(boolean lockOnActive) {
        this.set(4, lockOnActive);
    }

    public Map<String, Declaration> getDeclarations() {
        if (this.dirty || this.declarations == null) {
            this.declarations = this.getExtendedLhs(this, null).getOuterDeclarations();
            this.dirty = false;
        }
        return this.declarations;
    }

    public void addPattern(RuleConditionElement element) {
        this.dirty = true;
        this.lhsRoot.addChild(element);
    }

    public GroupElement getLhs() {
        return this.lhsRoot;
    }

    public void setLhs(GroupElement lhsRoot) {
        this.dirty = true;
        this.lhsRoot = lhsRoot;
    }

    private GroupElement getExtendedLhs(RuleImpl rule, GroupElement fromChild) {
        GroupElement lhs = rule.lhsRoot.cloneOnlyGroup();
        if (null != fromChild) {
            lhs.getChildren().addAll(fromChild.getChildren());
        }
        if (rule.parent != null) {
            return this.getExtendedLhs(rule.parent, lhs);
        }
        return lhs;
    }

    public GroupElement[] getTransformedLhs(LogicTransformer transformer, Map<String, Type> globals) throws InvalidPatternException {
        return transformer.transform(this.getExtendedLhs(this, null), globals);
    }

    @Override
    public void wire(Object object) {
        if (object instanceof Consequence) {
            Consequence c = (Consequence)object;
            if (DEFAULT_CONSEQUENCE_NAME.equals(c.getName())) {
                this.setConsequence(c);
            } else {
                this.addNamedConsequence(c.getName(), c);
            }
        } else if (object instanceof Salience) {
            Salience s = (Salience)object;
            this.setSalience(s);
        } else if (object instanceof Enabled) {
            Enabled e = (Enabled)object;
            this.setEnabled(e);
        }
    }

    public void setConsequence(Consequence consequence) {
        this.consequence = consequence;
    }

    public Consequence getConsequence() {
        return this.consequence;
    }

    public boolean hasNamedConsequences() {
        return this.namedConsequences != null && !this.namedConsequences.isEmpty();
    }

    public Consequence getNamedConsequence(String consequenceName) {
        Consequence consequence = this.namedConsequences != null ? this.namedConsequences.get(consequenceName) : null;
        return consequence == null && this.parent != null ? this.parent.getNamedConsequence(consequenceName) : consequence;
    }

    public void addNamedConsequence(String name, Consequence consequence) {
        if (this.namedConsequences == null) {
            this.namedConsequences = new HashMap<String, Consequence>();
        }
        this.namedConsequences.put(name, consequence);
    }

    public int getLoadOrder() {
        return this.loadOrder;
    }

    public void setLoadOrder(int loadOrder) {
        this.loadOrder = loadOrder;
    }

    public boolean isEager() {
        return this.isSet(32);
    }

    public void setEager(boolean eager) {
        this.set(32, eager);
    }

    public boolean isDataDriven() {
        return this.isSet(64);
    }

    public void setDataDriven(boolean dataDriven) {
        this.set(64, dataDriven);
    }

    public boolean isAllMatches() {
        return this.isSet(128);
    }

    public void setAllMatches(boolean allMatches) {
        this.set(128, allMatches);
    }

    public String toString() {
        return "[Rule name=" + this.name + ", agendaGroup=" + this.agendaGroup + ", salience=" + this.salience + ", no-loop=" + this.isNoLoop() + "]";
    }

    public String toRuleNameAndPathString() {
        String path = this.getResource() != null ? this.getResource().getSourcePath() : null;
        return "Rule \"" + this.getName() + "\"" + (String)(path != null ? " in " + path : "");
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.pkg == null ? 0 : this.pkg.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RuleImpl other = (RuleImpl)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.pkg == null) {
            return other.pkg == null;
        }
        return this.pkg.equals(other.pkg);
    }

    public void setSemanticallyValid(boolean valid) {
        this.set(16, valid);
    }

    public boolean isSemanticallyValid() {
        return this.isSet(16);
    }

    public boolean hasCalendars() {
        return this.calendars != null && this.calendars.length > 0;
    }

    public String[] getCalendars() {
        return this.calendars;
    }

    public void setCalendars(String[] calendars) {
        this.calendars = calendars;
    }

    public void setDateEffective(Calendar effectiveDate) {
        this.dateEffective = effectiveDate;
    }

    public void setDateExpires(Calendar expiresDate) {
        this.dateExpires = expiresDate;
    }

    public Calendar getDateEffective() {
        return this.dateEffective;
    }

    public Calendar getDateExpires() {
        return this.dateExpires;
    }

    public void setEnabled(Enabled b) {
        this.enabled = b;
    }

    public Enabled getEnabled() {
        return this.enabled;
    }

    public boolean isEnabled(BaseTuple tuple, Declaration[] enabledDeclarations, ValueResolver valueResolver) {
        return this.enabled.getValue(tuple, enabledDeclarations, this, valueResolver);
    }

    public void addMetaAttribute(String key, Object value) {
        this.metaAttributes.put(key, value);
    }

    public String getActivationListener() {
        return this.activationListener;
    }

    public void setActivationListener(String activationListener) {
        this.activationListener = activationListener;
    }

    public Map<String, Object> getMetaData() {
        return Collections.unmodifiableMap(this.metaAttributes);
    }

    public Object getMetaData(String name) {
        return this.metaAttributes.get(name);
    }

    public void setParent(RuleImpl parent) {
        this.parent = parent;
        parent.addChild(this);
    }

    public RuleImpl getParent() {
        return this.parent;
    }

    public synchronized void addChild(RuleImpl child) {
        if (this.children == null) {
            this.children = new ArrayList<RuleImpl>();
        }
        this.children.add(child);
    }

    public void removeChild(RuleImpl child) {
        this.children.remove(child);
    }

    public List<RuleImpl> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public boolean isQuery() {
        return false;
    }

    public KieDefinition.KnowledgeType getKnowledgeType() {
        return KieDefinition.KnowledgeType.RULE;
    }

    public String getNamespace() {
        return this.getPackage();
    }

    public String getId() {
        return this.getName();
    }

    public ConsequenceMetaData getConsequenceMetaData() {
        return this.consequenceMetaData;
    }

    public String getRuleUnitClassName() {
        return this.ruleUnitClassName;
    }

    public void setRuleUnitClass(Class<?> ruleUnit) {
        this.setRuleUnitClassName(ruleUnit.getName());
    }

    public void setRuleUnitClassName(String ruleUnitClassName) {
        this.ruleUnitClassName = ruleUnitClassName;
    }

    public Declaration[] findEnabledDeclarations(Map<String, Declaration> decls) {
        return this.enabled.findDeclarations(decls);
    }

    public Declaration[] findSalienceDeclarations(Map<String, Declaration> decls) {
        return this.salience.findDeclarations(decls);
    }
}

