/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.base.reteoo.BaseTuple;
import org.drools.base.rule.accessor.TupleValueExtractor;

public class IndexedValueReader
implements Externalizable {
    private static final long serialVersionUID = 510L;
    private TupleValueExtractor leftExtractor;
    private TupleValueExtractor rightExtractor;
    private boolean requiresCoercion;

    public IndexedValueReader() {
    }

    public IndexedValueReader(TupleValueExtractor leftExtractor, TupleValueExtractor rightExtractor) {
        this.leftExtractor = leftExtractor;
        this.rightExtractor = rightExtractor;
        this.requiresCoercion = this.isCoercionRequired(rightExtractor, leftExtractor);
    }

    private boolean isCoercionRequired(TupleValueExtractor extractor, TupleValueExtractor declaration) {
        return extractor.getValueType() != declaration.getValueType();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rightExtractor = (TupleValueExtractor)in.readObject();
        this.leftExtractor = (TupleValueExtractor)in.readObject();
        this.requiresCoercion = this.isCoercionRequired(this.rightExtractor, this.leftExtractor);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.rightExtractor);
        out.writeObject(this.leftExtractor);
    }

    public TupleValueExtractor getLeftExtractor() {
        return this.leftExtractor;
    }

    public TupleValueExtractor getRightExtractor() {
        return this.rightExtractor;
    }

    public boolean requiresCoercion() {
        return this.requiresCoercion;
    }

    public Object indexedValueOf(BaseTuple tuple, boolean left) {
        return left ? (this.requiresCoercion ? this.rightExtractor.getValueType().coerce(this.leftExtractor.getValue(tuple)) : this.leftExtractor.getValue(tuple)) : this.rightExtractor.getValue(tuple);
    }
}

