/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.expr;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.drools.base.base.ValueResolver;
import org.drools.base.reteoo.BaseTuple;
import org.drools.base.rule.Declaration;
import org.drools.base.rule.accessor.GlobalResolver;
import org.drools.compiler.rule.builder.EvaluatorWrapper;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.rule.consequence.KnowledgeHelper;
import org.drools.mvel.MVELDialectRuntimeData;
import org.drools.mvel.expr.ActivationPropertyHandler;
import org.drools.mvel.expr.MVELCalendarCoercion;
import org.drools.mvel.expr.MVELDateCoercion;
import org.drools.mvel.expr.MVELDebugHandler;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.FactHandle;
import org.mvel2.ConversionHandler;
import org.mvel2.DataConversion;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.PropertyHandler;
import org.mvel2.integration.PropertyHandlerFactory;
import org.mvel2.integration.VariableResolver;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.util.SimpleVariableSpaceModel;

public class MVELCompilationUnit
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = 510L;
    private String name;
    private String expression;
    private String[] globalIdentifiers;
    private EvaluatorWrapper[] operators;
    private Declaration[] previousDeclarations;
    private Declaration[] localDeclarations;
    private String[] otherIdentifiers;
    private String[] inputIdentifiers;
    private String[] inputTypes;
    private boolean strictMode;
    private boolean readLocalsFromTuple;
    private SimpleVariableSpaceModel varModel;
    private int allVarsLength;
    private static final Map<String, Class<?>> primitivesMap;

    public MVELCompilationUnit() {
    }

    public MVELCompilationUnit(String name, String expression, String[] globalIdentifiers, EvaluatorWrapper[] operators, Declaration[] previousDeclarations, Declaration[] localDeclarations, String[] otherIdentifiers, String[] inputIdentifiers, String[] inputTypes, boolean strictMode, boolean readLocalsFromTuple) {
        this.name = name;
        this.expression = expression;
        this.globalIdentifiers = globalIdentifiers;
        this.operators = operators;
        this.previousDeclarations = previousDeclarations;
        this.localDeclarations = localDeclarations;
        this.otherIdentifiers = otherIdentifiers;
        this.inputIdentifiers = inputIdentifiers;
        this.inputTypes = inputTypes;
        this.strictMode = strictMode;
        this.readLocalsFromTuple = readLocalsFromTuple;
    }

    public String getExpression() {
        return this.expression;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MVELCompilationUnit)) {
            return false;
        }
        MVELCompilationUnit other = (MVELCompilationUnit)obj;
        return this.expression.equals(other.expression) && Arrays.equals(this.previousDeclarations, other.previousDeclarations) && Arrays.equals(this.localDeclarations, other.localDeclarations);
    }

    public int hashCode() {
        return 23 * this.expression.hashCode() + 29 * Arrays.hashCode(this.previousDeclarations) + 31 * Arrays.hashCode(this.localDeclarations);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.expression);
        out.writeObject(this.globalIdentifiers);
        out.writeObject(this.operators);
        out.writeObject(this.previousDeclarations);
        out.writeObject(this.localDeclarations);
        out.writeObject(this.otherIdentifiers);
        out.writeObject(this.inputIdentifiers);
        out.writeObject(this.inputTypes);
        out.writeBoolean(this.strictMode);
        out.writeBoolean(this.readLocalsFromTuple);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.expression = in.readUTF();
        this.globalIdentifiers = (String[])in.readObject();
        this.operators = (EvaluatorWrapper[])in.readObject();
        this.previousDeclarations = (Declaration[])in.readObject();
        this.localDeclarations = (Declaration[])in.readObject();
        this.otherIdentifiers = (String[])in.readObject();
        this.inputIdentifiers = (String[])in.readObject();
        this.inputTypes = (String[])in.readObject();
        this.strictMode = in.readBoolean();
        this.readLocalsFromTuple = in.readBoolean();
    }

    public Serializable getCompiledExpression(MVELDialectRuntimeData runtimeData) {
        return this.getCompiledExpression(runtimeData, null);
    }

    public Serializable getCompiledExpression(ParserConfiguration conf) {
        return this.getCompiledExpression(conf, null);
    }

    public Serializable getCompiledExpression(MVELDialectRuntimeData runtimeData, Object evaluationContext) {
        return this.getCompiledExpression(runtimeData.getParserConfiguration(), evaluationContext);
    }

    public Serializable getCompiledExpression(ParserConfiguration conf, Object evaluationContext) {
        ParserContext parserContext = new ParserContext(conf, evaluationContext);
        if (MVELDebugHandler.isDebugMode()) {
            parserContext.setDebugSymbols(true);
        }
        parserContext.setStrictTypeEnforcement(this.strictMode);
        parserContext.setStrongTyping(this.strictMode);
        parserContext.setIndexAllocation(true);
        parserContext.addIndexedInput(this.inputIdentifiers);
        String identifier = null;
        String type = null;
        try {
            int length = this.inputIdentifiers.length;
            for (int i = 0; i < length; ++i) {
                identifier = this.inputIdentifiers[i];
                type = this.inputTypes[i];
                Class cls = MVELCompilationUnit.loadClass(conf.getClassLoader(), this.inputTypes[i]);
                parserContext.addInput(this.inputIdentifiers[i], cls);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to resolve class '" + type + "' for identifier '" + identifier);
        }
        parserContext.setSourceFile(this.name);
        String[] varNames = parserContext.getIndexedVarNames();
        ExecutableStatement stmt = (ExecutableStatement)MVELCompilationUnit.compile(this.expression, parserContext);
        Set localNames = parserContext.getVariables().keySet();
        parserContext.addIndexedLocals(localNames);
        String[] locals = localNames.toArray(new String[localNames.size()]);
        String[] allVars = new String[varNames.length + locals.length];
        System.arraycopy(varNames, 0, allVars, 0, varNames.length);
        System.arraycopy(locals, 0, allVars, varNames.length, locals.length);
        this.varModel = new SimpleVariableSpaceModel(allVars);
        this.allVarsLength = allVars.length;
        return stmt;
    }

    public VariableResolverFactory createFactory() {
        Object[] vals = new Object[this.inputIdentifiers.length];
        VariableResolverFactory factory = this.varModel.createFactory(vals);
        factory.setNextFactory((VariableResolverFactory)new DroolsVarFactory());
        return factory;
    }

    public VariableResolverFactory getFactory(Object knowledgeHelper, Declaration[] prevDecl, Rule rule, BaseTuple tuples, Object[] otherVars, ValueResolver valueResolver, GlobalResolver globals) {
        VariableResolverFactory factory = this.createFactory();
        this.updateFactory(knowledgeHelper, prevDecl, rule, null, knowledgeHelper, tuples, otherVars, valueResolver, globals, factory);
        return factory;
    }

    public VariableResolverFactory getFactory(Object knowledgeHelper, Declaration[] prevDecl, Rule rule, FactHandle rightHandle, BaseTuple tuple, Object[] otherVars, ValueResolver valueResolver, GlobalResolver globals) {
        VariableResolverFactory factory = this.createFactory();
        this.updateFactory(knowledgeHelper, prevDecl, rule, rightHandle, rightHandle != null ? rightHandle.getObject() : null, tuple, otherVars, valueResolver, globals, factory);
        return factory;
    }

    public void updateFactory(FactHandle rightHandle, BaseTuple tuple, Object[] localVars, ValueResolver valueResolver, GlobalResolver globalResolver, VariableResolverFactory factory) {
        this.updateFactory(null, null, null, rightHandle, rightHandle != null ? rightHandle.getObject() : null, tuple, localVars, valueResolver, globalResolver, factory);
    }

    private void updateFactory(Object knowledgeHelper, Declaration[] prevDecl, Rule rule, FactHandle rightHandle, Object rightObject, BaseTuple tuple, Object[] otherVars, ValueResolver valueResolver, GlobalResolver globals, VariableResolverFactory factory) {
        FactHandle[] handles;
        int varLength = this.inputIdentifiers.length;
        int i = 0;
        if ("this".equals(this.inputIdentifiers[0])) {
            factory.getIndexedVariableResolver(i++).setValue(rightObject);
        }
        factory.getIndexedVariableResolver(i++).setValue(knowledgeHelper);
        factory.getIndexedVariableResolver(i++).setValue(knowledgeHelper);
        if (this.inputIdentifiers.length > i && "rule".equals(this.inputIdentifiers[i])) {
            factory.getIndexedVariableResolver(i++).setValue((Object)rule);
        }
        if (this.globalIdentifiers != null) {
            for (String globalIdentifier : this.globalIdentifiers) {
                if ("_workingMemory_".equals(globalIdentifier)) {
                    factory.getIndexedVariableResolver(i++).setValue((Object)valueResolver);
                    continue;
                }
                factory.getIndexedVariableResolver(i++).setValue(globals.resolveGlobal(globalIdentifier));
            }
        }
        FactHandle[] factHandleArray = handles = tuple instanceof LeftTuple ? tuple.toFactHandles() : null;
        if (this.operators.length > 0) {
            for (EvaluatorWrapper operator : this.operators) {
                factory.getIndexedVariableResolver(i++).setValue((Object)operator);
                operator.loadHandles(handles, rightHandle);
            }
        }
        Object[] objs = null;
        if (tuple != null) {
            if (handles == null) {
                objs = tuple.toObjects();
            }
            if (this.previousDeclarations != null && this.previousDeclarations.length > 0) {
                if (prevDecl == null) {
                    prevDecl = this.previousDeclarations;
                }
                for (Declaration decl : prevDecl) {
                    Object o = decl.getValue(valueResolver, objs != null ? objs[decl.getObjectIndex()] : handles[decl.getObjectIndex()].getObject());
                    factory.getIndexedVariableResolver(i++).setValue(o);
                }
            }
        }
        if (this.localDeclarations != null && this.localDeclarations.length > 0) {
            for (Declaration decl : this.localDeclarations) {
                Object value = this.readLocalsFromTuple && tuple != null ? decl.getValue(valueResolver, objs != null ? objs[decl.getObjectIndex()] : handles[decl.getObjectIndex()].getObject()) : decl.getValue(valueResolver, rightObject);
                factory.getIndexedVariableResolver(i++).setValue(value);
            }
        }
        int otherVarsPos = 0;
        if (otherVars != null) {
            otherVarsPos = i;
            for (Object o : otherVars) {
                factory.getIndexedVariableResolver(i++).setValue(o);
            }
        }
        int otherVarsLength = i - otherVarsPos;
        for (i = varLength; i < this.allVarsLength; ++i) {
            factory.getIndexedVariableResolver(i).setValue(null);
        }
        DroolsVarFactory df = (DroolsVarFactory)factory.getNextFactory();
        df.setOtherVarsPos(otherVarsPos);
        df.setOtherVarsLength(otherVarsLength);
        if (knowledgeHelper instanceof KnowledgeHelper) {
            KnowledgeHelper kh = (KnowledgeHelper)knowledgeHelper;
            df.setKnowledgeHelper(kh);
        }
    }

    private static Serializable compile(String text, ParserContext parserContext) {
        MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
        MVEL.COMPILER_OPT_ALLOW_OVERRIDE_ALL_PROPHANDLING = true;
        MVEL.COMPILER_OPT_ALLOW_RESOLVE_INNERCLASSES_WITH_DOTNOTATION = true;
        MVEL.COMPILER_OPT_SUPPORT_JAVA_STYLE_CLASS_LITERALS = true;
        if (MVELDebugHandler.isDebugMode()) {
            parserContext.setDebugSymbols(true);
        }
        return MVEL.compileExpression((String)text.trim(), (ParserContext)parserContext);
    }

    public static Class loadClass(ClassLoader classLoader, String className) throws ClassNotFoundException {
        Class<?> cls = primitivesMap.get(className);
        if (cls == null) {
            cls = classLoader.loadClass(className);
        }
        return cls;
    }

    public void replaceDeclaration(Declaration declaration, Declaration resolved) {
        int i;
        if (this.previousDeclarations != null) {
            for (i = 0; i < this.previousDeclarations.length; ++i) {
                if (!this.previousDeclarations[i].equals((Object)declaration)) continue;
                this.previousDeclarations[i] = resolved;
            }
        }
        if (this.localDeclarations != null) {
            for (i = 0; i < this.localDeclarations.length; ++i) {
                if (!this.localDeclarations[i].equals((Object)declaration)) continue;
                this.localDeclarations[i] = resolved;
            }
        }
    }

    public MVELCompilationUnit clone() {
        Declaration[] clonedPreviousDeclarations = null;
        if (this.previousDeclarations != null) {
            clonedPreviousDeclarations = new Declaration[this.previousDeclarations.length];
            System.arraycopy(this.previousDeclarations, 0, clonedPreviousDeclarations, 0, this.previousDeclarations.length);
        }
        Declaration[] clonedLocalDeclarations = null;
        if (this.localDeclarations != null) {
            clonedLocalDeclarations = new Declaration[this.localDeclarations.length];
            System.arraycopy(this.localDeclarations, 0, clonedLocalDeclarations, 0, this.localDeclarations.length);
        }
        MVELCompilationUnit unit = new MVELCompilationUnit(this.name, this.expression, this.globalIdentifiers, this.operators, clonedPreviousDeclarations, clonedLocalDeclarations, this.otherIdentifiers, this.inputIdentifiers, this.inputTypes, this.strictMode, this.readLocalsFromTuple);
        unit.varModel = this.varModel;
        return unit;
    }

    public static long getSerialversionuid() {
        return 510L;
    }

    public String getName() {
        return this.name;
    }

    public String[] getGlobalIdentifiers() {
        return this.globalIdentifiers;
    }

    public Declaration[] getPreviousDeclarations() {
        return this.previousDeclarations;
    }

    public void setPreviousDeclarations(Declaration[] previousDeclarations) {
        this.previousDeclarations = previousDeclarations;
    }

    public Declaration[] getLocalDeclarations() {
        return this.localDeclarations;
    }

    public String[] getOtherIdentifiers() {
        return this.otherIdentifiers;
    }

    public String[] getInputIdentifiers() {
        return this.inputIdentifiers;
    }

    public String[] getInputTypes() {
        return this.inputTypes;
    }

    public boolean isStrictMode() {
        return this.strictMode;
    }

    public static Map<String, Class<?>> getPrimitivesmap() {
        return primitivesMap;
    }

    public String toString() {
        return this.expression;
    }

    static {
        DataConversion.addConversionHandler(Date.class, (ConversionHandler)new MVELDateCoercion());
        DataConversion.addConversionHandler(Calendar.class, (ConversionHandler)new MVELCalendarCoercion());
        OptimizerFactory.setDefaultOptimizer((String)OptimizerFactory.SAFE_REFLECTIVE);
        PropertyHandler handler2 = PropertyHandlerFactory.getPropertyHandler(RuleTerminalNodeLeftTuple.class);
        if (handler2 == null) {
            PropertyHandlerFactoryFixer.getPropertyHandlerClass().put(RuleTerminalNodeLeftTuple.class, new ActivationPropertyHandler());
        }
        primitivesMap = new HashMap();
        primitivesMap.put("int", Integer.TYPE);
        primitivesMap.put("boolean", Boolean.TYPE);
        primitivesMap.put("float", Float.TYPE);
        primitivesMap.put("long", Long.TYPE);
        primitivesMap.put("short", Short.TYPE);
        primitivesMap.put("byte", Byte.TYPE);
        primitivesMap.put("double", Double.TYPE);
        primitivesMap.put("char", Character.TYPE);
    }

    public static class DroolsVarFactory
    implements VariableResolverFactory {
        private KnowledgeHelper knowledgeHelper;
        private int otherVarsPos;
        private int otherVarsLength;

        public KnowledgeHelper getKnowledgeHelper() {
            return this.knowledgeHelper;
        }

        public void setKnowledgeHelper(KnowledgeHelper kh) {
            this.knowledgeHelper = kh;
        }

        public int getOtherVarsPos() {
            return this.otherVarsPos;
        }

        public void setOtherVarsPos(int otherVarsPos) {
            this.otherVarsPos = otherVarsPos;
        }

        public int getOtherVarsLength() {
            return this.otherVarsLength;
        }

        public void setOtherVarsLength(int otherVarsLength) {
            this.otherVarsLength = otherVarsLength;
        }

        public VariableResolver createIndexedVariable(int index, String name, Object value) {
            throw new UnsupportedOperationException();
        }

        public VariableResolver getIndexedVariableResolver(int index) {
            throw new UnsupportedOperationException();
        }

        public VariableResolver createVariable(String name, Object value) {
            throw new UnsupportedOperationException();
        }

        public VariableResolver createVariable(String name, Object value, Class<?> type) {
            throw new UnsupportedOperationException();
        }

        public VariableResolver getVariableResolver(String name) {
            return null;
        }

        public boolean isResolveable(String name) {
            return false;
        }

        public boolean isTarget(String name) {
            return false;
        }

        public Set<String> getKnownVariables() {
            return Collections.emptySet();
        }

        public void clear() {
        }

        public boolean isIndexedFactory() {
            return false;
        }

        public VariableResolver createIndexedVariable(int index, String name, Object value, Class<?> typee) {
            return null;
        }

        public VariableResolver setIndexedVariableResolver(int index, VariableResolver variableResolver) {
            return null;
        }

        public VariableResolverFactory getNextFactory() {
            return null;
        }

        public VariableResolverFactory setNextFactory(VariableResolverFactory resolverFactory) {
            return null;
        }

        public int variableIndexOf(String name) {
            return 0;
        }

        public boolean tiltFlag() {
            return false;
        }

        public void setTiltFlag(boolean tilt) {
        }
    }

    public static class PropertyHandlerFactoryFixer
    extends PropertyHandlerFactory {
        public static Map<Class, PropertyHandler> getPropertyHandlerClass() {
            return propertyHandlerClass;
        }
    }

    public static enum Scope {
        CONSTRAINT,
        CONSEQUENCE,
        EXPRESSION;


        public boolean hasRule() {
            return this != CONSTRAINT;
        }
    }
}

