/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.impl.humantask;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jbpm.process.instance.impl.humantask.InternalHumanTaskWorkItem;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.process.workitem.Attachment;
import org.kie.kogito.process.workitem.Comment;
import org.kie.kogito.process.workitem.NotAuthorizedException;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitems.impl.KogitoWorkItemImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HumanTaskWorkItemImpl
extends KogitoWorkItemImpl
implements InternalHumanTaskWorkItem {
    private static final long serialVersionUID = 6168927742199190604L;
    private static final Logger logger = LoggerFactory.getLogger(HumanTaskWorkItemImpl.class);
    private String taskName;
    private String taskDescription;
    private String taskPriority;
    private String referenceName;
    private String actualOwner;
    private Set<String> potentialUsers = new HashSet<String>();
    private Set<String> potentialGroups = new HashSet<String>();
    private Set<String> excludedUsers = new HashSet<String>();
    private Set<String> adminUsers = new HashSet<String>();
    private Set<String> adminGroups = new HashSet<String>();
    private Map<Object, Comment> comments = new ConcurrentHashMap<Object, Comment>();
    private Map<Object, Attachment> attachments = new ConcurrentHashMap<Object, Attachment>();

    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getTaskDescription() {
        return this.taskDescription;
    }

    @Override
    public void setTaskDescription(String taskDescription) {
        this.taskDescription = taskDescription;
    }

    public String getTaskPriority() {
        return this.taskPriority;
    }

    @Override
    public void setTaskPriority(String taskPriority) {
        this.taskPriority = taskPriority;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    @Override
    public void setReferenceName(String referenceName) {
        this.referenceName = referenceName;
    }

    public String getActualOwner() {
        return this.actualOwner;
    }

    @Override
    public void setActualOwner(String actualOwner) {
        this.actualOwner = actualOwner;
    }

    public Set<String> getPotentialUsers() {
        return this.potentialUsers;
    }

    @Override
    public void setPotentialUsers(Set<String> potentialUsers) {
        this.potentialUsers = potentialUsers;
    }

    public Set<String> getPotentialGroups() {
        return this.potentialGroups;
    }

    @Override
    public void setPotentialGroups(Set<String> potentialGroups) {
        this.potentialGroups = potentialGroups;
    }

    public Set<String> getExcludedUsers() {
        return this.excludedUsers;
    }

    @Override
    public void setExcludedUsers(Set<String> excludedUsers) {
        this.excludedUsers = excludedUsers;
    }

    public Set<String> getAdminUsers() {
        return this.adminUsers;
    }

    @Override
    public void setAdminUsers(Set<String> adminUsers) {
        this.adminUsers = adminUsers;
    }

    public Set<String> getAdminGroups() {
        return this.adminGroups;
    }

    @Override
    public void setAdminGroups(Set<String> adminGroups) {
        this.adminGroups = adminGroups;
    }

    public boolean enforce(Policy<?> ... policies) {
        for (Policy<?> policy : policies) {
            if (!(policy instanceof SecurityPolicy)) continue;
            try {
                this.enforceAuthorization(((SecurityPolicy)policy).value());
                return true;
            }
            catch (NotAuthorizedException e) {
                return false;
            }
        }
        boolean authorized = true;
        String currentOwner = this.getActualOwner();
        if (currentOwner != null && !currentOwner.trim().isEmpty() || !this.getPotentialUsers().isEmpty()) {
            authorized = false;
        }
        return authorized;
    }

    protected void enforceAuthorization(IdentityProvider identity) {
        if (identity != null) {
            logger.debug("Identity information provided, enforcing security restrictions, user '{}' with roles '{}'", (Object)identity.getName(), (Object)identity.getRoles());
            String user = identity.getName();
            String currentOwner = this.getActualOwner();
            if (!(currentOwner == null || currentOwner.trim().isEmpty() || user.equals(currentOwner) || this.getAdminUsers() != null && this.getAdminUsers().contains(user))) {
                logger.debug("Work item {} has already owner assigned so requesting user must match - owner '{}' == requestor '{}'", new Object[]{this.getStringId(), currentOwner, user});
                throw new NotAuthorizedException("User " + user + " is not authorized to access task instance with id " + this.getStringId());
            }
            this.checkAssignedOwners(user, identity.getRoles());
        }
    }

    protected void checkAssignedOwners(String user, Collection<String> roles) {
        if (this.getExcludedUsers().contains(user)) {
            logger.debug("Requesting user '{}' is excluded from the potential workers on work item {}", (Object)user, (Object)this.getStringId());
            throw new NotAuthorizedException("User " + user + " is not authorized to access task instance with id " + this.getStringId());
        }
        if (this.getPotentialUsers().isEmpty() && this.getPotentialGroups().isEmpty()) {
            return;
        }
        if (!this.getPotentialUsers().contains(user)) {
            if (this.getPotentialGroups().stream().noneMatch(roles::contains)) {
                throw new NotAuthorizedException("User " + user + " is not authorized to access task instance with id " + this.getStringId());
            }
        }
    }

    public Map<Object, Attachment> getAttachments() {
        return this.attachments;
    }

    public Map<Object, Comment> getComments() {
        return this.comments;
    }

    @Override
    public void setAttachment(String id, Attachment attachment) {
        this.attachments.put(id, attachment);
    }

    @Override
    public Attachment removeAttachment(String id) {
        return this.attachments.remove(id);
    }

    @Override
    public void setComment(String id, Comment comment) {
        this.comments.put(id, comment);
    }

    @Override
    public Comment removeComment(String id) {
        return this.comments.remove(1);
    }
}

