/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core;

import java.util.Map;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.context.exception.ActionExceptionHandler;
import org.jbpm.process.core.context.exception.CompensationScope;
import org.jbpm.process.core.context.exception.ExceptionHandler;
import org.jbpm.process.core.context.exception.ExceptionScope;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.instance.impl.actions.SignalProcessInstanceAction;
import org.jbpm.ruleflow.core.factory.ActionNodeFactory;
import org.jbpm.ruleflow.core.factory.BoundaryEventNodeFactory;
import org.jbpm.ruleflow.core.factory.CatchLinkNodeFactory;
import org.jbpm.ruleflow.core.factory.CompositeContextNodeFactory;
import org.jbpm.ruleflow.core.factory.DynamicNodeFactory;
import org.jbpm.ruleflow.core.factory.EndNodeFactory;
import org.jbpm.ruleflow.core.factory.EventNodeFactory;
import org.jbpm.ruleflow.core.factory.EventSubProcessNodeFactory;
import org.jbpm.ruleflow.core.factory.ExtendedNodeFactory;
import org.jbpm.ruleflow.core.factory.FaultNodeFactory;
import org.jbpm.ruleflow.core.factory.ForEachNodeFactory;
import org.jbpm.ruleflow.core.factory.HumanTaskNodeFactory;
import org.jbpm.ruleflow.core.factory.JoinFactory;
import org.jbpm.ruleflow.core.factory.MilestoneNodeFactory;
import org.jbpm.ruleflow.core.factory.NodeFactory;
import org.jbpm.ruleflow.core.factory.RuleSetNodeFactory;
import org.jbpm.ruleflow.core.factory.SplitFactory;
import org.jbpm.ruleflow.core.factory.StartNodeFactory;
import org.jbpm.ruleflow.core.factory.StateNodeFactory;
import org.jbpm.ruleflow.core.factory.SubProcessNodeFactory;
import org.jbpm.ruleflow.core.factory.ThrowLinkNodeFactory;
import org.jbpm.ruleflow.core.factory.TimerNodeFactory;
import org.jbpm.ruleflow.core.factory.WorkItemNodeFactory;
import org.jbpm.ruleflow.core.factory.provider.NodeFactoryProviderService;
import org.jbpm.workflow.core.Connection;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.BoundaryEventNode;
import org.jbpm.workflow.core.node.CatchLinkNode;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.jbpm.workflow.core.node.DynamicNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.EventSubProcessNode;
import org.jbpm.workflow.core.node.FaultNode;
import org.jbpm.workflow.core.node.ForEachNode;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.Join;
import org.jbpm.workflow.core.node.MilestoneNode;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.jbpm.workflow.core.node.Split;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.StateNode;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.core.node.ThrowLinkNode;
import org.jbpm.workflow.core.node.TimerNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.WorkflowElementIdentifier;

public abstract class RuleFlowNodeContainerFactory<T extends RuleFlowNodeContainerFactory<T, P>, P extends RuleFlowNodeContainerFactory<P, ?>>
extends ExtendedNodeFactory<T, P> {
    public static final String METHOD_CONNECTION = "connection";
    public static final String METHOD_ASSOCIATION = "association";
    private NodeFactoryProviderService provider = new NodeFactoryProviderService();

    public RuleFlowNodeContainerFactory(P nodeContainerFactory, NodeContainer nodeContainer, org.jbpm.workflow.core.Node node, WorkflowElementIdentifier id) {
        super(nodeContainerFactory, nodeContainer, node, id);
    }

    protected abstract NodeContainer getNodeContainer();

    public <R extends NodeFactory<R, T>> R newNode(Class<?> node, WorkflowElementIdentifier id) {
        return (R)this.provider.newNodeFactory(node, this, this.getNodeContainer(), id);
    }

    public StartNodeFactory<T> startNode(WorkflowElementIdentifier id) {
        return (StartNodeFactory)this.newNode(StartNode.class, id);
    }

    public EndNodeFactory<T> endNode(WorkflowElementIdentifier id) {
        return (EndNodeFactory)this.newNode(EndNode.class, id);
    }

    public CatchLinkNodeFactory<T> catchLinkNode(WorkflowElementIdentifier id) {
        return (CatchLinkNodeFactory)this.newNode(CatchLinkNode.class, id);
    }

    public ThrowLinkNodeFactory<T> throwLinkNode(WorkflowElementIdentifier id) {
        return (ThrowLinkNodeFactory)this.newNode(ThrowLinkNode.class, id);
    }

    public ActionNodeFactory<T> actionNode(WorkflowElementIdentifier id) {
        return (ActionNodeFactory)this.newNode(ActionNode.class, id);
    }

    public MilestoneNodeFactory<T> milestoneNode(WorkflowElementIdentifier id) {
        return (MilestoneNodeFactory)this.newNode(MilestoneNode.class, id);
    }

    public TimerNodeFactory<T> timerNode(WorkflowElementIdentifier id) {
        return (TimerNodeFactory)this.newNode(TimerNode.class, id);
    }

    public HumanTaskNodeFactory<T> humanTaskNode(WorkflowElementIdentifier id) {
        return (HumanTaskNodeFactory)this.newNode(HumanTaskNode.class, id);
    }

    public SubProcessNodeFactory<T> subProcessNode(WorkflowElementIdentifier id) {
        return (SubProcessNodeFactory)this.newNode(SubProcessNode.class, id);
    }

    public SplitFactory<T> splitNode(WorkflowElementIdentifier id) {
        return (SplitFactory)this.newNode(Split.class, id);
    }

    public JoinFactory<T> joinNode(WorkflowElementIdentifier id) {
        return (JoinFactory)this.newNode(Join.class, id);
    }

    public RuleSetNodeFactory<T> ruleSetNode(WorkflowElementIdentifier id) {
        return (RuleSetNodeFactory)this.newNode(RuleSetNode.class, id);
    }

    public FaultNodeFactory<T> faultNode(WorkflowElementIdentifier id) {
        return (FaultNodeFactory)this.newNode(FaultNode.class, id);
    }

    public EventNodeFactory<T> eventNode(WorkflowElementIdentifier id) {
        return (EventNodeFactory)this.newNode(EventNode.class, id);
    }

    public BoundaryEventNodeFactory<T> boundaryEventNode(WorkflowElementIdentifier id) {
        return (BoundaryEventNodeFactory)this.newNode(BoundaryEventNode.class, id);
    }

    public CompositeContextNodeFactory<T> compositeContextNode(WorkflowElementIdentifier id) {
        return (CompositeContextNodeFactory)this.newNode(CompositeContextNode.class, id);
    }

    public ForEachNodeFactory<T> forEachNode(WorkflowElementIdentifier id) {
        return (ForEachNodeFactory)this.newNode(ForEachNode.class, id);
    }

    public DynamicNodeFactory<T> dynamicNode(WorkflowElementIdentifier id) {
        return (DynamicNodeFactory)this.newNode(DynamicNode.class, id);
    }

    public WorkItemNodeFactory<T> workItemNode(WorkflowElementIdentifier id) {
        return (WorkItemNodeFactory)this.newNode(WorkItemNode.class, id);
    }

    public EventSubProcessNodeFactory<T> eventSubProcessNode(WorkflowElementIdentifier id) {
        return (EventSubProcessNodeFactory)this.newNode(EventSubProcessNode.class, id);
    }

    public StateNodeFactory<T> stateNode(WorkflowElementIdentifier id) {
        return (StateNodeFactory)this.newNode(StateNode.class, id);
    }

    public T connection(WorkflowElementIdentifier fromId, WorkflowElementIdentifier toId) {
        return this.connection(fromId, toId, fromId.toSanitizeString() + "_" + toId.toSanitizeString());
    }

    public T connection(WorkflowElementIdentifier fromId, WorkflowElementIdentifier toId, String uniqueId) {
        this.getConnection(fromId, toId, uniqueId);
        return (T)this;
    }

    public T association(WorkflowElementIdentifier fromId, WorkflowElementIdentifier toId, String uniqueId) {
        Connection connection = this.getConnection(fromId, toId, uniqueId);
        connection.setMetaData(METHOD_ASSOCIATION, Boolean.TRUE);
        connection.setMetaData("hidden", Boolean.TRUE);
        return (T)this;
    }

    private Connection getConnection(WorkflowElementIdentifier fromId, WorkflowElementIdentifier toId, String uniqueId) {
        Node from = this.getNodeContainer().getNode(fromId);
        Node to = this.getNodeContainer().getNode(toId);
        ConnectionImpl connection = new ConnectionImpl(from, "DROOLS_DEFAULT", to, "DROOLS_DEFAULT");
        if (uniqueId != null) {
            connection.setMetaData("UniqueId", uniqueId);
        }
        return connection;
    }

    public T exceptionHandler(String exception, ExceptionHandler exceptionHandler) {
        this.getScope("ExceptionScope", ExceptionScope.class).setExceptionHandler(exception, exceptionHandler);
        return (T)this;
    }

    public T exceptionHandler(String exception, String dialect, String action) {
        ActionExceptionHandler exceptionHandler = new ActionExceptionHandler();
        exceptionHandler.setAction(new DroolsConsequenceAction(dialect, action));
        return this.exceptionHandler(exception, exceptionHandler);
    }

    public T exceptionHandler(String eventType, String exception) {
        return this.errorExceptionHandler(eventType, exception, null);
    }

    public T errorExceptionHandler(String signalType, String faultCode, String faultVariable) {
        ActionExceptionHandler exceptionHandler = new ActionExceptionHandler();
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", "");
        action.setMetaData("Action", new SignalProcessInstanceAction(signalType, faultVariable, null, "processInstance"));
        exceptionHandler.setAction(action);
        exceptionHandler.setFaultVariable(faultVariable);
        return this.exceptionHandler(faultCode, exceptionHandler);
    }

    public abstract T variable(String var1, DataType var2);

    public abstract T variable(String var1, DataType var2, Map<String, Object> var3);

    public abstract T variable(String var1, DataType var2, Object var3);

    public abstract T variable(String var1, DataType var2, Object var3, Map<String, Object> var4);

    private <S extends Context> S getScope(String scopeType, Class<S> scopeClass) {
        ContextContainer contextContainer = (ContextContainer)((Object)this.getNodeContainer());
        Context scope = contextContainer.getDefaultContext(scopeType);
        if (scope == null) {
            try {
                scope = (Context)scopeClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                throw new IllegalStateException(ex);
            }
            contextContainer.addContext(scope);
            contextContainer.setDefaultContext(scope);
        }
        return (S)((Context)scopeClass.cast(scope));
    }

    public RuleFlowNodeContainerFactory<T, P> addCompensationContext(String contextId) {
        if (this.getNodeContainer() instanceof ContextContainer) {
            CompensationScope compensationScope = new CompensationScope();
            ContextContainer contextNode = (ContextContainer)((Object)this.getNodeContainer());
            contextNode.addContext(compensationScope);
            contextNode.setDefaultContext(compensationScope);
            compensationScope.setContextContainerId(contextId);
        }
        return this;
    }
}

