/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.impl;

import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.process.core.datatype.impl.type.StringDataType;
import org.jbpm.process.core.datatype.impl.type.UndefinedDataType;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.impl.AssignmentProducer;
import org.jbpm.process.instance.impl.util.TypeTransformer;
import org.jbpm.workflow.instance.NodeInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAssignmentProducer
implements AssignmentProducer {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultAssignmentProducer.class);
    private TypeTransformer typeTransformer;
    private NodeInstance nodeInstance;

    public DefaultAssignmentProducer(NodeInstance nodeInstance) {
        this.nodeInstance = nodeInstance;
        this.typeTransformer = new TypeTransformer(Thread.currentThread().getContextClassLoader());
    }

    @Override
    public void accept(String target, Object value) {
        VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.nodeInstance.resolveContextInstance("VariableScope", target);
        if (variableScopeInstance == null && this.nodeInstance != null) {
            this.nodeInstance.setVariable(target, value);
            return;
        }
        Variable varDef = variableScopeInstance.getVariableScope().findVariable(target);
        DataType dataType = varDef.getType();
        if (value == null || dataType instanceof UndefinedDataType) {
            variableScopeInstance.setVariable(this.nodeInstance, target, value);
            return;
        }
        if (value instanceof String) {
            value = dataType.readValue((String)value);
        }
        if (dataType.verifyDataType(value)) {
            variableScopeInstance.setVariable(this.nodeInstance, target, value);
            return;
        }
        if (value != null && !(value instanceof Throwable)) {
            try {
                if (!dataType.getStringType().endsWith("java.lang.Object") && dataType instanceof ObjectDataType) {
                    value = this.typeTransformer.transform(value, ((ObjectDataType)dataType).getObjectClass());
                } else if (!(dataType instanceof StringDataType) && !(dataType instanceof ObjectDataType)) {
                    value = this.typeTransformer.transform(value, dataType.getStringType());
                }
            }
            catch (Exception e) {
                logger.debug("error trying to transform value {}", value, (Object)e);
            }
        }
        if (value != null && !dataType.verifyDataType(value)) {
            if (dataType instanceof StringDataType) {
                value = value.toString();
            } else {
                throw new IllegalArgumentException("value " + value + " does not match " + dataType.getStringType());
            }
        }
        variableScopeInstance.setVariable(this.nodeInstance, target, value);
    }
}

