/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jbpm.process.instance.KogitoProcessContextImpl;
import org.jbpm.process.instance.impl.AssignmentAction;
import org.jbpm.process.instance.impl.AssignmentProducer;
import org.jbpm.workflow.core.impl.DataAssociation;
import org.jbpm.workflow.core.impl.DefaultAssignmentProducer;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.Assignment;
import org.jbpm.workflow.core.node.Transformation;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.NodeInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeIoHelper {
    protected static final Logger logger = LoggerFactory.getLogger(NodeIoHelper.class);
    private NodeInstanceImpl nodeInstance;

    public NodeIoHelper(NodeInstanceImpl nodeInstance) {
        this.nodeInstance = nodeInstance;
    }

    public void processInputs(Collection<DataAssociation> dataAssociation, Function<String, Object> sourceResolver, Function<String, Object> targetResolver, AssignmentProducer producer) {
        this.processDataAssociations(dataAssociation, sourceResolver, targetResolver, producer);
    }

    public void processOutputs(Collection<DataAssociation> dataAssociation, Function<String, Object> sourceResolver, Function<String, Object> targetResolver, AssignmentProducer producer) {
        this.processDataAssociations(dataAssociation, sourceResolver, targetResolver, producer);
    }

    private void processDataAssociations(Collection<DataAssociation> dataAssociation, Function<String, Object> sourceResolver, Function<String, Object> targetResolver, AssignmentProducer producer) {
        for (DataAssociation mapping : dataAssociation) {
            HashMap<String, Object> sources = new HashMap<String, Object>();
            mapping.getSources().forEach(source -> {
                Object value = sourceResolver.apply(source.getLabel());
                sources.put(source.getLabel(), value);
            });
            this.processDataAssociation(mapping, sources, sourceResolver, targetResolver, producer);
        }
    }

    private void processDataAssociation(DataAssociation mapping, Map<String, Object> dataSet, Function<String, Object> sourceResolver, Function<String, Object> targetResolver, AssignmentProducer producer) {
        try {
            if (mapping.getTransformation() != null) {
                Transformation transformation = mapping.getTransformation();
                Object parameterValue = null;
                if (transformation != null) {
                    parameterValue = transformation.getCompiledExpression().eval(var -> dataSet.get(var));
                }
                if (parameterValue != null) {
                    producer.accept(mapping.getTarget().getLabel(), parameterValue);
                }
            } else if (mapping.getAssignments() == null || mapping.getAssignments().isEmpty()) {
                producer.accept(mapping.getTarget().getLabel(), dataSet.get(mapping.getSources().get(0).getLabel()));
            } else {
                mapping.getAssignments().forEach(a -> this.handleAssignment((Assignment)a, sourceResolver, targetResolver, producer));
            }
        }
        catch (Exception th) {
            logger.debug("there was an error during data association processing", (Throwable)th);
            throw th;
        }
    }

    private void handleAssignment(Assignment assignment, Function<String, Object> sourceResolver, Function<String, Object> targetResolver, AssignmentProducer producer) {
        AssignmentAction action = (AssignmentAction)assignment.getMetaData("Action");
        try {
            KogitoProcessContextImpl context = this.nodeInstance != null ? new KogitoProcessContextImpl((KieRuntime)this.nodeInstance.getProcessInstance().getKnowledgeRuntime()) : new KogitoProcessContextImpl(null);
            context.setNodeInstance((NodeInstance)this.nodeInstance);
            action.execute(sourceResolver, targetResolver, producer);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to execute Assignment", e);
        }
    }

    public static Map<String, Object> processInputs(NodeInstanceImpl nodeInstanceImpl, Function<String, Object> sourceResolver, Function<String, Object> targetResolver) {
        Function<String, Object> varResolverWrapper = varRef -> {
            switch (varRef) {
                case "nodeInstance": {
                    return nodeInstanceImpl;
                }
                case "processInstance": {
                    return nodeInstanceImpl.getProcessInstance();
                }
                case "processInstanceId": {
                    return nodeInstanceImpl.getKogitoProcessInstance().getStringId();
                }
                case "parentProcessInstanceId": {
                    return nodeInstanceImpl.getKogitoProcessInstance().getParentProcessInstanceId();
                }
            }
            return sourceResolver.apply((String)varRef);
        };
        return NodeIoHelper.processInputs(nodeInstanceImpl, ((NodeImpl)nodeInstanceImpl.getNode()).getInAssociations(), varResolverWrapper, targetResolver);
    }

    public static Map<String, Object> processInputs(NodeInstanceImpl nodeInstanceImpl, List<DataAssociation> dataInputAssociation, Function<String, Object> sourceResolver, Function<String, Object> targetResolver) {
        NodeIoHelper ioHelper = new NodeIoHelper(nodeInstanceImpl);
        HashMap<String, Object> inputSet = new HashMap<String, Object>();
        ioHelper.processInputs(dataInputAssociation, sourceResolver, targetResolver, (target, value) -> inputSet.put(target, value));
        return inputSet;
    }

    public static Map<String, Object> processInputs(NodeInstanceImpl nodeInstanceImpl, Function<String, Object> soureResolver) {
        return NodeIoHelper.processInputs(nodeInstanceImpl, soureResolver, key -> null);
    }

    public static void processOutputs(NodeInstanceImpl nodeInstanceImpl, Function<String, Object> sourceResolver, Function<String, Object> targetResolver) {
        NodeIoHelper.processOutputs(nodeInstanceImpl, ((NodeImpl)nodeInstanceImpl.getNode()).getOutAssociations(), sourceResolver, targetResolver);
    }

    public static void processOutputs(NodeInstanceImpl nodeInstanceImpl, List<DataAssociation> dataOutputAssociations, Function<String, Object> sourceResolver, Function<String, Object> targetResolver) {
        NodeIoHelper ioHelper = new NodeIoHelper(nodeInstanceImpl);
        ioHelper.processOutputs(dataOutputAssociations, sourceResolver, targetResolver, new DefaultAssignmentProducer(nodeInstanceImpl));
    }

    public static Map<String, Object> processOutputs(List<DataAssociation> dataOutputAssociations, Function<String, Object> sourceResolver) {
        NodeIoHelper ioHelper = new NodeIoHelper(null);
        HashMap<String, Object> outputSet = new HashMap<String, Object>();
        ioHelper.processOutputs(dataOutputAssociations, sourceResolver, key -> null, (key, value) -> outputSet.put(key, value));
        return outputSet;
    }
}

