/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.core.node;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jbpm.process.instance.impl.ReturnValueEvaluator;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.WorkflowElementIdentifier;
import org.kie.kogito.internal.process.runtime.KogitoProcessContext;

public class DynamicNode
extends CompositeContextNode {
    private static final long serialVersionUID = 510L;
    private String activationCondition;
    private String completionCondition;
    private ReturnValueEvaluator activationPredicate;
    private ReturnValueEvaluator completionPredicate;
    private String language;

    public DynamicNode() {
        this.setAutoComplete(false);
    }

    @Override
    public Node internalGetNode(WorkflowElementIdentifier id) {
        try {
            return this.getNode(id);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public List<Node> getAutoStartNodes() {
        return Arrays.stream(this.getNodes()).filter(n -> n.getIncomingConnections().isEmpty() && "true".equalsIgnoreCase((String)n.getMetaData().get("customAutoStart"))).collect(Collectors.toList());
    }

    public String getActivationCondition() {
        return this.activationCondition;
    }

    public void setActivationCondition(String activationCondition) {
        this.activationCondition = activationCondition;
    }

    public String getCompletionCondition() {
        return this.completionCondition;
    }

    public void setCompletionCondition(String completionCondition) {
        this.completionCondition = completionCondition;
    }

    public DynamicNode setActivationExpression(ReturnValueEvaluator activationPredicate) {
        this.activationPredicate = activationPredicate;
        return this;
    }

    public DynamicNode setCompletionExpression(ReturnValueEvaluator copmletionPredicate) {
        this.completionPredicate = copmletionPredicate;
        return this;
    }

    public boolean canActivate(KogitoProcessContext context) {
        return this.activationPredicate == null || (Boolean)this.activationPredicate.evaluate(context) != false;
    }

    public boolean canComplete(KogitoProcessContext context) {
        return this.isAutoComplete() || this.completionPredicate != null && (Boolean)this.completionPredicate.evaluate(context) != false;
    }

    public boolean hasCompletionCondition() {
        return this.completionPredicate != null || this.completionCondition != null && !this.completionCondition.isEmpty();
    }
}

