/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.jbpm.util.JbpmClassLoaderUtil;
import org.jbpm.workflow.instance.impl.NodeInstanceFactory;
import org.jbpm.workflow.instance.impl.NodeInstanceFactoryProvider;
import org.kie.api.definition.process.Node;
import org.kie.api.runtime.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeInstanceFactoryRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeInstanceFactoryRegistry.class);
    private static final NodeInstanceFactoryRegistry INSTANCE = new NodeInstanceFactoryRegistry();
    private Map<Class<? extends Node>, NodeInstanceFactory> registry = new HashMap<Class<? extends Node>, NodeInstanceFactory>();

    public static NodeInstanceFactoryRegistry getInstance(Environment environment) {
        if (environment != null && environment.get("NodeInstanceFactoryRegistry") != null) {
            return (NodeInstanceFactoryRegistry)environment.get("NodeInstanceFactoryRegistry");
        }
        return INSTANCE;
    }

    protected NodeInstanceFactoryRegistry() {
        this.initRegistry();
    }

    private void initRegistry() {
        ServiceLoader.load(NodeInstanceFactoryProvider.class, JbpmClassLoaderUtil.findClassLoader()).stream().map(ServiceLoader.Provider::get).map(NodeInstanceFactoryProvider::provide).flatMap(Collection::stream).forEach(this::register);
    }

    private void register(NodeInstanceFactory nodeInstanceFactory) {
        LOGGER.debug("registering new node instance factory for {} set by {}", nodeInstanceFactory.forClass(), (Object)nodeInstanceFactory.getClass().getCanonicalName());
        this.registry.put(nodeInstanceFactory.forClass(), nodeInstanceFactory);
    }

    public void register(Class<? extends Node> forClass, NodeInstanceFactory nodeInstanceFactory) {
        LOGGER.debug("override new node instance factory for {} set by {}", forClass, (Object)nodeInstanceFactory.getClass().getCanonicalName());
        this.registry.put(forClass, nodeInstanceFactory);
    }

    public NodeInstanceFactory getProcessNodeInstanceFactory(Node node) {
        for (Class<?> clazz = node.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            NodeInstanceFactory result = this.get(clazz);
            if (result == null) continue;
            return result;
        }
        LOGGER.debug("node instance factory not found for node {}", (Object)node.getClass().getName());
        return null;
    }

    protected NodeInstanceFactory get(Class<?> clazz) {
        return this.registry.get(clazz);
    }
}

