/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.impl.factory;

import java.util.function.Supplier;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.impl.factory.AbstractNodeInstanceFactory;
import org.kie.api.definition.process.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonNodeInstanceFactory
extends AbstractNodeInstanceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingletonNodeInstanceFactory.class);
    private Class<? extends NodeImpl> nodeDefinition;
    private Supplier<NodeInstanceImpl> nodeInstanceSupplier;

    @Override
    public Class<? extends Node> forClass() {
        return this.nodeDefinition;
    }

    public SingletonNodeInstanceFactory(Class<? extends NodeImpl> nodeDefinition, Supplier<NodeInstanceImpl> nodeInstanceSupplier) {
        this.nodeDefinition = nodeDefinition;
        this.nodeInstanceSupplier = nodeInstanceSupplier;
    }

    @Override
    public org.kie.api.runtime.process.NodeInstance getNodeInstance(Node node, WorkflowProcessInstance processInstance, org.kie.api.runtime.process.NodeInstanceContainer nodeInstanceContainer) {
        NodeInstance result = ((NodeInstanceContainer)nodeInstanceContainer).getFirstNodeInstance(node.getId());
        if (result != null) {
            return result;
        }
        LOGGER.debug("creating node {} with identifier {}", (Object)node, (Object)node.getId());
        return this.createInstance(this.nodeInstanceSupplier.get(), node, processInstance, nodeInstanceContainer);
    }
}

