/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.impl;

import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.kogito.Addons;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.event.EventPublisher;
import org.kie.kogito.jobs.JobsService;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.ProcessEventListenerConfig;
import org.kie.kogito.process.ProcessVersionResolver;
import org.kie.kogito.process.WorkItemHandlerConfig;
import org.kie.kogito.process.impl.CachedProcessEventListenerConfig;
import org.kie.kogito.process.impl.DefaultWorkItemHandlerConfig;
import org.kie.kogito.process.impl.MultiWorkItemHandlerConfig;
import org.kie.kogito.services.identity.NoOpIdentityProvider;
import org.kie.kogito.services.signal.DefaultSignalManagerHub;
import org.kie.kogito.services.uow.CollectingUnitOfWorkFactory;
import org.kie.kogito.services.uow.DefaultUnitOfWorkManager;
import org.kie.kogito.signal.SignalManagerHub;
import org.kie.kogito.uow.UnitOfWorkFactory;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.kie.kogito.uow.events.UnitOfWorkEventListener;

public abstract class AbstractProcessConfig
implements ProcessConfig {
    private final WorkItemHandlerConfig workItemHandlerConfig;
    private final SignalManagerHub signalManagerHub = new DefaultSignalManagerHub();
    private final ProcessEventListenerConfig processEventListenerConfig;
    private final UnitOfWorkManager unitOfWorkManager;
    private final JobsService jobsService;
    private final ProcessVersionResolver versionResolver;
    private final IdentityProvider identityProvider;

    protected AbstractProcessConfig(Iterable<WorkItemHandlerConfig> workItemHandlerConfig, Iterable<ProcessEventListenerConfig> processEventListenerConfigs, Iterable<ProcessEventListener> processEventListeners, Iterable<UnitOfWorkManager> unitOfWorkManager, Iterable<JobsService> jobsService, Iterable<EventPublisher> eventPublishers, String kogitoService, Iterable<UnitOfWorkEventListener> unitOfWorkListeners, Iterable<ProcessVersionResolver> versionResolver, Iterable<IdentityProvider> identityProvider) {
        this.workItemHandlerConfig = AbstractProcessConfig.mergeWorkItemHandler(workItemHandlerConfig, DefaultWorkItemHandlerConfig::new);
        this.processEventListenerConfig = AbstractProcessConfig.merge(processEventListenerConfigs, processEventListeners);
        this.unitOfWorkManager = AbstractProcessConfig.orDefault(unitOfWorkManager, () -> new DefaultUnitOfWorkManager((UnitOfWorkFactory)new CollectingUnitOfWorkFactory()));
        this.jobsService = AbstractProcessConfig.orDefault(jobsService, () -> null);
        this.versionResolver = AbstractProcessConfig.orDefault(versionResolver, () -> null);
        this.identityProvider = AbstractProcessConfig.orDefault(identityProvider, NoOpIdentityProvider::new);
        eventPublishers.forEach(publisher -> this.unitOfWorkManager().eventManager().addPublisher(publisher));
        unitOfWorkListeners.forEach(listener -> this.unitOfWorkManager().register(listener));
        this.unitOfWorkManager().eventManager().setService(kogitoService);
    }

    private static WorkItemHandlerConfig mergeWorkItemHandler(Iterable<WorkItemHandlerConfig> workItemHandlerConfigs, Supplier<WorkItemHandlerConfig> supplier) {
        Iterator<WorkItemHandlerConfig> iterator = workItemHandlerConfigs.iterator();
        if (iterator.hasNext()) {
            WorkItemHandlerConfig config = iterator.next();
            return iterator.hasNext() ? new MultiWorkItemHandlerConfig(workItemHandlerConfigs) : config;
        }
        return supplier.get();
    }

    public WorkItemHandlerConfig workItemHandlers() {
        return this.workItemHandlerConfig;
    }

    public ProcessEventListenerConfig processEventListeners() {
        return this.processEventListenerConfig;
    }

    public SignalManagerHub signalManagerHub() {
        return this.signalManagerHub;
    }

    public UnitOfWorkManager unitOfWorkManager() {
        return this.unitOfWorkManager;
    }

    public JobsService jobsService() {
        return this.jobsService;
    }

    public ProcessVersionResolver versionResolver() {
        return this.versionResolver;
    }

    public IdentityProvider identityProvider() {
        return this.identityProvider;
    }

    public Addons addons() {
        return Addons.EMTPY;
    }

    static <T> T orDefault(Iterable<T> instance, Supplier<? extends T> supplier) {
        Iterator<T> iterator = instance.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return supplier.get();
    }

    static ProcessEventListenerConfig merge(Iterable<ProcessEventListenerConfig> processEventListenerConfigs, Iterable<ProcessEventListener> processEventListeners) {
        List l1 = StreamSupport.stream(processEventListenerConfigs.spliterator(), false).collect(Collectors.toList());
        List l2 = StreamSupport.stream(processEventListeners.spliterator(), false).collect(Collectors.toList());
        Stream processEventListenerStream = l1.stream().flatMap(c -> c.listeners().stream());
        Stream eventListenerStream = l2.stream();
        return new CachedProcessEventListenerConfig(Stream.concat(processEventListenerStream, eventListenerStream).collect(Collectors.toList()));
    }
}

