/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.impl;

import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.kie.kogito.process.MutableProcessInstances;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceDuplicatedException;
import org.kie.kogito.process.ProcessInstanceReadMode;

class MapProcessInstances<T>
implements MutableProcessInstances<T> {
    private final ConcurrentHashMap<String, ProcessInstance<T>> instances = new ConcurrentHashMap();

    MapProcessInstances() {
    }

    public Optional<ProcessInstance<T>> findById(String id, ProcessInstanceReadMode mode) {
        return Optional.ofNullable(this.instances.get(id));
    }

    public void create(String id, ProcessInstance<T> instance) {
        ProcessInstance<T> existing;
        if (this.isActive(instance) && (existing = this.instances.putIfAbsent(id, instance)) != null) {
            throw new ProcessInstanceDuplicatedException(id);
        }
    }

    public void update(String id, ProcessInstance<T> instance) {
        if (this.isActive(instance)) {
            this.instances.put(id, instance);
        }
    }

    public void remove(String id) {
        this.instances.remove(id);
    }

    public boolean exists(String id) {
        return this.instances.containsKey(id);
    }

    public Stream<ProcessInstance<T>> stream(ProcessInstanceReadMode mode) {
        return this.instances.values().stream();
    }
}

