/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.event.trace;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.kie.kogito.tracing.event.message.Message;
import org.kie.kogito.tracing.event.trace.TraceEventType;
import org.kie.kogito.tracing.event.trace.TraceResourceId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TraceHeader {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraceHeader.class);
    @JsonProperty(value="type")
    private TraceEventType type;
    @JsonProperty(value="executionId")
    private String executionId;
    @JsonProperty(value="startTimestamp")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Long startTimestamp;
    @JsonProperty(value="endTimestamp")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Long endTimestamp;
    @JsonProperty(value="duration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Long duration;
    @JsonProperty(value="resourceId")
    private TraceResourceId resourceId;
    @JsonProperty(value="messages")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<Message> messages;

    private TraceHeader() {
    }

    public TraceHeader(TraceEventType type, String executionId, Long startTs, Long endTs, Long duration, TraceResourceId resourceId, List<Message> messages) {
        this.checkAndLogInvalidTimestamp(startTs, "startTimestamp", executionId);
        this.checkAndLogInvalidTimestamp(endTs, "endTimestamp", executionId);
        this.checkAndLogInvalidTimestamp(duration, "duration", executionId);
        this.type = type;
        this.executionId = executionId;
        this.startTimestamp = startTs;
        this.endTimestamp = endTs;
        this.duration = duration;
        this.resourceId = resourceId;
        this.messages = messages;
    }

    public TraceEventType getType() {
        return this.type;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public Long getStartTimestamp() {
        return this.startTimestamp;
    }

    public Long getEndTimestamp() {
        return this.endTimestamp;
    }

    public Long getDuration() {
        return this.duration;
    }

    public TraceResourceId getResourceId() {
        return this.resourceId;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    private void checkAndLogInvalidTimestamp(Long timestamp, String property, String executionId) {
        if (timestamp == null || timestamp < 0L) {
            LOGGER.warn(String.format("The TraceHeader timestamp property %s of the execution %s is null or negative: %d", property, executionId, timestamp));
        }
    }
}

