/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.kie.kogito.event.ChannelType;
import org.kie.kogito.event.cloudevents.CloudEventMeta;

public class Topic {
    private String name;
    private ChannelType type;
    private Set<CloudEventMeta> eventsMeta = new HashSet<CloudEventMeta>();

    public Topic() {
    }

    public Topic(String name, ChannelType type) {
        this();
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ChannelType getType() {
        return this.type;
    }

    public void setType(ChannelType type) {
        this.type = type;
    }

    public Collection<CloudEventMeta> getEventsMeta() {
        return Collections.unmodifiableSet(this.eventsMeta);
    }

    public void setEventsMeta(Collection<CloudEventMeta> eventsMeta) {
        this.eventsMeta = new HashSet<CloudEventMeta>(eventsMeta);
    }

    public String toString() {
        return "Topic{name='" + this.name + "', type=" + this.type + ", events=" + this.eventsMeta + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Topic topic = (Topic)o;
        return Objects.equals(this.name, topic.name) && this.type == topic.type && Objects.equals(this.eventsMeta, topic.eventsMeta);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.eventsMeta});
    }
}

