/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.usertask;

import java.net.URI;
import java.util.Date;
import java.util.Objects;

public class UserTaskInstanceAttachmentEventBody {
    public static final int EVENT_TYPE_ADDED = 1;
    public static final int EVENT_TYPE_CHANGE = 2;
    public static final int EVENT_TYPE_DELETED = 3;
    private Date eventDate;
    private String eventUser;
    private String userTaskDefinitionId;
    private String userTaskInstanceId;
    private String userTaskName;
    private String attachmentId;
    private String attachmentName;
    private URI attachmentURI;
    private int eventType;

    public static Builder create() {
        return new Builder(new UserTaskInstanceAttachmentEventBody());
    }

    public Date getEventDate() {
        return this.eventDate;
    }

    public String getEventUser() {
        return this.eventUser;
    }

    public String getUserTaskDefinitionId() {
        return this.userTaskDefinitionId;
    }

    public String getUserTaskInstanceId() {
        return this.userTaskInstanceId;
    }

    public String getUserTaskName() {
        return this.userTaskName;
    }

    public String getAttachmentId() {
        return this.attachmentId;
    }

    public String getAttachmentName() {
        return this.attachmentName;
    }

    public URI getAttachmentURI() {
        return this.attachmentURI;
    }

    public int getEventType() {
        return this.eventType;
    }

    public String toString() {
        return "UserTaskInstanceAttachmentEventBody [eventDate=" + this.eventDate + ", eventUser=" + this.eventUser + ", userTaskDefinitionId=" + this.userTaskDefinitionId + ", userTaskInstanceId=" + this.userTaskInstanceId + ", userTaskName=" + this.userTaskName + ", attachmentId=" + this.attachmentId + ", attachmentName=" + this.attachmentName + ", attachmentURI=" + this.attachmentURI + ", eventType=" + this.eventType + "]";
    }

    public int hashCode() {
        return Objects.hash(this.attachmentId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserTaskInstanceAttachmentEventBody other = (UserTaskInstanceAttachmentEventBody)obj;
        return Objects.equals(this.attachmentId, other.attachmentId);
    }

    public static class Builder {
        private UserTaskInstanceAttachmentEventBody instance;

        private Builder(UserTaskInstanceAttachmentEventBody instance) {
            this.instance = instance;
        }

        public Builder eventDate(Date eventDate) {
            this.instance.eventDate = eventDate;
            return this;
        }

        public Builder eventUser(String userId) {
            this.instance.eventUser = userId;
            return this;
        }

        public Builder userTaskDefinitionId(String userTaskDefinitionId) {
            this.instance.userTaskDefinitionId = userTaskDefinitionId;
            return this;
        }

        public Builder userTaskInstanceId(String userTaskInstanceId) {
            this.instance.userTaskInstanceId = userTaskInstanceId;
            return this;
        }

        public Builder userTaskName(String userTaskName) {
            this.instance.userTaskName = userTaskName;
            return this;
        }

        public Builder attachmentId(String attachmentId) {
            this.instance.attachmentId = attachmentId;
            return this;
        }

        public Builder attachmentName(String attachmentName) {
            this.instance.attachmentName = attachmentName;
            return this;
        }

        public Builder attachmentURI(URI attachmentURI) {
            this.instance.attachmentURI = attachmentURI;
            return this;
        }

        public Builder eventType(int eventType) {
            this.instance.eventType = eventType;
            return this;
        }

        public UserTaskInstanceAttachmentEventBody build() {
            return this.instance;
        }
    }
}

