/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.compilationmanager.core.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.kie.efesto.common.api.io.IndexFile;
import org.kie.efesto.common.api.model.GeneratedClassResource;
import org.kie.efesto.common.api.model.GeneratedExecutableResource;
import org.kie.efesto.common.api.model.GeneratedRedirectResource;
import org.kie.efesto.common.api.model.GeneratedResource;
import org.kie.efesto.common.api.model.GeneratedResources;
import org.kie.efesto.common.api.utils.MemoryFileUtils;
import org.kie.efesto.common.core.utils.JSONUtils;
import org.kie.efesto.compilationmanager.api.exceptions.KieCompilerServiceException;
import org.kie.efesto.compilationmanager.api.model.EfestoCallableOutput;
import org.kie.efesto.compilationmanager.api.model.EfestoCallableOutputClassesContainer;
import org.kie.efesto.compilationmanager.api.model.EfestoClassesContainer;
import org.kie.efesto.compilationmanager.api.model.EfestoCompilationContext;
import org.kie.efesto.compilationmanager.api.model.EfestoCompilationOutput;
import org.kie.efesto.compilationmanager.api.model.EfestoRedirectOutput;
import org.kie.efesto.compilationmanager.api.model.EfestoResource;
import org.kie.efesto.compilationmanager.api.service.KieCompilerService;
import org.kie.efesto.compilationmanager.api.utils.SPIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompilationManagerUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)CompilationManagerUtils.class.getName());
    private static final String DEFAULT_INDEXFILE_DIRECTORY = "./target/classes";

    private CompilationManagerUtils() {
    }

    public static void processResourceWithContext(EfestoResource toProcess, EfestoCompilationContext context) {
        Optional retrieved = SPIUtils.getKieCompilerService((EfestoResource)toProcess, (boolean)false);
        if (retrieved.isEmpty()) {
            logger.warn("Cannot find KieCompilerService for {}, trying in context classloader", toProcess.getClass());
            retrieved = SPIUtils.getKieCompilerServiceFromEfestoCompilationContext((EfestoResource)toProcess, (EfestoCompilationContext)context);
        }
        if (retrieved.isEmpty()) {
            logger.warn("Cannot find KieCompilerService for {}", toProcess.getClass());
            return;
        }
        CompilationManagerUtils.processResources((KieCompilerService)retrieved.get(), toProcess, context);
    }

    public static Optional<IndexFile> getExistingIndexFile(String model) {
        String parentPath = System.getProperty("indexfile.directory", DEFAULT_INDEXFILE_DIRECTORY);
        IndexFile toReturn = new IndexFile(parentPath, model);
        return MemoryFileUtils.getFileFromFileNameOrFilePath((String)toReturn.getName(), (String)toReturn.getAbsolutePath()).map(IndexFile::new);
    }

    static void processResources(KieCompilerService kieCompilerService, EfestoResource toProcess, EfestoCompilationContext context) {
        List efestoCompilationOutputList = kieCompilerService.processResource(toProcess, context);
        for (EfestoCompilationOutput compilationOutput : efestoCompilationOutputList) {
            if (compilationOutput instanceof EfestoCallableOutput) {
                CompilationManagerUtils.populateContext(context, (EfestoCallableOutput)compilationOutput);
                if (!(compilationOutput instanceof EfestoCallableOutputClassesContainer)) continue;
                EfestoCallableOutputClassesContainer classesContainer = (EfestoCallableOutputClassesContainer)compilationOutput;
                context.loadClasses(classesContainer.getCompiledClassesMap());
                context.addGeneratedClasses(classesContainer.getModelLocalUriId().asModelLocalUriId(), classesContainer.getCompiledClassesMap());
                continue;
            }
            if (!(compilationOutput instanceof EfestoResource)) continue;
            CompilationManagerUtils.processResourceWithContext((EfestoResource)compilationOutput, context);
        }
    }

    static IndexFile getIndexFile(EfestoCallableOutput compilationOutput) {
        String parentPath = System.getProperty("indexfile.directory", DEFAULT_INDEXFILE_DIRECTORY);
        IndexFile toReturn = new IndexFile(parentPath, compilationOutput.getModelLocalUriId().model());
        return CompilationManagerUtils.getExistingIndexFile(compilationOutput.getModelLocalUriId().model()).orElseGet(() -> CompilationManagerUtils.createIndexFile(toReturn));
    }

    private static IndexFile createIndexFile(IndexFile toCreate) {
        try {
            logger.debug("Writing file {} {}", (Object)toCreate.getAbsolutePath(), (Object)toCreate.getName());
            if (!toCreate.createNewFile()) {
                throw new KieCompilerServiceException("Failed to create (" + toCreate.getAbsolutePath() + ") " + toCreate.getName());
            }
        }
        catch (IOException e) {
            String errorMessage = e.getMessage() != null && !e.getMessage().isEmpty() ? e.getMessage() : e.getClass().getName();
            logger.error("Failed to create {} {} due to {}", new Object[]{toCreate.getAbsolutePath(), toCreate.getName(), errorMessage});
            throw new KieCompilerServiceException("Failed to create (" + toCreate.getAbsolutePath() + ") " + toCreate.getName(), (Throwable)e);
        }
        return toCreate;
    }

    static void populateIndexFile(IndexFile toPopulate, EfestoCompilationOutput compilationOutput) {
        try {
            GeneratedResources generatedResources = JSONUtils.getGeneratedResourcesObject((IndexFile)toPopulate);
            CompilationManagerUtils.populateGeneratedResources(generatedResources, compilationOutput);
            JSONUtils.writeGeneratedResourcesObject((GeneratedResources)generatedResources, (IndexFile)toPopulate);
        }
        catch (Exception e) {
            throw new KieCompilerServiceException((Throwable)e);
        }
    }

    static void populateContext(EfestoCompilationContext context, EfestoCallableOutput compilationOutput) {
        try {
            String model = compilationOutput.getModelLocalUriId().model();
            GeneratedResources generatedResources = (GeneratedResources)context.getGeneratedResourcesMap().computeIfAbsent(model, key -> new GeneratedResources());
            CompilationManagerUtils.populateGeneratedResources(generatedResources, (EfestoCompilationOutput)compilationOutput);
        }
        catch (Exception e) {
            throw new KieCompilerServiceException((Throwable)e);
        }
    }

    static void populateGeneratedResources(GeneratedResources toPopulate, EfestoCompilationOutput compilationOutput) {
        toPopulate.add((Object)CompilationManagerUtils.getGeneratedResource(compilationOutput));
        if (compilationOutput instanceof EfestoClassesContainer) {
            toPopulate.addAll(CompilationManagerUtils.getGeneratedResources((EfestoClassesContainer)compilationOutput));
        }
    }

    static GeneratedResource getGeneratedResource(EfestoCompilationOutput compilationOutput) {
        if (compilationOutput instanceof EfestoRedirectOutput) {
            return new GeneratedRedirectResource(((EfestoRedirectOutput)compilationOutput).getModelLocalUriId(), ((EfestoRedirectOutput)compilationOutput).getTargetEngine());
        }
        if (compilationOutput instanceof EfestoCallableOutput) {
            return new GeneratedExecutableResource(((EfestoCallableOutput)compilationOutput).getModelLocalUriId(), ((EfestoCallableOutput)compilationOutput).getFullClassNames());
        }
        throw new KieCompilerServiceException("Unmanaged type " + compilationOutput.getClass().getName());
    }

    static List<GeneratedResource> getGeneratedResources(EfestoClassesContainer finalOutput) {
        ArrayList<GeneratedResource> toReturn = new ArrayList<GeneratedResource>();
        for (String key : finalOutput.getCompiledClassesMap().keySet()) {
            toReturn.add((GeneratedResource)CompilationManagerUtils.getGeneratedClassResource(key));
        }
        return toReturn;
    }

    static GeneratedClassResource getGeneratedClassResource(String fullClassName) {
        return new GeneratedClassResource(fullClassName);
    }
}

