/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.flow.migration;

import com.google.common.base.Functions;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jbpm.flow.migration.MigrationPlanProvider;
import org.jbpm.flow.migration.model.MigrationPlan;
import org.jbpm.flow.migration.model.ProcessDefinitionMigrationPlan;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoWorkflowProcessInstance;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.Processes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationPlanService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationPlanService.class);
    private MigrationPlanProvider migrationPlanProvider;
    private Map<ProcessDefinitionMigrationPlan, MigrationPlan> migrations;

    public MigrationPlanService() {
        this(MigrationPlanProvider.newMigrationPlanProviderBuilder().withEnvironmentDefaults().build());
    }

    public MigrationPlanService(MigrationPlanProvider migrationPlanProvider) {
        this.migrationPlanProvider = migrationPlanProvider;
        this.migrations = new HashMap<ProcessDefinitionMigrationPlan, MigrationPlan>();
        this.migrations.putAll(this.migrationPlanProvider.findMigrationPlans().stream().collect(Collectors.toMap(MigrationPlan::getSource, Functions.identity())));
    }

    public void migrateProcessElement(Processes processes, KogitoWorkflowProcessInstance processInstance) {
        MigrationPlan plan = this.getMigrationPlan(processes, processInstance);
        if (plan != null) {
            LOGGER.info("Process instance {} will be migrated from {} to {} with plan {}", new Object[]{processInstance.getStringId(), plan.getProcessMigrationPlan().getSourceProcessDefinition(), plan.getProcessMigrationPlan().getTargetProcessDefinition(), plan.getName()});
            RuleFlowProcessInstance ruleFlowProcessInstance = (RuleFlowProcessInstance)processInstance;
            ruleFlowProcessInstance.setProcessId(plan.getProcessMigrationPlan().getTargetProcessDefinition().getProcessId());
            ruleFlowProcessInstance.setProcessVersion(plan.getProcessMigrationPlan().getTargetProcessDefinition().getProcessVersion());
        } else {
            LOGGER.debug("Process instance {} won't be migrated", (Object)processInstance);
        }
    }

    public void migrateNodeElement(Processes processes, KogitoNodeInstance nodeInstance) {
        KogitoWorkflowProcessInstance pi = (KogitoWorkflowProcessInstance)nodeInstance.getProcessInstance();
        MigrationPlan plan = this.getMigrationPlan(processes, pi);
        if (plan == null) {
            return;
        }
        LOGGER.debug("Migration node element {}", (Object)nodeInstance);
        NodeInstanceImpl impl = (NodeInstanceImpl)nodeInstance;
        impl.setNodeId(plan.getProcessMigrationPlan().getNodeMigratedFor(nodeInstance));
    }

    private MigrationPlan getMigrationPlan(Processes processes, KogitoWorkflowProcessInstance processInstance) {
        RuleFlowProcessInstance pi;
        ProcessDefinitionMigrationPlan processStateDefinition;
        String currentVersion;
        String currentProcessId = processInstance.getProcess().getId();
        ProcessDefinitionMigrationPlan currentProcessDefinition = new ProcessDefinitionMigrationPlan(currentProcessId, currentVersion = processInstance.getProcess().getVersion());
        if (currentProcessDefinition.equals(processStateDefinition = new ProcessDefinitionMigrationPlan((pi = (RuleFlowProcessInstance)processInstance).getProcessId(), pi.getProcessVersion()))) {
            return null;
        }
        MigrationPlan plan = this.migrations.get(processStateDefinition);
        if (plan == null) {
            LOGGER.debug("No migration plan defined for process state {}.", (Object)processStateDefinition);
            return null;
        }
        ProcessDefinitionMigrationPlan targetDefinition = plan.getProcessMigrationPlan().getTargetProcessDefinition();
        if (!targetDefinition.equals(currentProcessDefinition)) {
            LOGGER.debug("Migration plan found for {} does not match target definition {}, Found plan to {}.", new Object[]{processStateDefinition, currentProcessDefinition, targetDefinition});
            return null;
        }
        if (!processes.processIds().contains(targetDefinition.getProcessId())) {
            LOGGER.debug("No migration target defintion deployed in this container {} for migrating {}.", (Object)targetDefinition, (Object)processStateDefinition);
            return null;
        }
        Process process = processes.processById(targetDefinition.getProcessId());
        ProcessDefinitionMigrationPlan targetDeployed = new ProcessDefinitionMigrationPlan(process.id(), process.version());
        return targetDeployed.equals(targetDefinition) ? plan : null;
    }

    public boolean isEqualVersion(Processes processes, KogitoWorkflowProcessInstance processInstance) {
        String currentProcessId = processInstance.getProcess().getId();
        String currentVersion = processInstance.getProcess().getVersion();
        ProcessDefinitionMigrationPlan currentProcessDefinition = new ProcessDefinitionMigrationPlan(currentProcessId, currentVersion);
        RuleFlowProcessInstance pi = (RuleFlowProcessInstance)processInstance;
        ProcessDefinitionMigrationPlan processStateDefinition = new ProcessDefinitionMigrationPlan(pi.getProcessId(), pi.getProcessVersion());
        return currentProcessDefinition.equals(processStateDefinition);
    }

    public boolean hasMigrationPlan(Processes processes, KogitoWorkflowProcessInstance processInstance) {
        return this.getMigrationPlan(processes, processInstance) != null;
    }
}

