/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.flow.migration.impl;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.io.InputStream;
import org.jbpm.flow.migration.MigrationPlanFileFormatException;
import org.jbpm.flow.migration.MigrationPlanFileReader;
import org.jbpm.flow.migration.impl.JsonWorkflowElementIdentifierDeserializer;
import org.jbpm.flow.migration.model.MigrationPlan;
import org.kie.api.definition.process.WorkflowElementIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMigrationPlanFileReader
implements MigrationPlanFileReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonMigrationPlanFileReader.class);
    public static final String MIGRATION_PLAN_FILE_EXTENSION = "mpf";
    private ObjectMapper objectMapper = new ObjectMapper();

    public JsonMigrationPlanFileReader() {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addDeserializer(WorkflowElementIdentifier.class, (JsonDeserializer)new JsonWorkflowElementIdentifierDeserializer());
        this.objectMapper.registerModule((Module)simpleModule);
    }

    @Override
    public MigrationPlan read(InputStream is) throws IOException {
        try {
            MigrationPlan migrationPlan = (MigrationPlan)this.objectMapper.readValue(is, MigrationPlan.class);
            LOGGER.trace("Read migration plan {} in json format", (Object)migrationPlan);
            return migrationPlan;
        }
        catch (IOException e) {
            throw new MigrationPlanFileFormatException("Error during marshalling", e);
        }
    }

    @Override
    public String getFileExtension() {
        return ".mpf";
    }
}

