/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.flow.migration.model;

import java.util.List;
import java.util.Objects;
import org.jbpm.flow.migration.model.NodeInstanceMigrationPlan;
import org.jbpm.flow.migration.model.ProcessDefinitionMigrationPlan;
import org.kie.api.definition.process.WorkflowElementIdentifier;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;

public class ProcessInstanceMigrationPlan {
    private ProcessDefinitionMigrationPlan sourceProcessDefinition;
    private ProcessDefinitionMigrationPlan targetProcessDefinition;
    private List<NodeInstanceMigrationPlan> nodeInstanceMigrationPlan;

    public List<NodeInstanceMigrationPlan> getNodeInstanceMigrationPlan() {
        return this.nodeInstanceMigrationPlan;
    }

    public void setNodeInstanceMigrationPlan(List<NodeInstanceMigrationPlan> nodeInstanceMigrationPlan) {
        this.nodeInstanceMigrationPlan = nodeInstanceMigrationPlan;
    }

    public WorkflowElementIdentifier getNodeMigratedFor(KogitoNodeInstance instance) {
        List<NodeInstanceMigrationPlan> plans = this.nodeInstanceMigrationPlan.stream().filter(e -> e.getSourceNodeId().equals((Object)instance.getNodeId())).toList();
        if (plans.isEmpty()) {
            return instance.getNodeId();
        }
        if (plans.size() > 1) {
            throw new IllegalArgumentException("more than one node migration plan found for " + instance);
        }
        return plans.get(0).getTargetNodeId();
    }

    public ProcessDefinitionMigrationPlan getSourceProcessDefinition() {
        return this.sourceProcessDefinition;
    }

    public void setSourceProcessDefinition(ProcessDefinitionMigrationPlan source) {
        this.sourceProcessDefinition = source;
    }

    public ProcessDefinitionMigrationPlan getTargetProcessDefinition() {
        return this.targetProcessDefinition;
    }

    public void setTargetProcessDefinition(ProcessDefinitionMigrationPlan target) {
        this.targetProcessDefinition = target;
    }

    public String toString() {
        return "ProcessMigrationPlan [source=" + this.sourceProcessDefinition + ", target=" + this.targetProcessDefinition + "]";
    }

    public int hashCode() {
        return Objects.hash(this.nodeInstanceMigrationPlan, this.sourceProcessDefinition, this.targetProcessDefinition);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessInstanceMigrationPlan other = (ProcessInstanceMigrationPlan)obj;
        return Objects.equals(this.nodeInstanceMigrationPlan, other.nodeInstanceMigrationPlan) && Objects.equals(this.sourceProcessDefinition, other.sourceProcessDefinition) && Objects.equals(this.targetProcessDefinition, other.targetProcessDefinition);
    }
}

