/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.handler;

import java.util.HashMap;
import java.util.Map;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemManager;
import org.kie.kogito.process.workitem.Policy;

public class ReceiveTaskHandler
implements KogitoWorkItemHandler {
    private Map<String, String> waiting = new HashMap<String, String>();
    private KogitoProcessRuntime kruntime;

    public ReceiveTaskHandler(KogitoProcessRuntime kruntime) {
        this.kruntime = kruntime;
    }

    public void setKnowledgeRuntime(KogitoProcessRuntime kruntime) {
        this.kruntime = kruntime;
    }

    public void executeWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
        String messageId = (String)workItem.getParameter("MessageId");
        this.waiting.put(messageId, workItem.getStringId());
    }

    public void messageReceived(String messageId, Object message) {
        String workItemId = this.waiting.get(messageId);
        if (workItemId == null) {
            return;
        }
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("Message", message);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItemId, results, new Policy[0]);
    }

    public void abortWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
        String messageId = (String)workItem.getParameter("MessageId");
        this.waiting.remove(messageId);
    }
}

