/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import org.jbpm.bpmn2.core.Association;
import org.jbpm.bpmn2.core.Definitions;
import org.jbpm.bpmn2.core.Error;
import org.jbpm.bpmn2.core.ItemDefinition;
import org.jbpm.bpmn2.core.Lane;
import org.jbpm.bpmn2.core.SequenceFlow;
import org.jbpm.bpmn2.core.Signal;
import org.jbpm.bpmn2.xml.ProcessParsingValidationException;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.compiler.xml.Handler;
import org.jbpm.compiler.xml.Parser;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.compiler.xml.compiler.XmlDumper;
import org.jbpm.compiler.xml.core.BaseAbstractHandler;
import org.jbpm.compiler.xml.core.ExtensibleXmlParser;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.core.datatype.DataTypeResolver;
import org.jbpm.process.instance.impl.MVELInterpretedReturnValueEvaluator;
import org.jbpm.process.instance.impl.ReturnValueEvaluator;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.ruleflow.core.WorkflowElementIdentifierFactory;
import org.jbpm.util.PatternConstants;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.impl.DataAssociation;
import org.jbpm.workflow.core.impl.DataDefinition;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.impl.ExtendedNodeImpl;
import org.jbpm.workflow.core.impl.IOSpecification;
import org.jbpm.workflow.core.impl.MultiInstanceSpecification;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.Assignment;
import org.jbpm.workflow.core.node.CatchLinkNode;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.FaultNode;
import org.jbpm.workflow.core.node.ForEachNode;
import org.jbpm.workflow.core.node.StateNode;
import org.jbpm.workflow.core.node.TimerNode;
import org.jbpm.workflow.core.node.Transformation;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractNodeHandler
extends BaseAbstractHandler
implements Handler {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractNodeHandler.class);
    static final String PROCESS_INSTANCE_SIGNAL_EVENT = "kcontext.getProcessInstance().signalEvent(";
    static final String RUNTIME_SIGNAL_EVENT = "kcontext.getKogitoProcessRuntime().signalEvent(";
    public static final String INPUT_TYPES = "BPMN.InputTypes";
    public static final String OUTPUT_TYPES = "BPMN.OutputTypes";
    protected static final String EOL = System.getProperty("line.separator");
    private static final String SIGNAL_NAMES = "signalNames";

    public AbstractNodeHandler() {
        this.initValidParents();
        this.initValidPeers();
        this.allowNesting = true;
    }

    protected void initValidParents() {
        this.validParents = new HashSet();
        this.validParents.add(org.jbpm.workflow.core.NodeContainer.class);
    }

    protected void initValidPeers() {
        this.validPeers = new HashSet();
        this.validPeers.add(null);
        this.validPeers.add(Lane.class);
        this.validPeers.add(Variable.class);
        this.validPeers.add(org.jbpm.workflow.core.Node.class);
        this.validPeers.add(SequenceFlow.class);
        this.validPeers.add(Lane.class);
        this.validPeers.add(Association.class);
    }

    public Object start(String uri, String localName, Attributes attrs, Parser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        String id = attrs.getValue("id");
        String name = attrs.getValue("name");
        org.jbpm.workflow.core.Node node = this.createNode(attrs);
        node.setId(WorkflowElementIdentifierFactory.fromExternalFormat((String)id));
        node.setName(name);
        node.setMetaData(INPUT_TYPES, new HashMap());
        node.setMetaData(OUTPUT_TYPES, new HashMap());
        return node;
    }

    protected abstract org.jbpm.workflow.core.Node createNode(Attributes var1);

    public Object end(String uri, String localName, Parser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        org.jbpm.workflow.core.Node node = (org.jbpm.workflow.core.Node)parser.getCurrent();
        node = this.handleNode(node, element, uri, localName, parser);
        org.jbpm.workflow.core.NodeContainer nodeContainer = (org.jbpm.workflow.core.NodeContainer)parser.getParent();
        nodeContainer.addNode((Node)node);
        ((ProcessBuildData)parser.getData()).addNode(node);
        return node;
    }

    protected org.jbpm.workflow.core.Node handleNode(org.jbpm.workflow.core.Node node, Element element, String uri, String localName, Parser parser) throws SAXException {
        String height;
        String width;
        String y;
        String x = element.getAttribute("x");
        if (x != null && x.length() != 0) {
            try {
                node.setMetaData("x", (Object)Integer.parseInt(x));
            }
            catch (NumberFormatException exc) {
                throw new SAXParseException("<" + localName + "> requires an Integer 'x' attribute", parser.getLocator());
            }
        }
        if ((y = element.getAttribute("y")) != null && y.length() != 0) {
            try {
                node.setMetaData("y", (Object)new Integer(y));
            }
            catch (NumberFormatException exc) {
                throw new SAXParseException("<" + localName + "> requires an Integer 'y' attribute", parser.getLocator());
            }
        }
        if ((width = element.getAttribute("width")) != null && width.length() != 0) {
            try {
                node.setMetaData("width", (Object)new Integer(width));
            }
            catch (NumberFormatException exc) {
                throw new SAXParseException("<" + localName + "> requires an Integer 'width' attribute", parser.getLocator());
            }
        }
        if ((height = element.getAttribute("height")) != null && height.length() != 0) {
            try {
                node.setMetaData("height", (Object)new Integer(height));
            }
            catch (NumberFormatException exc) {
                throw new SAXParseException("<" + localName + "> requires an Integer 'height' attribute", parser.getLocator());
            }
        }
        return node;
    }

    public abstract void writeNode(org.jbpm.workflow.core.Node var1, StringBuilder var2, int var3);

    protected void writeNode(String name, org.jbpm.workflow.core.Node node, StringBuilder xmlDump, int metaDataType) {
        xmlDump.append("    <" + name + " ");
        xmlDump.append("id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((Node)node) + "\" ");
        if (node.getName() != null) {
            xmlDump.append("name=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(node.getName()) + "\" ");
        }
        if (metaDataType == 1) {
            Integer x = (Integer)node.getMetaData().get("x");
            Integer y = (Integer)node.getMetaData().get("y");
            Integer width = (Integer)node.getMetaData().get("width");
            Integer height = (Integer)node.getMetaData().get("height");
            if (x != null && x != 0) {
                xmlDump.append("g:x=\"" + x + "\" ");
            }
            if (y != null && y != 0) {
                xmlDump.append("g:y=\"" + y + "\" ");
            }
            if (width != null && width != -1) {
                xmlDump.append("g:width=\"" + width + "\" ");
            }
            if (height != null && height != -1) {
                xmlDump.append("g:height=\"" + height + "\" ");
            }
        }
    }

    protected void endNode(StringBuilder xmlDump) {
        xmlDump.append("/>" + EOL);
    }

    protected void endNode(String name, StringBuilder xmlDump) {
        xmlDump.append("    </" + name + ">" + EOL);
    }

    protected void handleScript(ExtendedNodeImpl node, Element element, String type) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element xmlNode;
            String nodeName;
            if (!(nodeList.item(i) instanceof Element) || !(nodeName = (xmlNode = (Element)nodeList.item(i)).getNodeName()).equals("extensionElements")) continue;
            NodeList subNodeList = xmlNode.getChildNodes();
            for (int j = 0; j < subNodeList.getLength(); ++j) {
                org.w3c.dom.Node subXmlNode = subNodeList.item(j);
                if (!subXmlNode.getNodeName().contains(type + "-script")) continue;
                ArrayList<DroolsAction> actions = node.getActions(type);
                if (actions == null) {
                    actions = new ArrayList<DroolsAction>();
                    node.setActions(type, actions);
                }
                DroolsAction action = AbstractNodeHandler.extractScript((Element)subXmlNode);
                actions.add(action);
            }
        }
    }

    public static DroolsAction extractScript(Element xmlNode) {
        String dialect = "mvel";
        if ("http://www.java.com/java".equals(xmlNode.getAttribute("scriptFormat"))) {
            dialect = "java";
        }
        NodeList subNodeList = xmlNode.getChildNodes();
        for (int j = 0; j < subNodeList.getLength(); ++j) {
            Element subXmlNode;
            if (!(subNodeList.item(j) instanceof Element) || !"script".equals((subXmlNode = (Element)subNodeList.item(j)).getNodeName())) continue;
            String consequence = subXmlNode.getTextContent();
            return new DroolsConsequenceAction(dialect, consequence);
        }
        return new DroolsConsequenceAction("mvel", "");
    }

    protected void writeMetaData(org.jbpm.workflow.core.Node node, StringBuilder xmlDump) {
        XmlBPMNProcessDumper.writeMetaData(this.getMetaData(node), xmlDump);
    }

    protected Map<String, Object> getMetaData(org.jbpm.workflow.core.Node node) {
        return XmlBPMNProcessDumper.getMetaData(node.getMetaData());
    }

    protected void writeExtensionElements(org.jbpm.workflow.core.Node node, StringBuilder xmlDump) {
        if (this.containsExtensionElements(node)) {
            xmlDump.append("      <extensionElements>" + EOL);
            if (node instanceof ExtendedNodeImpl) {
                this.writeScripts("onEntry", ((ExtendedNodeImpl)node).getActions("onEntry"), xmlDump);
                this.writeScripts("onExit", ((ExtendedNodeImpl)node).getActions("onExit"), xmlDump);
            }
            this.writeMetaData(node, xmlDump);
            xmlDump.append("      </extensionElements>" + EOL);
        }
    }

    protected boolean containsExtensionElements(org.jbpm.workflow.core.Node node) {
        if (!this.getMetaData(node).isEmpty()) {
            return true;
        }
        return node instanceof ExtendedNodeImpl && ((ExtendedNodeImpl)node).containsActions();
    }

    protected void writeScripts(String type, List<DroolsAction> actions, StringBuilder xmlDump) {
        if (!actions.isEmpty()) {
            for (DroolsAction action : actions) {
                AbstractNodeHandler.writeScript(action, type, xmlDump);
            }
        }
    }

    public static void writeScript(DroolsAction action, String type, StringBuilder xmlDump) {
        if (action instanceof DroolsConsequenceAction) {
            String consequence;
            String dialect;
            DroolsConsequenceAction consequenceAction = (DroolsConsequenceAction)action;
            xmlDump.append("        <tns:" + type + "-script");
            String name = consequenceAction.getName();
            if (name != null) {
                xmlDump.append(" name=\"" + name + "\"");
            }
            if ("java".equals(dialect = consequenceAction.getDialect())) {
                xmlDump.append(" scriptFormat=\"http://www.java.com/java\"");
            }
            if ((consequence = consequenceAction.getConsequence()) != null) {
                xmlDump.append(">" + EOL + "          <tns:script>" + XmlDumper.replaceIllegalChars((String)consequence.trim()) + "</tns:script>" + EOL);
                xmlDump.append("        </tns:" + type + "-script>" + EOL);
            } else {
                xmlDump.append("/>" + EOL);
            }
        } else {
            throw new ProcessParsingValidationException("Unknown action " + action);
        }
    }

    protected void setCatchVariable(IOSpecification ioSpecification, org.jbpm.workflow.core.Node node) {
        NodeImpl nodeImpl = (NodeImpl)node;
        nodeImpl.setIoSpecification(ioSpecification);
        if (node instanceof EventNode) {
            EventNode eventNode = (EventNode)node;
            this.findSourceMappingVar(ioSpecification.getDataOutputAssociation()).ifPresent(var -> eventNode.setInputVariableName(var.getLabel()));
            this.findTargetMappingVar(ioSpecification.getDataOutputAssociation()).ifPresent(var -> {
                eventNode.getMetaData().put("MappingVariable", var.getLabel());
                eventNode.setVariableName(var.getLabel());
            });
        } else if (node instanceof TimerNode || node instanceof StateNode || node instanceof CatchLinkNode) {
            this.findTargetMappingVar(ioSpecification.getDataOutputAssociation()).ifPresent(data -> nodeImpl.getMetaData().put("MappingVariable", data.getLabel()));
        }
    }

    protected void setThrowVariable(IOSpecification ioSpecification, org.jbpm.workflow.core.Node node) {
        ((NodeImpl)node).setIoSpecification(ioSpecification);
        if (node instanceof ActionNode || node instanceof FaultNode || node instanceof EndNode) {
            NodeImpl mapping = (NodeImpl)node;
            this.findSourceMappingVar(ioSpecification.getDataInputAssociation()).ifPresent(data -> {
                if (!data.hasExpression()) {
                    mapping.getMetaData().put("MappingVariable", data.getLabel());
                    mapping.getMetaData().put("Variable", data.getLabel());
                } else {
                    mapping.getMetaData().put("Variable", data.getExpression());
                }
            });
            this.findTargetMappingVar(ioSpecification.getDataInputAssociation()).ifPresent(data -> mapping.getMetaData().put("MappingVariableInput", data.getLabel()));
        }
    }

    protected Optional<DataDefinition> findTargetMappingVar(List<DataAssociation> outputs) {
        if (outputs.isEmpty()) {
            return Optional.empty();
        }
        if (outputs.get(0).getTarget() != null) {
            return Optional.of(outputs.get(0).getTarget());
        }
        return Optional.empty();
    }

    protected Optional<DataDefinition> findSourceMappingVar(List<DataAssociation> inputs) {
        if (inputs.isEmpty()) {
            return Optional.empty();
        }
        if (inputs.get(0).getAssignments().isEmpty()) {
            return Optional.of((DataDefinition)inputs.get(0).getSources().get(0));
        }
        return Optional.of(((Assignment)inputs.get(0).getAssignments().get(0)).getFrom());
    }

    protected DataDefinition getVariableDataSpec(Parser parser, String propertyIdRef) {
        RuleFlowProcess process = (RuleFlowProcess)((ProcessBuildData)parser.getData()).getMetaData("BPMN.Process");
        Optional<Variable> var = process.getVariableScope().getVariables().stream().filter(e -> e.getId().equals(propertyIdRef)).findAny();
        if (var.isEmpty()) {
            return null;
        }
        Variable variable = var.get();
        return new DataDefinition(variable.getId(), variable.getName(), variable);
    }

    protected ItemDefinition getStructureRef(Parser parser, String id) {
        ProcessBuildData buildData = (ProcessBuildData)parser.getData();
        Map itemDefinitions = (Map)buildData.getMetaData("ItemDefinitions");
        return (ItemDefinition)itemDefinitions.get(id);
    }

    protected IOSpecification readCatchSpecification(Parser parser, Element element) {
        IOSpecification ioSpec = new IOSpecification();
        ioSpec.getDataOutputs().addAll(this.readDataOutput(parser, element));
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"dataOutputAssociation".equals(nodeName)) continue;
            this.readDataAssociation((Element)xmlNode, id -> (DataDefinition)ioSpec.getDataOutput().get(id), id -> this.getVariableDataSpec(parser, (String)id)).ifPresent(e -> {
                e.setType(DataAssociation.DataAssociationType.OUTPUT);
                ioSpec.getDataOutputAssociation().add(e);
            });
        }
        return ioSpec;
    }

    protected IOSpecification readThrowSpecification(Parser parser, Element element) {
        IOSpecification ioSpec = new IOSpecification();
        ioSpec.getDataInputs().addAll(this.readDataInput(parser, element));
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"dataInputAssociation".equals(nodeName)) continue;
            this.readDataAssociation((Element)xmlNode, id -> this.getVariableDataSpec(parser, (String)id), id -> (DataDefinition)ioSpec.getDataInput().get(id)).ifPresent(e -> {
                e.setType(DataAssociation.DataAssociationType.INPUT);
                ioSpec.getDataInputAssociation().add(e);
            });
        }
        return ioSpec;
    }

    protected IOSpecification readIOEspecification(Parser parser, Element element) {
        IOSpecification ioSpec = new IOSpecification();
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("ioSpecification".equals(nodeName)) {
                ioSpec.getDataInputs().addAll(this.readDataInput(parser, xmlNode));
                ioSpec.getDataOutputs().addAll(this.readDataOutput(parser, xmlNode));
                continue;
            }
            if ("dataInputAssociation".equals(nodeName)) {
                this.readDataAssociation((Element)xmlNode, id -> this.getVariableDataSpec(parser, (String)id), id -> (DataDefinition)ioSpec.getDataInput().get(id)).ifPresent(e -> {
                    e.setType(DataAssociation.DataAssociationType.INPUT);
                    ioSpec.getDataInputAssociation().add(e);
                });
                continue;
            }
            if (!"dataOutputAssociation".equals(nodeName)) continue;
            this.readDataAssociation((Element)xmlNode, id -> (DataDefinition)ioSpec.getDataOutput().get(id), id -> this.getVariableDataSpec(parser, (String)id)).ifPresent(e -> {
                e.setType(DataAssociation.DataAssociationType.OUTPUT);
                ioSpec.getDataOutputAssociation().add(e);
            });
        }
        return ioSpec;
    }

    protected List<DataDefinition> readDataInput(Parser parser, org.w3c.dom.Node parent) {
        return this.readData(parser, parent, "dataInput");
    }

    protected List<DataDefinition> readDataOutput(Parser parser, org.w3c.dom.Node parent) {
        return this.readData(parser, parent, "dataOutput");
    }

    protected List<DataDefinition> readData(Parser parser, org.w3c.dom.Node parent, String tag) {
        ArrayList<DataDefinition> dataSet = new ArrayList<DataDefinition>();
        this.readChildrenElementsByTag(parent, tag).forEach(element -> {
            String id = element.getAttribute("id");
            String label = element.getAttribute("name");
            String type = null;
            String typeRef = element.getAttribute("itemSubjectRef");
            if (typeRef.isEmpty()) {
                logger.debug("{} with id {} is not pointing out to a itemSubjectRef", (Object)tag, (Object)id);
                type = element.getAttribute("dtype");
                String string = type = type.isEmpty() ? null : type;
                if (type != null) {
                    logger.debug("{} with id {} is using an old dtype. Please use itemSubjectRef", (Object)tag, (Object)id);
                }
            } else if (this.getStructureRef(parser, typeRef) != null) {
                type = this.getStructureRef(parser, typeRef).getStructureRef();
            }
            if (type == null) {
                type = "java.lang.Object";
                logger.debug("{} with id {} is not pointing out to a valid itemSubjectRef. falling back to {}", new Object[]{tag, id, type});
            }
            dataSet.add(new DataDefinition(id, label, type));
        });
        return dataSet;
    }

    protected List<Element> readChildrenElementsByTag(org.w3c.dom.Node parent, String tag) {
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList children = parent.getChildNodes();
        for (int idx = 0; idx < children.getLength(); ++idx) {
            org.w3c.dom.Node currentNode = children.item(idx);
            if (!(currentNode instanceof Element) || !tag.equals(((Element)currentNode).getNodeName())) continue;
            elements.add((Element)currentNode);
        }
        return elements;
    }

    protected Optional<Element> readSingleChildElementByTag(org.w3c.dom.Node parent, String tag) {
        List<Element> elements = this.readChildrenElementsByTag(parent, tag);
        return !elements.isEmpty() ? Optional.of(elements.get(0)) : Optional.empty();
    }

    protected Optional<DataAssociation> readDataAssociation(Element element, Function<String, DataDefinition> sourceResolver, Function<String, DataDefinition> targetResolver) {
        Transformation transformation;
        List<Assignment> assignments;
        DataDefinition target;
        List<DataDefinition> sources = this.readSources(element, sourceResolver);
        DataAssociation da = new DataAssociation(sources, target = this.readTarget(element, targetResolver), assignments = this.readAssignments(element, src -> {
            if (".".equals(src)) {
                return (DataDefinition)sources.get(0);
            }
            return (DataDefinition)sourceResolver.apply((String)src);
        }, dst -> {
            if (".".equals(dst)) {
                return target;
            }
            return (DataDefinition)targetResolver.apply((String)dst);
        }), transformation = this.readTransformation(element));
        if (da.getTarget() != null && da.getSources().isEmpty() && da.getAssignments().isEmpty()) {
            logger.debug("Read incomplete data association, will be ignored\n{}", (Object)da);
            return Optional.empty();
        }
        return Optional.of(da);
    }

    private Transformation readTransformation(Element parent) {
        Optional<Element> element = this.readSingleChildElementByTag(parent, "transformation");
        if (element.isEmpty()) {
            return null;
        }
        String lang = element.get().getAttribute("language");
        String expression = element.get().getTextContent();
        MVELInterpretedReturnValueEvaluator evaluator = null;
        if (lang.toLowerCase().contains("mvel")) {
            evaluator = new MVELInterpretedReturnValueEvaluator(expression);
        }
        return new Transformation(lang, expression, (ReturnValueEvaluator)evaluator);
    }

    protected List<DataDefinition> readSources(org.w3c.dom.Node parent, Function<String, DataDefinition> variableResolver) {
        ArrayList<DataDefinition> sources = new ArrayList<DataDefinition>();
        this.readChildrenElementsByTag(parent, "sourceRef").forEach(element -> {
            String varRef = element.getTextContent().trim();
            DataDefinition varResolved = (DataDefinition)variableResolver.apply(varRef);
            sources.add(varResolved != null ? varResolved : DataDefinition.toSimpleDefinition((String)varRef));
        });
        return sources;
    }

    protected DataDefinition readTarget(org.w3c.dom.Node parent, Function<String, DataDefinition> variableResolver) {
        Optional<Element> element = this.readSingleChildElementByTag(parent, "targetRef");
        if (element.isEmpty()) {
            return null;
        }
        String varRef = element.get().getTextContent().trim();
        DataDefinition varResolved = variableResolver.apply(varRef);
        return varResolved != null ? varResolved : DataDefinition.toSimpleDefinition((String)varRef);
    }

    private List<Assignment> readAssignments(Element parent, Function<String, DataDefinition> sourceResolver, Function<String, DataDefinition> targetResolver) {
        ArrayList<Assignment> assignments = new ArrayList<Assignment>();
        this.readChildrenElementsByTag(parent, "assignment").forEach(element -> {
            Optional<Element> from = this.readSingleChildElementByTag((org.w3c.dom.Node)element, "from");
            Optional<Element> to = this.readSingleChildElementByTag((org.w3c.dom.Node)element, "to");
            String language = element.getAttribute("expressionLanguage");
            if (language == null || language.isEmpty()) {
                language = element.getAttribute("language");
            }
            String source = from.get().getTextContent();
            String target = to.get().getTextContent();
            if (!language.isEmpty()) {
                assignments.add(new Assignment(language, this.toDataExpression(source), this.toDataExpression(target)));
            } else {
                DataDefinition targetDataSpec;
                DataDefinition sourceDataSpec;
                source = this.cleanUp(source);
                target = this.cleanUp(target);
                DataDefinition dataDefinition = sourceDataSpec = this.isExpr(source) ? this.toDataExpression(source) : (DataDefinition)sourceResolver.apply(source);
                if (sourceDataSpec == null) {
                    sourceDataSpec = this.toDataExpression(source);
                }
                DataDefinition dataDefinition2 = targetDataSpec = this.isExpr(target) ? this.toDataExpression(target) : (DataDefinition)targetResolver.apply(target);
                if (targetDataSpec == null) {
                    targetDataSpec = this.toDataExpression(target);
                }
                logger.debug("No language set for assignment {} to {}. Applying heuristics", (Object)sourceDataSpec, (Object)targetDataSpec);
                assignments.add(new Assignment(language.isEmpty() ? null : language, sourceDataSpec, targetDataSpec));
            }
        });
        return assignments;
    }

    private String cleanUp(String expression) {
        Matcher matcher = PatternConstants.PARAMETER_MATCHER.matcher(expression);
        String temp = expression;
        if (matcher.find()) {
            temp = matcher.group(1);
        }
        return temp.contains(".") ? expression : temp;
    }

    private DataDefinition toDataExpression(String expression) {
        DataDefinition dataSpec = new DataDefinition(UUID.randomUUID().toString(), "EXPRESSION (" + expression + ")", (String)null);
        dataSpec.setExpression(expression);
        return dataSpec;
    }

    private boolean isExpr(String mvelExpression) {
        return mvelExpression != null && mvelExpression.contains("#{");
    }

    protected NodeImpl decorateMultiInstanceSpecificationSubProcess(CompositeContextNode nodeTarget, MultiInstanceSpecification multiInstanceSpecification) {
        ForEachNode forEachNode = this.decorateMultiInstanceSpecification((NodeImpl)nodeTarget, multiInstanceSpecification);
        forEachNode.setMetaData("BPMN.Connections", nodeTarget.getMetaData("BPMN.Connections"));
        forEachNode.setAutoComplete(nodeTarget.isAutoComplete());
        for (Node subNode : nodeTarget.getNodes()) {
            forEachNode.addNode(subNode);
        }
        VariableScope subProcessVariableScope = (VariableScope)forEachNode.getCompositeNode().getDefaultContext("VariableScope");
        VariableScope oldSubProcessVariables = (VariableScope)nodeTarget.getDefaultContext("VariableScope");
        oldSubProcessVariables.getVariables().forEach(arg_0 -> ((VariableScope)subProcessVariableScope).addVariable(arg_0));
        DataDefinition inputItem = multiInstanceSpecification.getInputDataItem();
        if (inputItem != null) {
            Variable var = new Variable();
            var.setId(inputItem.getId());
            var.setName(inputItem.getLabel());
            var.setType(DataTypeResolver.fromType((String)inputItem.getType(), (ClassLoader)Thread.currentThread().getContextClassLoader()));
            subProcessVariableScope.addVariable(var);
        }
        return forEachNode;
    }

    protected NodeImpl decorateMultiInstanceSpecificationActivity(NodeImpl nodeTarget, MultiInstanceSpecification multiInstanceSpecification) {
        ForEachNode forEachNode = this.decorateMultiInstanceSpecification(nodeTarget, multiInstanceSpecification);
        String uniqueId = nodeTarget.getUniqueId();
        nodeTarget.setId(WorkflowElementIdentifierFactory.fromExternalFormat((String)(uniqueId + "_1")));
        forEachNode.addNode((Node)nodeTarget);
        forEachNode.linkIncomingConnections("DROOLS_DEFAULT", nodeTarget.getId(), "DROOLS_DEFAULT");
        forEachNode.linkOutgoingConnections(nodeTarget.getId(), "DROOLS_DEFAULT", "DROOLS_DEFAULT");
        return forEachNode;
    }

    protected ForEachNode decorateMultiInstanceSpecification(NodeImpl nodeTarget, MultiInstanceSpecification multiInstanceSpecification) {
        ForEachNode forEachNode = new ForEachNode(nodeTarget.getId());
        forEachNode.setName(nodeTarget.getName());
        nodeTarget.setMetaData("hidden", (Object)true);
        forEachNode.setIoSpecification(nodeTarget.getIoSpecification());
        DataDefinition dataInput = multiInstanceSpecification.getInputDataItem();
        DataDefinition dataOutput = multiInstanceSpecification.getOutputDataItem();
        if (dataInput != null) {
            forEachNode.setInputRef(dataInput.getLabel());
            forEachNode.addContextVariable(dataInput.getId(), dataInput.getLabel(), DataTypeResolver.fromType((String)dataInput.getType(), (ClassLoader)Thread.currentThread().getContextClassLoader()));
            forEachNode.getIoSpecification().getDataInputAssociation().stream().filter(e -> !e.getSources().isEmpty() && ((DataDefinition)e.getSources().get(0)).getId().equals(dataInput.getId())).forEach(da -> {
                da.getSources().clear();
                da.getSources().add(dataInput);
            });
        }
        if (dataOutput != null) {
            forEachNode.setOutputRef(dataOutput.getLabel());
            forEachNode.addContextVariable(dataOutput.getId(), dataOutput.getLabel(), DataTypeResolver.fromType((String)dataOutput.getType(), (ClassLoader)Thread.currentThread().getContextClassLoader()));
            forEachNode.getIoSpecification().getDataOutputAssociation().stream().filter(e -> e.getTarget().getId().equals(dataOutput.getId())).forEach(da -> da.setTarget(dataOutput));
        }
        if (multiInstanceSpecification.hasLoopDataInputRef()) {
            DataDefinition dataInputRef = multiInstanceSpecification.getLoopDataInputRef();
            nodeTarget.getMetaData().put("MICollectionInput", dataInputRef.getLabel());
            forEachNode.getIoSpecification().getDataInputAssociation().stream().filter(e -> e.getTarget().getId().equals(dataInputRef.getId())).findAny().ifPresent(pVar -> {
                String expr = ((DataDefinition)pVar.getSources().get(0)).getLabel();
                forEachNode.setCollectionExpression(expr);
            });
        }
        if (multiInstanceSpecification.hasLoopDataOutputRef()) {
            DataDefinition dataOutputRef = multiInstanceSpecification.getLoopDataOutputRef();
            nodeTarget.getMetaData().put("MICollectionOutput", dataOutputRef.getLabel());
            forEachNode.getIoSpecification().getDataOutputAssociation().stream().filter(e -> ((DataDefinition)e.getSources().get(0)).getId().equals(dataOutputRef.getId())).findAny().ifPresent(e -> forEachNode.setOutputCollectionExpression(e.getTarget().getLabel()));
            Iterator iterator = forEachNode.getIoSpecification().getDataOutputAssociation().iterator();
            while (iterator.hasNext()) {
                DataAssociation current = (DataAssociation)iterator.next();
                if (current.getSources().isEmpty() || !((DataDefinition)current.getSources().get(0)).equals((Object)dataOutputRef)) continue;
                iterator.remove();
            }
        }
        forEachNode.setCompletionConditionExpression(multiInstanceSpecification.getCompletionCondition());
        forEachNode.setMultiInstanceSpecification(multiInstanceSpecification);
        VariableScope foreachContext = (VariableScope)forEachNode.getCompositeNode().getDefaultContext("VariableScope");
        Variable forEach = new Variable();
        forEach.setId("foreach_output");
        forEach.setName("foreach_output");
        forEach.setType(DataTypeResolver.fromType((String)Collection.class.getCanonicalName(), (ClassLoader)Thread.currentThread().getContextClassLoader()));
        foreachContext.addVariable(forEach);
        return forEachNode;
    }

    protected MultiInstanceSpecification readMultiInstanceSpecification(Parser parser, org.w3c.dom.Node parent, IOSpecification ioSpecification) {
        MultiInstanceSpecification multiInstanceSpecification = new MultiInstanceSpecification();
        Optional<Element> multiInstanceParent = this.readSingleChildElementByTag(parent, "multiInstanceLoopCharacteristics");
        if (multiInstanceParent.isEmpty()) {
            return multiInstanceSpecification;
        }
        Element multiInstanceNode = multiInstanceParent.get();
        multiInstanceSpecification.setSequential(Boolean.parseBoolean(multiInstanceNode.getAttribute("isSequential")));
        this.readSingleChildElementByTag(multiInstanceNode, "inputDataItem").ifPresent(inputDataItem -> {
            String id = inputDataItem.getAttribute("id");
            String name = inputDataItem.getAttribute("name");
            String itemSubjectRef = inputDataItem.getAttribute("itemSubjectRef");
            ItemDefinition itemDefinition = this.getStructureRef(parser, itemSubjectRef);
            String structureRef = itemDefinition != null ? itemDefinition.getStructureRef() : null;
            DataDefinition input = new DataDefinition(id, name, structureRef);
            multiInstanceSpecification.setInputDataItem(input);
            if (!ioSpecification.containsInputLabel(input.getLabel())) {
                ioSpecification.getDataInputs().add(input);
            }
        });
        this.readSingleChildElementByTag(multiInstanceNode, "outputDataItem").ifPresent(outputDataItem -> {
            String id = outputDataItem.getAttribute("id");
            String name = outputDataItem.getAttribute("name");
            String itemSubjectRef = outputDataItem.getAttribute("itemSubjectRef");
            ItemDefinition itemDefinition = this.getStructureRef(parser, itemSubjectRef);
            String structureRef = itemDefinition != null ? itemDefinition.getStructureRef() : null;
            DataDefinition output = new DataDefinition(id, name, structureRef);
            multiInstanceSpecification.setOutputDataItem(output);
            if (!ioSpecification.containsOutputLabel(output.getLabel())) {
                ioSpecification.getDataOutputs().add(output);
            }
        });
        this.readSingleChildElementByTag(multiInstanceNode, "loopDataOutputRef").ifPresent(loopDataOutputRef -> {
            String expressiontOutput = loopDataOutputRef.getTextContent();
            if (expressiontOutput != null && !expressiontOutput.isEmpty()) {
                multiInstanceSpecification.setLoopDataOutputRef((DataDefinition)ioSpecification.getDataOutput().get(expressiontOutput));
            }
        });
        this.readSingleChildElementByTag(multiInstanceNode, "loopDataInputRef").ifPresent(loopDataInputRef -> {
            String expressionInput = loopDataInputRef.getTextContent();
            if (expressionInput != null && !expressionInput.isEmpty()) {
                multiInstanceSpecification.setLoopDataInputRef((DataDefinition)ioSpecification.getDataInput().get(expressionInput));
            }
        });
        this.readSingleChildElementByTag(multiInstanceNode, "completionCondition").ifPresent(completeCondition -> {
            String completion = completeCondition.getTextContent();
            if (completion != null && !completion.isEmpty()) {
                multiInstanceSpecification.setCompletionCondition(completion);
            }
        });
        return multiInstanceSpecification;
    }

    protected String getErrorIdForErrorCode(String errorCode, org.jbpm.workflow.core.Node node) {
        NodeContainer parent = node.getParentContainer();
        while (!(parent instanceof RuleFlowProcess) && parent instanceof org.jbpm.workflow.core.Node) {
            parent = ((org.jbpm.workflow.core.Node)parent).getParentContainer();
        }
        if (!(parent instanceof RuleFlowProcess)) {
            throw new RuntimeException("This should never happen: !(parent instanceof RuleFlowProcess): parent is " + parent.getClass().getSimpleName());
        }
        List<Error> errors = ((Definitions)((RuleFlowProcess)parent).getMetaData("Definitions")).getErrors();
        Signal error = null;
        for (Error listError : errors) {
            if (errorCode.equals(listError.getErrorCode())) {
                error = listError;
                break;
            }
            if (!errorCode.equals(listError.getId())) continue;
            error = listError;
            break;
        }
        if (error == null) {
            throw new ProcessParsingValidationException("Could not find error with errorCode " + errorCode);
        }
        return error.getId();
    }

    protected void handleThrowCompensationEventNode(org.jbpm.workflow.core.Node node, Element element, String uri, String localName, Parser parser) {
        if (!(node instanceof ActionNode) && !(node instanceof EndNode)) {
            throw new IllegalArgumentException("Node is neither an ActionNode nor an EndNode but a " + node.getClass().getSimpleName());
        }
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            if (!"compensateEventDefinition".equals(xmlNode.getNodeName())) continue;
            String activityRef = ((Element)xmlNode).getAttribute("activityRef");
            if (activityRef == null) {
                activityRef = "";
            }
            node.setMetaData("compensation-activityRef", (Object)activityRef);
            String nodeId = node.getUniqueId();
            String waitForCompletionString = ((Element)xmlNode).getAttribute("waitForCompletion");
            boolean waitForCompletion = true;
            if (waitForCompletionString != null && waitForCompletionString.length() > 0) {
                waitForCompletion = Boolean.parseBoolean(waitForCompletionString);
            }
            if (waitForCompletion) continue;
            throw new ProcessParsingValidationException("Asynchronous compensation [" + nodeId + ", " + node.getName() + "] is not yet supported!");
        }
    }

    protected void writeThrow(IOSpecification ioSpecification, StringBuilder xmlDump) {
        for (DataDefinition input : ioSpecification.getDataInput().values()) {
            xmlDump.append("        <dataInput id=\"" + input.getId() + "\" name=\"" + input.getLabel() + "\" />" + EOL);
        }
        for (DataDefinition input : ioSpecification.getDataInputAssociation()) {
            xmlDump.append("      <dataInputAssociation>" + EOL);
            this.writeDataAssociation((DataAssociation)input, xmlDump);
            xmlDump.append("      </dataInputAssociation>" + EOL);
        }
    }

    protected void writeCatchIO(IOSpecification ioSpecification, StringBuilder xmlDump) {
        for (DataDefinition output : ioSpecification.getDataOutput().values()) {
            xmlDump.append("        <dataOutput id=\"" + output.getId() + "\" name=\"" + output.getLabel() + "\" />" + EOL);
        }
        for (DataDefinition output : ioSpecification.getDataOutputAssociation()) {
            xmlDump.append("      <dataOutputAssociation>" + EOL);
            this.writeDataAssociation((DataAssociation)output, xmlDump);
            xmlDump.append("      </dataOutputAssociation>" + EOL);
        }
    }

    protected void writeIO(IOSpecification ioSpecification, StringBuilder xmlDump) {
        xmlDump.append("      <ioSpecification>" + EOL);
        for (DataDefinition input : ioSpecification.getDataInput().values()) {
            xmlDump.append("        <dataInput id=\"" + input.getId() + "\" name=\"" + input.getLabel() + "\" />" + EOL);
        }
        for (DataDefinition output : ioSpecification.getDataOutput().values()) {
            xmlDump.append("        <dataOutput id=\"" + output.getId() + "\" name=\"" + output.getLabel() + "\" />" + EOL);
        }
        for (DataDefinition input : ioSpecification.getDataInputAssociation()) {
            xmlDump.append("      <dataInputAssociation>" + EOL);
            this.writeDataAssociation((DataAssociation)input, xmlDump);
            xmlDump.append("      </dataInputAssociation>" + EOL);
        }
        for (DataDefinition output : ioSpecification.getDataOutputAssociation()) {
            xmlDump.append("      <dataOutputAssociation>" + EOL);
            this.writeDataAssociation((DataAssociation)output, xmlDump);
            xmlDump.append("      </dataOutputAssociation>" + EOL);
        }
        xmlDump.append("      </ioSpecification>" + EOL);
    }

    protected void writeDataAssociation(DataAssociation input, StringBuilder xmlDump) {
        for (DataDefinition source : input.getSources()) {
            xmlDump.append("        <sourceRef>" + source.getId() + "</sourceRef>" + EOL);
        }
        if (input.getTarget() != null) {
            xmlDump.append("<targetRef>" + input.getTarget().getId() + "</targetRef>" + EOL);
        }
        if (!input.getAssignments().isEmpty()) {
            for (Assignment assignment : input.getAssignments()) {
                xmlDump.append("        <assignment>" + EOL);
                xmlDump.append("             <from xsi:type=\"tFormalExpression\">" + assignment.getFrom().getExpression() + "</from>");
                xmlDump.append("             <to xsi:type=\"tFormalExpression\">" + assignment.getTo().getExpression() + "</to>");
                xmlDump.append("        </assignment>" + EOL);
            }
        }
    }

    protected void writeMultiInstance(MultiInstanceSpecification ioSpecification, StringBuilder xmlDump) {
        DataDefinition output;
        DataDefinition input;
        if (!ioSpecification.hasLoopDataInputRef()) {
            return;
        }
        xmlDump.append("<multiInstanceLoopCharacteristics>" + EOL);
        if (ioSpecification.hasLoopDataInputRef()) {
            xmlDump.append("<loopDataInputRef>" + ioSpecification.getLoopDataInputRef() + "</loopDataInputRef>" + EOL);
        }
        if (ioSpecification.hasLoopDataOutputRef()) {
            xmlDump.append("<loopDataOutputRef>" + ioSpecification.getLoopDataOutputRef() + "</loopDataOutputRef>" + EOL);
        }
        if ((input = ioSpecification.getInputDataItem()) != null) {
            xmlDump.append("<inputDataItem id=\"" + input.getId() + "\" name=\"" + input.getLabel() + "\" structureRef=\"" + input.getType() + "\" />");
        }
        if ((output = ioSpecification.getOutputDataItem()) != null) {
            xmlDump.append("<outputDataItem id=\"" + output.getId() + "\" name=\"" + output.getLabel() + "\" structureRef=\"" + output.getType() + "\" />");
        }
        xmlDump.append("</multiInstanceLoopCharacteristics>" + EOL);
    }

    protected String checkSignalAndConvertToRealSignalNam(Parser parser, String signalName) {
        Signal signal = this.findSignalByName(parser, signalName);
        if (signal != null && (signalName = signal.getName()) == null) {
            throw new ProcessParsingValidationException("Signal definition must have a name attribute");
        }
        return signalName;
    }

    protected Signal findSignalByName(Parser parser, String signalName) {
        ProcessBuildData buildData = (ProcessBuildData)parser.getData();
        HashSet<String> signalNames = (HashSet<String>)buildData.getMetaData(SIGNAL_NAMES);
        if (signalNames == null) {
            signalNames = new HashSet<String>();
            buildData.setMetaData(SIGNAL_NAMES, signalNames);
        }
        signalNames.add(signalName);
        Map signals = (Map)buildData.getMetaData("Signals");
        if (signals != null) {
            return (Signal)signals.get(signalName);
        }
        return null;
    }

    protected String retrieveDataType(String itemSubjectRef, String dtype, Parser parser) {
        if (dtype != null && !dtype.isEmpty()) {
            return dtype;
        }
        if (itemSubjectRef != null && !itemSubjectRef.isEmpty()) {
            Map itemDefinitions = (Map)((ProcessBuildData)parser.getData()).getMetaData("ItemDefinitions");
            return ((ItemDefinition)itemDefinitions.get(itemSubjectRef)).getStructureRef();
        }
        return null;
    }

    protected String findVariable(String variableName, Parser parser) {
        if (variableName == null) {
            return null;
        }
        Collection parents = ((ExtensibleXmlParser)parser).getParents();
        for (Object parent : parents) {
            if (!(parent instanceof ContextContainer)) continue;
            ContextContainer contextContainer = (ContextContainer)parent;
            VariableScope variableScope = (VariableScope)contextContainer.getDefaultContext("VariableScope");
            return variableScope.getVariables().stream().filter(v -> v.matchByIdOrName(variableName)).map(v -> v.getName()).findFirst().orElse(variableName);
        }
        return variableName;
    }
}

