/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.compiler.xml.Parser;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.process.core.ParameterDefinition;
import org.jbpm.process.core.Work;
import org.jbpm.process.core.datatype.DataTypeResolver;
import org.jbpm.process.core.impl.ParameterDefinitionImpl;
import org.jbpm.process.core.impl.WorkImpl;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.DataAssociation;
import org.jbpm.workflow.core.impl.DataDefinition;
import org.jbpm.workflow.core.impl.ExtendedNodeImpl;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.Assignment;
import org.jbpm.workflow.core.node.MilestoneNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TaskHandler
extends AbstractNodeHandler {
    @Override
    protected Node createNode(Attributes attrs) {
        return new WorkItemNode();
    }

    public Class<?> generateNodeFor() {
        return Node.class;
    }

    @Override
    protected Node handleNode(Node node, Element element, String uri, String localName, Parser parser) throws SAXException {
        boolean isForCompensation;
        super.handleNode(node, element, uri, localName, parser);
        WorkItemNode workItemNode = (WorkItemNode)node;
        String name = this.getTaskName(element);
        WorkImpl work = new WorkImpl();
        work.setName(name);
        workItemNode.setWork((Work)work);
        WorkItemNode currentNode = workItemNode;
        workItemNode.setIoSpecification(this.readIOEspecification(parser, element));
        workItemNode.setMultiInstanceSpecification(this.readMultiInstanceSpecification(parser, element, workItemNode.getIoSpecification()));
        if (workItemNode.getMultiInstanceSpecification().hasMultiInstanceInput()) {
            currentNode = this.decorateMultiInstanceSpecificationActivity((NodeImpl)workItemNode, workItemNode.getMultiInstanceSpecification());
        }
        work.setParameter("NodeName", (Object)workItemNode.getName());
        this.setParameter((Work)work, "TaskName", workItemNode.getIoSpecification().getDataInputAssociation());
        workItemNode.setMetaData("DataInputs", new HashMap());
        workItemNode.setMetaData("DataOutputs", new HashMap());
        this.handleScript((ExtendedNodeImpl)workItemNode, element, "onEntry");
        this.handleScript((ExtendedNodeImpl)workItemNode, element, "onExit");
        String compensation = element.getAttribute("isForCompensation");
        if (compensation != null && (isForCompensation = Boolean.parseBoolean(compensation))) {
            workItemNode.setMetaData("isForCompensation", (Object)isForCompensation);
        }
        for (DataDefinition dd : workItemNode.getIoSpecification().getDataInputs()) {
            workItemNode.getWork().addParameterDefinition((ParameterDefinition)new ParameterDefinitionImpl(dd.getLabel(), DataTypeResolver.fromType((String)dd.getType(), (ClassLoader)Thread.currentThread().getContextClassLoader())));
        }
        return currentNode;
    }

    protected void setParameter(Work work, String label, Collection<DataAssociation> dataAssociations) {
        for (DataAssociation dataAssociation : dataAssociations) {
            if (dataAssociation.getAssignments().isEmpty() || !label.equals(((Assignment)dataAssociation.getAssignments().get(0)).getTo().getLabel())) continue;
            DataDefinition from = ((Assignment)dataAssociation.getAssignments().get(0)).getFrom();
            work.setParameter(label, (Object)(from.hasExpression() ? from.getExpression() : from.getLabel()));
        }
    }

    protected String getTaskName(Element element) {
        return element.getAttribute("taskName");
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        throw new IllegalArgumentException("Writing out should be handled by the WorkItemNodeHandler");
    }

    @Override
    public Object end(String uri, String localName, Parser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        Node node = (Node)parser.getCurrent();
        if ((node = this.handleNode(node, element, uri, localName, parser)) instanceof WorkItemNode && ((WorkItemNode)node).getWork().getName().equals("Milestone")) {
            WorkItemNode workItemNode = (WorkItemNode)node;
            this.setParameter(((WorkItemNode)node).getWork(), "Condition", ((NodeImpl)node).getIoSpecification().getDataInputAssociation());
            String milestoneCondition = (String)((WorkItemNode)node).getWork().getParameter("Condition");
            MilestoneNode milestoneNode = new MilestoneNode();
            milestoneNode.setId(workItemNode.getId());
            milestoneNode.setMetaData(workItemNode.getMetaData());
            milestoneNode.setCondition(milestoneCondition);
            milestoneNode.setName(workItemNode.getName());
            milestoneNode.setParentContainer(workItemNode.getParentContainer());
            Arrays.stream(workItemNode.getActionTypes()).forEach(action -> milestoneNode.setActions(action, workItemNode.getActions(action)));
            node = milestoneNode;
        }
        NodeContainer nodeContainer = (NodeContainer)parser.getParent();
        nodeContainer.addNode((org.kie.api.definition.process.Node)node);
        ((ProcessBuildData)parser.getData()).addNode(node);
        return node;
    }
}

