/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.bpmn2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jbpm.process.core.context.variable.Variable;
import org.kie.kogito.Model;

public class BpmnVariables
implements Model {
    public static final Predicate<Variable> OUTPUTS_ONLY = v -> v.hasTag("output");
    public static final Predicate<Variable> INPUTS_ONLY = v -> v.hasTag("input");
    public static final Predicate<Variable> INTERNAL_ONLY = v -> v.hasTag("internal");
    private final Map<String, Object> variables = new HashMap<String, Object>();
    private List<Variable> definitions = new ArrayList<Variable>();

    protected BpmnVariables() {
    }

    protected BpmnVariables(Map<String, Object> variables) {
        this.variables.putAll(variables);
    }

    protected BpmnVariables(List<Variable> definitions, Map<String, Object> variables) {
        this.definitions = definitions;
        this.variables.putAll(variables);
    }

    public static BpmnVariables create() {
        return new BpmnVariables();
    }

    public static BpmnVariables create(Map<String, Object> variables) {
        return new BpmnVariables(variables);
    }

    public Object get(String v) {
        return this.variables.get(v);
    }

    public BpmnVariables set(String v, Object o) {
        this.variables.put(v, o);
        return this;
    }

    public void update(Map<String, Object> params) {
        this.fromMap(params);
    }

    public BpmnVariables fromMap(Map<String, Object> vs) {
        this.variables.putAll(vs);
        return this;
    }

    public List<Variable> definitions() {
        return this.definitions;
    }

    public Map<String, Object> toMap() {
        return Collections.unmodifiableMap(this.variables);
    }

    public Map<String, Object> toMap(Predicate<Variable> filter) {
        return this.definitions.stream().filter(filter).filter(v -> this.variables.containsKey(v.getName())).collect(Collectors.toMap(v -> v.getName(), v -> this.variables.get(v.getName())));
    }
}

