/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.net.URI;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.cloudevents.SpecVersionDeserializer;
import org.kie.kogito.event.cloudevents.SpecVersionSerializer;
import org.kie.kogito.event.cloudevents.utils.CloudEventUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class AbstractDataEvent<T>
implements DataEvent<T> {
    public static final String TYPE_PREFIX = "process";
    public static final String TYPE_FORMAT = "process.%s.%s";
    public static final String SOURCE_FORMAT = "/process/%s";
    public static final String SPEC_VERSION = "1.0";
    public static final String DATA_CONTENT_TYPE = "application/json";
    @JsonDeserialize(using=SpecVersionDeserializer.class)
    @JsonSerialize(using=SpecVersionSerializer.class)
    @JsonProperty(value="specversion")
    private SpecVersion specVersion;
    private String id;
    private URI source;
    private String type;
    private OffsetDateTime time;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String subject;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="datacontenttype")
    private String dataContentType;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private URI dataSchema;
    private T data;
    @JsonProperty(value="kogitoprocinstanceid")
    private String kogitoProcessInstanceId;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="kogitorootprociid")
    private String kogitoRootProcessInstanceId;
    @JsonProperty(value="kogitoprocid")
    private String kogitoProcessId;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="kogitorootprocid")
    private String kogitoRootProcessId;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="kogitoaddons")
    private String kogitoAddons;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="kogitoprocversion")
    protected String kogitoProcessInstanceVersion;
    @JsonProperty(value="kogitoparentprociid")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected String kogitoParentProcessInstanceId;
    @JsonProperty(value="kogitoprocist")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected String kogitoProcessInstanceState;
    @JsonProperty(value="kogitoprocrefid")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected String kogitoReferenceId;
    @JsonProperty(value="kogitoprocstartfrom")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected String kogitoStartFromNode;
    @JsonProperty(value="kogitobusinesskey")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected String kogitoBusinessKey;
    @JsonProperty(value="kogitoproctype")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected String kogitoProcessType;
    @JsonProperty(value="kogitoidentity")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    protected String kogitoIdentity;
    private static final Set<String> INTERNAL_EXTENSION_ATTRIBUTES = new HashSet<String>(Arrays.asList("kogitoprocinstanceid", "kogitorootprociid", "kogitoprocid", "kogitorootprocid", "kogitoaddons", "kogitoprocversion", "kogitoparentprociid", "kogitoprocist", "kogitoprocrefid", "kogitoprocstartfrom", "kogitobusinesskey", "kogitoproctype", "kogitoidentity"));
    private Map<String, Object> extensionAttributes = new HashMap<String, Object>();

    protected AbstractDataEvent() {
    }

    protected AbstractDataEvent(String type, String source, T body, String kogitoProcessInstanceId, String kogitoRootProcessInstanceId, String kogitoProcessId, String kogitoRootProcessId, String kogitoAddons, String kogitoIdentity) {
        this(type, source, body, kogitoProcessInstanceId, kogitoRootProcessInstanceId, kogitoProcessId, kogitoRootProcessId, kogitoAddons, kogitoIdentity, null, DATA_CONTENT_TYPE, null);
    }

    protected AbstractDataEvent(String type, String source, T body, String kogitoProcessInstanceId, String kogitoRootProcessInstanceId, String kogitoProcessId, String kogitoRootProcessId, String kogitoAddons, String kogitoIdentity, String subject, String dataContentType, String dataSchema) {
        this.specVersion = SpecVersion.parse((String)SPEC_VERSION);
        this.id = UUID.randomUUID().toString();
        this.source = Optional.ofNullable(source).map(URI::create).orElse(null);
        this.type = type;
        this.time = ZonedDateTime.now().toOffsetDateTime();
        this.data = body;
        this.setKogitoProcessInstanceId(kogitoProcessInstanceId);
        this.setKogitoRootProcessInstanceId(kogitoRootProcessInstanceId);
        this.setKogitoProcessId(kogitoProcessId);
        this.setKogitoRootProcessId(kogitoRootProcessId);
        this.setKogitoAddons(kogitoAddons);
        this.setKogitoIdentity(kogitoIdentity);
        this.subject = subject;
        this.dataContentType = dataContentType;
        this.dataSchema = dataSchema != null ? URI.create(dataSchema) : null;
        this.ensureRequiredFields();
    }

    protected void ensureRequiredFields() {
        if (this.type == null || this.type.isEmpty()) {
            this.type = TYPE_PREFIX;
        }
        if (this.source == null || this.source.toString().isEmpty()) {
            this.source = URI.create(String.format(SOURCE_FORMAT, this.kogitoProcessId));
        }
    }

    public URI getSource() {
        return this.source;
    }

    public SpecVersion getSpecVersion() {
        return this.specVersion;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public OffsetDateTime getTime() {
        return this.time;
    }

    public T getData() {
        return this.data;
    }

    public URI getDataSchema() {
        return this.dataSchema;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getDataContentType() {
        return this.dataContentType;
    }

    public String getKogitoProcessInstanceId() {
        return this.kogitoProcessInstanceId;
    }

    public String getKogitoRootProcessInstanceId() {
        return this.kogitoRootProcessInstanceId;
    }

    public String getKogitoProcessId() {
        return this.kogitoProcessId;
    }

    public String getKogitoRootProcessId() {
        return this.kogitoRootProcessId;
    }

    public String getKogitoAddons() {
        return this.kogitoAddons;
    }

    public String getKogitoIdentity() {
        return this.kogitoIdentity;
    }

    public Object getAttribute(String name) {
        switch (name) {
            case "datacontenttype": 
            case "datacontentencoding": {
                return this.getDataContentType();
            }
            case "dataschema": 
            case "schemaurl": {
                return this.getDataSchema();
            }
            case "id": {
                return this.getId();
            }
            case "source": {
                return this.getSource();
            }
            case "specversion": {
                return this.getSpecVersion();
            }
            case "time": {
                return this.getTime();
            }
            case "type": {
                return this.getType();
            }
            case "subject": {
                return this.getSubject();
            }
        }
        throw new IllegalArgumentException(name + " is not valid attribute for specVersion " + this.specVersion);
    }

    public Object getExtension(String name) {
        return this.extensionAttributes.get(name);
    }

    @JsonIgnore
    public Set<String> getAttributeNames() {
        return this.specVersion == null ? Collections.emptySet() : super.getAttributeNames();
    }

    @JsonIgnore
    public Set<String> getExtensionNames() {
        return this.extensionAttributes.keySet();
    }

    @JsonAnyGetter
    private Map<String, Object> getExtensionAttributes() {
        return this.extensionAttributes.entrySet().stream().filter(entry -> !this.isInternalAttribute((String)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    protected boolean isInternalAttribute(String name) {
        return INTERNAL_EXTENSION_ATTRIBUTES.contains(name);
    }

    public void setSpecVersion(SpecVersion specVersion) {
        this.specVersion = specVersion;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSource(URI source) {
        this.source = source;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setTime(OffsetDateTime time) {
        this.time = time;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setDataContentType(String dataContentType) {
        this.dataContentType = dataContentType;
    }

    public void setDataSchema(URI dataSchema) {
        this.dataSchema = dataSchema;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getKogitoParentProcessInstanceId() {
        return this.kogitoParentProcessInstanceId;
    }

    public String getKogitoProcessInstanceState() {
        return this.kogitoProcessInstanceState;
    }

    public String getKogitoReferenceId() {
        return this.kogitoReferenceId;
    }

    public String getKogitoBusinessKey() {
        return this.kogitoBusinessKey;
    }

    public String getKogitoStartFromNode() {
        return this.kogitoStartFromNode;
    }

    public String getKogitoProcessInstanceVersion() {
        return this.kogitoProcessInstanceVersion;
    }

    public String getKogitoProcessType() {
        return this.kogitoProcessType;
    }

    public void setKogitoProcessInstanceId(String kogitoProcessInstanceId) {
        this.addExtensionAttribute("kogitoprocinstanceid", kogitoProcessInstanceId);
    }

    public void setKogitoRootProcessInstanceId(String kogitoRootProcessInstanceId) {
        this.addExtensionAttribute("kogitorootprociid", kogitoRootProcessInstanceId);
    }

    public void setKogitoProcessId(String kogitoProcessId) {
        this.addExtensionAttribute("kogitoprocid", kogitoProcessId);
    }

    public void setKogitoRootProcessId(String kogitoRootProcessId) {
        this.addExtensionAttribute("kogitorootprocid", kogitoRootProcessId);
    }

    public void setKogitoAddons(String kogitoAddons) {
        this.addExtensionAttribute("kogitoaddons", kogitoAddons);
    }

    public void setKogitoIdentity(String identity) {
        this.addExtensionAttribute("kogitoidentity", identity);
    }

    public void setKogitoStartFromNode(String kogitoStartFromNode) {
        this.addExtensionAttribute("kogitoprocstartfrom", kogitoStartFromNode);
    }

    public void setKogitoProcessInstanceVersion(String kogitoProcessInstanceVersion) {
        this.addExtensionAttribute("kogitoprocversion", kogitoProcessInstanceVersion);
    }

    public void setKogitoParentProcessInstanceId(String kogitoParentProcessInstanceId) {
        this.addExtensionAttribute("kogitoparentprociid", kogitoParentProcessInstanceId);
    }

    public void setKogitoProcessInstanceState(String kogitoProcessInstanceState) {
        this.addExtensionAttribute("kogitoprocist", kogitoProcessInstanceState);
    }

    public void setKogitoReferenceId(String kogitoReferenceId) {
        this.addExtensionAttribute("kogitoprocrefid", kogitoReferenceId);
    }

    public void setKogitoBusinessKey(String kogitoBusinessKey) {
        this.addExtensionAttribute("kogitobusinesskey", kogitoBusinessKey);
    }

    public void setKogitoProcessType(String kogitoProcessType) {
        this.addExtensionAttribute("kogitoproctype", kogitoProcessType);
    }

    @JsonAnySetter
    public void addExtensionAttribute(String name, Object value) {
        if (value != null) {
            switch (name) {
                case "kogitoprocinstanceid": {
                    this.kogitoProcessInstanceId = (String)value;
                    break;
                }
                case "kogitorootprocid": {
                    this.kogitoRootProcessId = (String)value;
                    break;
                }
                case "kogitorootprociid": {
                    this.kogitoRootProcessInstanceId = (String)value;
                    break;
                }
                case "kogitoaddons": {
                    this.kogitoAddons = (String)value;
                    break;
                }
                case "kogitoprocid": {
                    this.kogitoProcessId = (String)value;
                    break;
                }
                case "kogitoprocrefid": {
                    this.kogitoReferenceId = (String)value;
                    break;
                }
                case "kogitoprocversion": {
                    this.kogitoProcessInstanceVersion = (String)value;
                    break;
                }
                case "kogitoparentprociid": {
                    this.kogitoParentProcessInstanceId = (String)value;
                    break;
                }
                case "kogitoprocist": {
                    this.kogitoProcessInstanceState = (String)value;
                    break;
                }
                case "kogitoprocstartfrom": {
                    this.kogitoStartFromNode = (String)value;
                    break;
                }
                case "kogitoproctype": {
                    this.kogitoProcessType = (String)value;
                    break;
                }
                case "kogitobusinesskey": {
                    this.kogitoBusinessKey = (String)value;
                    break;
                }
                case "kogitoidentity": {
                    this.kogitoIdentity = (String)value;
                }
            }
            this.extensionAttributes.put(name, value);
        }
    }

    public CloudEvent asCloudEvent(Function<T, CloudEventData> factory) {
        CloudEventBuilder builder = CloudEventBuilder.fromSpecVersion((SpecVersion)this.specVersion).withSource(this.source).withType(this.type).withId(this.id).withSubject(this.subject).withTime(this.time).withDataContentType(this.dataContentType).withDataSchema(this.dataSchema);
        builder.withData(factory.apply(this.data));
        this.extensionAttributes.forEach((k, v) -> CloudEventUtils.withExtension(builder, k, v));
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractDataEvent that = (AbstractDataEvent)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " {specVersion=" + this.specVersion + ", id='" + this.id + "', source=" + this.source + ", type='" + this.type + "', time=" + this.time + ", subject='" + this.subject + "', dataContentType='" + this.dataContentType + "', dataSchema=" + this.dataSchema + ", data=" + this.data + ", kogitoProcessInstanceId='" + this.kogitoProcessInstanceId + "', kogitoRootProcessInstanceId='" + this.kogitoRootProcessInstanceId + "', kogitoProcessId='" + this.kogitoProcessId + "', kogitoRootProcessId='" + this.kogitoRootProcessId + "', kogitoAddons='" + this.kogitoAddons + "', kogitoIdentity='" + this.kogitoIdentity + "', extensionAttributes=" + this.extensionAttributes + "}";
    }
}

