/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import io.cloudevents.CloudEventExtension;
import io.cloudevents.SpecVersion;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;
import org.kie.kogito.event.Converter;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.cloudevents.extension.ProcessMeta;
import org.kie.kogito.event.impl.CloudEventWrapDataEvent;
import org.kie.kogito.event.process.ProcessInstanceDataEvent;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;

public class DataEventFactory {
    public static <T> DataEvent<T> from(T event) {
        return new ProcessInstanceDataEvent<T>(event);
    }

    public static <T> DataEvent<T> from(CloudEvent event, Converter<CloudEventData, T> dataUnmarshaller) {
        return new CloudEventWrapDataEvent<T>(event, dataUnmarshaller);
    }

    public static <T> DataEvent<T> from(T eventData, String trigger, KogitoProcessInstance pi) {
        return DataEventFactory.from(eventData, trigger, URI.create("/process/" + pi.getProcessId()), Optional.empty(), new CloudEventExtension[]{ProcessMeta.fromKogitoProcessInstance((KogitoProcessInstance)pi)});
    }

    public static <T> DataEvent<T> from(T eventData, String type, URI source, Optional<String> subject, CloudEventExtension ... extensions) {
        ProcessInstanceDataEvent<T> ce = new ProcessInstanceDataEvent<T>(eventData);
        ce.setSpecVersion(SpecVersion.V1);
        ce.setId(UUID.randomUUID().toString());
        ce.setType(type);
        ce.setSource(source);
        ce.setTime(OffsetDateTime.now());
        subject.ifPresent(ce::setSubject);
        for (CloudEventExtension extension : extensions) {
            for (String key : extension.getKeys()) {
                ce.addExtensionAttribute(key, extension.getValue(key));
            }
        }
        return ce;
    }

    private DataEventFactory() {
    }
}

