/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.cloudevents.utils;

import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.kie.kogito.event.cloudevents.utils.CloudEventUtils;
import org.kie.kogito.event.cloudevents.utils.InvalidCloudEventException;

abstract class BaseCloudEventValidator {
    private static final Pattern RFC2046 = Pattern.compile("^[a-zA-Z]+/[a-zA-Z]+(?:[+\\-.][a-zA-Z0-9]+){0,10}$");

    BaseCloudEventValidator() {
    }

    protected abstract String getRfc3339Attribute();

    protected abstract String getRfc2046Attribute();

    final void validateCloudEvent(Map<String, Object> cloudEvent) throws InvalidCloudEventException {
        ArrayList<String> errors = new ArrayList<String>();
        CloudEventUtils.getMissingAttributes(cloudEvent).forEach(missingAttribute -> errors.add("Missing mandatory attribute: " + missingAttribute));
        this.validateNonEmptyAttributes(cloudEvent, errors);
        this.validateRfc2046Attributes(cloudEvent, errors);
        this.validateRfc3339Attributes(cloudEvent, errors);
        if (!errors.isEmpty()) {
            throw new InvalidCloudEventException(errors);
        }
    }

    private static <T> void validateAttribute(Map<String, Object> cloudEvent, String attribute, Predicate<T> validation, String message, Collection<String> errors) {
        Object value = cloudEvent.get(attribute);
        if (value != null && !validation.test(value)) {
            errors.add(attribute + message);
        }
    }

    private void validateRfc3339Attributes(Map<String, Object> cloudEvent, List<String> errors) {
        BaseCloudEventValidator.validateAttribute(cloudEvent, this.getRfc3339Attribute(), BaseCloudEventValidator::isRfc3339Value, " MUST adhere to the format specified in RFC 3339 (https://datatracker.ietf.org/doc/html/rfc3339).", errors);
    }

    private void validateRfc2046Attributes(Map<String, Object> cloudEvent, List<String> errors) {
        BaseCloudEventValidator.validateAttribute(cloudEvent, this.getRfc2046Attribute(), BaseCloudEventValidator::isRfc2046Value, " MUST adhere to the format specified in RFC 2046 (https://datatracker.ietf.org/doc/html/rfc2046).", errors);
    }

    private static boolean isRfc3339Value(String value) {
        try {
            DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(value);
            return true;
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }

    private static boolean isRfc2046Value(String value) {
        return RFC2046.matcher(value).matches();
    }

    private void validateNonEmptyAttributes(Map<String, Object> cloudEvent, List<String> errors) {
        for (String attribute : this.getNonEmptyAttributes()) {
            BaseCloudEventValidator.validateAttribute(cloudEvent, attribute, Predicate.not(""::equals), " must be a non-empty String.", errors);
        }
    }

    protected abstract List<String> getNonEmptyAttributes();
}

