/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.cloudevents.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventContext;
import io.cloudevents.CloudEventData;
import io.cloudevents.CloudEventExtension;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.data.PojoCloudEventData;
import io.cloudevents.core.impl.BaseCloudEventBuilder;
import io.cloudevents.jackson.JsonCloudEventData;
import io.cloudevents.jackson.JsonFormat;
import io.cloudevents.jackson.PojoCloudEventDataMapper;
import io.cloudevents.rw.CloudEventDataMapper;
import io.cloudevents.rw.CloudEventRWException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.cloudevents.utils.BaseCloudEventValidator;
import org.kie.kogito.event.cloudevents.utils.CloudEventValidatorV03;
import org.kie.kogito.event.cloudevents.utils.CloudEventValidatorV1;
import org.kie.kogito.event.cloudevents.utils.InvalidCloudEventException;
import org.kie.kogito.jackson.utils.JsonObjectUtils;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CloudEventUtils {
    public static final String DATA = "data";
    private static final Logger LOG = LoggerFactory.getLogger(CloudEventUtils.class);
    public static final String UNKNOWN_SOURCE_URI_STRING = CloudEventUtils.urlEncodedStringFrom("__UNKNOWN_SOURCE__").orElseThrow(IllegalStateException::new);

    private CloudEventUtils() {
    }

    public static JsonNode fromValue(DataEvent<JsonNode> dataEvent) {
        ObjectNode node = ObjectMapperFactory.listenerAware().createObjectNode();
        if (dataEvent.getData() != null) {
            node.set(DATA, (JsonNode)dataEvent.getData());
        }
        dataEvent.getAttributeNames().forEach(k -> node.set(k, JsonObjectUtils.fromValue((Object)dataEvent.getAttribute(k))));
        dataEvent.getExtensionNames().forEach(extensionName -> node.set(extensionName, JsonObjectUtils.fromValue((Object)dataEvent.getExtension(extensionName))));
        return node;
    }

    public static <E> Optional<CloudEvent> build(String id, URI source, E data, Class<E> dataType) {
        return CloudEventUtils.build(id, source, dataType.getName(), null, data, new CloudEventExtension[0]);
    }

    public static Optional<CloudEvent> build(String id, URI source, String type, String subject, Object data, CloudEventExtension ... extensions) {
        try {
            byte[] bytes = Mapper.mapper().writeValueAsBytes(data);
            BaseCloudEventBuilder builder = CloudEventBuilder.v1().withId(id).withSource(source).withType(type).withData(bytes);
            if (subject != null) {
                builder.withSubject(subject);
            }
            if (extensions != null) {
                for (CloudEventExtension extension : extensions) {
                    builder.withExtension(extension);
                }
            }
            return Optional.of(builder.build());
        }
        catch (JsonProcessingException e) {
            LOG.error("Unable to serialize CloudEvent data", (Throwable)e);
            return Optional.empty();
        }
    }

    public static Optional<String> encode(CloudEvent event) {
        try {
            return Optional.of(Mapper.mapper().writeValueAsString((Object)event));
        }
        catch (JsonProcessingException e) {
            LOG.error("Unable to encode CloudEvent", (Throwable)e);
            return Optional.empty();
        }
    }

    public static boolean isCloudEvent(String json) {
        Optional<CloudEvent> ce = CloudEventUtils.decode(json);
        return ce.isPresent() && !"".equals(ce.get().getId()) && !"".equals(ce.get().getType());
    }

    public static Optional<CloudEvent> decode(String json) {
        try {
            return Optional.of((CloudEvent)Mapper.mapper().readValue(json, CloudEvent.class));
        }
        catch (JsonProcessingException e) {
            LOG.error("Unable to decode CloudEvent", (Throwable)e);
            return Optional.empty();
        }
    }

    public static <T> Optional<T> decodeData(CloudEvent event, Class<T> dataClass) {
        return CloudEventUtils.decodeData(event, dataClass, Mapper.mapper());
    }

    public static <T> Optional<T> decodeData(CloudEvent event, Class<T> dataClass, ObjectMapper mapper) {
        try {
            PojoCloudEventData cloudEventData = (PojoCloudEventData)io.cloudevents.core.CloudEventUtils.mapData((CloudEvent)event, (CloudEventDataMapper)PojoCloudEventDataMapper.from((ObjectMapper)mapper, dataClass));
            if (cloudEventData == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(cloudEventData.getValue());
        }
        catch (CloudEventRWException e) {
            LOG.error("Unable to decode CloudEvent", (Throwable)e);
            return Optional.empty();
        }
    }

    public static Optional<String> urlEncodedStringFrom(String input) {
        return Optional.ofNullable(input).map(i -> {
            try {
                return URLEncoder.encode(i, StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                LOG.error("Unable to URL-encode string \"" + i + "\"", (Throwable)e);
                return null;
            }
        });
    }

    public static Optional<URI> urlEncodedURIFrom(String input) {
        return CloudEventUtils.urlEncodedStringFrom(input).map(encodedInput -> {
            try {
                return URI.create(encodedInput);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Unable to create URI from string \"" + encodedInput + "\"", (Throwable)e);
                return null;
            }
        });
    }

    public static URI buildDecisionSource(String serviceUrl) {
        return CloudEventUtils.buildDecisionSource(serviceUrl, null, null);
    }

    public static URI buildDecisionSource(String serviceUrl, String decisionModelName) {
        return CloudEventUtils.buildDecisionSource(serviceUrl, decisionModelName, null);
    }

    public static URI buildDecisionSource(String serviceUrl, String decisionModelName, String decisionServiceName) {
        String modelChunk = Optional.ofNullable(decisionModelName).filter(s -> !s.isEmpty()).flatMap(CloudEventUtils::urlEncodedStringFrom).orElse(null);
        String decisionChunk = Optional.ofNullable(decisionServiceName).filter(s -> !s.isEmpty()).flatMap(CloudEventUtils::urlEncodedStringFrom).orElse(null);
        String fullUrl = Stream.of(serviceUrl, modelChunk, decisionChunk).filter(s -> s != null && !s.isEmpty()).collect(Collectors.joining("/"));
        return URI.create(Optional.of(fullUrl).filter(s -> !s.isEmpty()).orElse(UNKNOWN_SOURCE_URI_STRING));
    }

    public static void withAttribute(CloudEventBuilder builder, String k, Object v) {
        if (v instanceof Integer) {
            builder.withContextAttribute(k, (Integer)v);
        } else if (v instanceof Boolean) {
            builder.withContextAttribute(k, (Boolean)v);
        } else if (v instanceof byte[]) {
            builder.withContextAttribute(k, (byte[])v);
        } else if (v instanceof URI) {
            builder.withContextAttribute(k, (URI)v);
        } else if (v instanceof OffsetDateTime) {
            builder.withContextAttribute(k, (OffsetDateTime)v);
        } else if (v instanceof ByteBuffer) {
            builder.withContextAttribute(k, ((ByteBuffer)v).array());
        } else if (v != null) {
            builder.withContextAttribute(k, v.toString());
        }
    }

    public static void withExtension(CloudEventBuilder builder, String k, Object v) {
        if (v instanceof Number) {
            builder.withExtension(k, (Number)v);
        } else if (v instanceof Boolean) {
            builder.withExtension(k, (Boolean)v);
        } else if (v instanceof byte[]) {
            builder.withExtension(k, (byte[])v);
        } else if (v instanceof URI) {
            builder.withExtension(k, (URI)v);
        } else if (v instanceof OffsetDateTime) {
            builder.withExtension(k, (OffsetDateTime)v);
        } else if (v instanceof ByteBuffer) {
            builder.withExtension(k, ((ByteBuffer)v).array());
        } else if (v != null) {
            builder.withExtension(k, v.toString());
        }
    }

    public static <T> CloudEventData fromObject(T data, PojoCloudEventData.ToBytes<T> toBytes) {
        if (data == null) {
            return null;
        }
        return data instanceof JsonNode ? JsonCloudEventData.wrap((JsonNode)((JsonNode)data)) : PojoCloudEventData.wrap(data, toBytes);
    }

    public static boolean isValidRequest(CloudEventContext context, String expectedType, CloudEventExtension extension) {
        return extension != null && expectedType.equals(context.getType());
    }

    public static boolean safeBoolean(Boolean bool) {
        return bool != null && bool != false;
    }

    public static void validateCloudEvent(Map<String, Object> cloudEvent) throws InvalidCloudEventException {
        SpecVersion specVersion = SpecVersion.parse((String)String.valueOf(cloudEvent.get("specversion")));
        BaseCloudEventValidator validator = specVersion == SpecVersion.V1 ? CloudEventValidatorV1.getInstance() : CloudEventValidatorV03.getInstance();
        validator.validateCloudEvent(cloudEvent);
    }

    public static List<String> getMissingAttributes(Map<String, Object> cloudEventInfo) {
        String specVersion = cloudEventInfo.getOrDefault("specversion", "1.0").toString();
        Set mandatoryAttributes = SpecVersion.parse((String)specVersion).getMandatoryAttributes();
        return mandatoryAttributes.stream().filter(Predicate.not(cloudEventInfo::containsKey)).collect(Collectors.toList());
    }

    public static final class Mapper {
        private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule((Module)JsonFormat.getCloudEventJacksonModule()).registerModule((Module)new JavaTimeModule());

        private Mapper() {
        }

        public static ObjectMapper mapper() {
            return OBJECT_MAPPER;
        }
    }
}

