/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.correlation;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.kie.kogito.correlation.CompositeCorrelation;
import org.kie.kogito.correlation.Correlation;
import org.kie.kogito.correlation.CorrelationEncoder;

public class MD5CorrelationEncoder
implements CorrelationEncoder {
    public String encode(Correlation<?> correlation) {
        try {
            String rawCorrelationString = this.encodeCorrelation(correlation);
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(rawCorrelationString.getBytes());
            return MD5CorrelationEncoder.bytesToHex(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    private String encodeCorrelation(Correlation<?> correlation) {
        if (correlation instanceof CompositeCorrelation) {
            CompositeCorrelation compositeCorrelation = (CompositeCorrelation)correlation;
            return compositeCorrelation.getValue().stream().map(this::encodeCorrelation).sorted().collect(Collectors.joining("|"));
        }
        return new StringJoiner("|").add(correlation.getKey()).add(correlation.asString()).toString();
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }
}

