/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEventData;
import io.cloudevents.core.data.PojoCloudEventData;
import io.cloudevents.jackson.JsonCloudEventData;
import io.cloudevents.jackson.PojoCloudEventDataMapper;
import java.io.IOException;
import java.util.Optional;
import org.kie.kogito.event.Converter;

public abstract class AbstractCloudEventDataConverter<O>
implements Converter<CloudEventData, O> {
    protected final ObjectMapper objectMapper;
    protected final Class<O> targetClass;

    protected AbstractCloudEventDataConverter(ObjectMapper objectMapper, Class<O> targetClass) {
        this.objectMapper = objectMapper;
        this.targetClass = targetClass;
    }

    public O convert(CloudEventData value) throws IOException {
        if (value == null) {
            return null;
        }
        Optional<O> target = this.isTargetInstanceAlready(value);
        return target.isPresent() ? target.get() : this.toValue(value.toBytes());
    }

    protected Optional<O> isTargetInstanceAlready(CloudEventData value) {
        if (value instanceof PojoCloudEventData) {
            Object pojo = ((PojoCloudEventData)value).getValue();
            return Optional.of(this.targetClass.isAssignableFrom(pojo.getClass()) ? this.targetClass.cast(pojo) : PojoCloudEventDataMapper.from((ObjectMapper)this.objectMapper, this.targetClass).map(value).getValue());
        }
        if (value instanceof JsonCloudEventData) {
            JsonNode node = ((JsonCloudEventData)value).getNode();
            return Optional.of(JsonNode.class.isAssignableFrom(this.targetClass) ? this.targetClass.cast(node) : this.objectMapper.convertValue((Object)node, this.targetClass));
        }
        return Optional.empty();
    }

    protected abstract O toValue(byte[] var1) throws IOException;
}

