/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.impl;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.EventDispatcher;
import org.kie.kogito.event.EventReceiver;
import org.kie.kogito.event.impl.ProcessEventDispatcher;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageConsumer<M extends Model, D> {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractMessageConsumer.class);
    private String trigger;
    private EventDispatcher<M, D> eventDispatcher;

    protected void init(Application application, Process<M> process, String trigger, EventReceiver eventReceiver, Class<D> dataClass, ProcessService processService, ExecutorService executorService, Set<String> correlations) {
        this.trigger = trigger;
        this.eventDispatcher = new ProcessEventDispatcher<M, D>(process, this.getModelConverter(), processService, executorService, correlations, this.getDataResolver());
        eventReceiver.subscribe(this::consume, dataClass);
        logger.info("Consumer for {} started", (Object)trigger);
    }

    protected Function<DataEvent<D>, D> getDataResolver() {
        return this::justData;
    }

    protected final D justData(DataEvent<D> dataEvent) {
        return (D)dataEvent.getData();
    }

    private CompletionStage<?> consume(DataEvent<D> payload) {
        logger.trace("Received {} for trigger {}", payload, (Object)this.trigger);
        return this.eventDispatcher.dispatch(this.trigger, payload).thenAccept(v -> logger.trace("Consume completed {} for trigger {}", (Object)payload, (Object)this.trigger));
    }

    protected Optional<Function<D, M>> getModelConverter() {
        return Optional.empty();
    }
}

