/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.impl;

import org.kie.kogito.event.DataEventFactory;
import org.kie.kogito.event.EventEmitter;
import org.kie.kogito.event.impl.MessageProducer;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageProducer<D>
implements MessageProducer<D> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMessageProducer.class);
    private String trigger;
    private EventEmitter emitter;

    public AbstractMessageProducer() {
    }

    public AbstractMessageProducer(EventEmitter emitter, String trigger) {
        this.init(emitter, trigger);
    }

    protected void init(EventEmitter emitter, String trigger) {
        this.emitter = emitter;
        this.trigger = trigger;
    }

    @Override
    public void produce(KogitoProcessInstance pi, D eventData) {
        this.emitter.emit(DataEventFactory.from(eventData, this.trigger, pi)).exceptionally(ex -> {
            logger.error("An error was caught while process " + pi.getProcessId() + " produced message " + eventData, ex);
            return null;
        });
    }
}

