/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.impl;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.kie.kogito.Addons;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.EventBatch;
import org.kie.kogito.event.EventManager;
import org.kie.kogito.event.EventPublisher;
import org.kie.kogito.event.impl.ProcessInstanceEventBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseEventManager
implements EventManager {
    private static final Logger logger = LoggerFactory.getLogger(BaseEventManager.class);
    private String service;
    private Addons addons;
    private Set<EventPublisher> publishers = new LinkedHashSet<EventPublisher>();

    public EventBatch newBatch() {
        return new ProcessInstanceEventBatch(this.service, this.addons);
    }

    public void publish(EventBatch batch) {
        if (this.publishers.isEmpty()) {
            return;
        }
        Collection events = batch.events();
        for (DataEvent event : events) {
            logger.debug("publishing {}", (Object)event);
        }
        this.publishers.forEach(p -> p.publish(events));
    }

    public void addPublisher(EventPublisher publisher) {
        this.publishers.add(publisher);
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setAddons(Addons addons) {
        this.addons = addons;
    }
}

