/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.impl;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import io.cloudevents.SpecVersion;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.kie.kogito.event.Converter;
import org.kie.kogito.event.DataEvent;

public class CloudEventWrapDataEvent<T>
implements DataEvent<T> {
    private final CloudEvent cloudEvent;
    private final Converter<CloudEventData, T> unmarshaller;
    private final AtomicReference<T> data;

    public CloudEventWrapDataEvent(CloudEvent cloudEvent, Converter<CloudEventData, T> unmarshaller) {
        Objects.requireNonNull(unmarshaller, "A cloudevent data wrapper should be associated to an unmarshaller");
        this.cloudEvent = cloudEvent;
        this.unmarshaller = unmarshaller;
        this.data = new AtomicReference();
    }

    public SpecVersion getSpecVersion() {
        return this.cloudEvent.getSpecVersion();
    }

    public String getId() {
        return this.cloudEvent.getId();
    }

    public String getType() {
        return this.cloudEvent.getType();
    }

    public URI getSource() {
        return this.cloudEvent.getSource();
    }

    public String getDataContentType() {
        return this.cloudEvent.getDataContentType();
    }

    public URI getDataSchema() {
        return this.cloudEvent.getDataSchema();
    }

    public String getSubject() {
        return this.cloudEvent.getSubject();
    }

    public OffsetDateTime getTime() {
        return this.cloudEvent.getTime();
    }

    public Object getAttribute(String attributeName) throws IllegalArgumentException {
        return this.cloudEvent.getAttribute(attributeName);
    }

    public Object getExtension(String extensionName) {
        return this.cloudEvent.getExtension(extensionName);
    }

    public Set<String> getExtensionNames() {
        return this.cloudEvent.getExtensionNames();
    }

    public T getData() {
        CloudEventData cloudEventData = this.cloudEvent.getData();
        if (cloudEventData == null) {
            return null;
        }
        Object result = this.data.get();
        if (result == null) {
            try {
                result = this.unmarshaller.convert((Object)cloudEventData);
                this.data.set(result);
            }
            catch (IOException io) {
                throw new UncheckedIOException(io);
            }
        }
        return result;
    }

    public String getKogitoProcessInstanceId() {
        return (String)this.getExtension("kogitoprocinstanceid");
    }

    public String getKogitoRootProcessInstanceId() {
        return (String)this.getExtension("kogitorootprociid");
    }

    public String getKogitoProcessId() {
        return (String)this.getExtension("kogitoprocid");
    }

    public String getKogitoRootProcessId() {
        return (String)this.getExtension("kogitorootprocid");
    }

    public String getKogitoAddons() {
        return (String)this.getExtension("kogitoaddons");
    }

    public String getKogitoParentProcessInstanceId() {
        return (String)this.getExtension("kogitoparentprociid");
    }

    public String getKogitoProcessInstanceState() {
        return (String)this.getExtension("kogitoprocist");
    }

    public String getKogitoReferenceId() {
        return (String)this.getExtension("kogitoprocrefid");
    }

    public String getKogitoBusinessKey() {
        return (String)this.getExtension("kogitobusinesskey");
    }

    public String getKogitoStartFromNode() {
        return (String)this.getExtension("kogitoprocstartfrom");
    }

    public String getKogitoProcessInstanceVersion() {
        return (String)this.getExtension("kogitoprocversion");
    }

    public String getKogitoProcessType() {
        return (String)this.getExtension("kogitoproctype");
    }

    public String getKogitoIdentity() {
        return (String)this.getExtension("kogitoidentity");
    }

    public CloudEvent asCloudEvent(Function<T, CloudEventData> factory) {
        return this.cloudEvent;
    }

    public String toString() {
        return "CloudEventWrapDataEvent [cloudEvent=" + this.cloudEvent + "]";
    }
}

