/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.impl;

import java.util.Collection;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.EventEmitter;
import org.kie.kogito.event.EventEmitterFactory;
import org.kie.kogito.event.EventFactory;
import org.kie.kogito.event.EventReceiver;
import org.kie.kogito.event.EventReceiverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventFactoryUtils {
    private static final Logger logger = LoggerFactory.getLogger(EventFactoryUtils.class);
    private static Collection<EventReceiverFactory> receivers = EventFactoryUtils.getSortedLoaders(EventReceiverFactory.class);
    private static Collection<EventEmitterFactory> emitters = EventFactoryUtils.getSortedLoaders(EventEmitterFactory.class);

    private static <V extends EventFactory<?>> Collection<V> getSortedLoaders(Class<V> clazz) {
        return ServiceLoader.load(clazz).stream().map(ServiceLoader.Provider::get).sorted().collect(Collectors.toList());
    }

    public static EventReceiver getEventReceiver(String trigger) {
        return EventFactoryUtils.getInstance(trigger, receivers, () -> new EventReceiver(){

            public <T> void subscribe(Function<DataEvent<T>, CompletionStage<?>> consumer, Class<T> dataClass) {
            }
        });
    }

    private static <T extends EventFactory<?>> void ready(Iterable<T> factories) {
        factories.forEach(EventFactory::ready);
    }

    private static <T extends AutoCloseable> void cleanUp(Iterable<T> closeables) {
        for (AutoCloseable closeable : closeables) {
            try {
                closeable.close();
            }
            catch (Exception ex) {
                logger.error("Error closing factory", (Throwable)ex);
            }
        }
    }

    public static EventEmitter getEventEmitter(String trigger) {
        return EventFactoryUtils.getInstance(trigger, emitters, () -> new EventEmitter(){

            public CompletionStage<Void> emit(DataEvent<?> dataEvent) {
                return CompletableFuture.completedStage(null);
            }
        });
    }

    private static <T, V extends Function<String, T>> T getInstance(String trigger, Collection<V> services, Supplier<T> defaultValue) {
        return (T)services.stream().map(s -> s.apply(trigger)).filter(Objects::nonNull).findFirst().orElseGet(defaultValue);
    }

    public static void cleanUp() {
        EventFactoryUtils.cleanUp(receivers);
        EventFactoryUtils.cleanUp(emitters);
    }

    public static void ready() {
        EventFactoryUtils.ready(receivers);
        EventFactoryUtils.ready(emitters);
    }

    private EventFactoryUtils() {
    }
}

